/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.JPQLCall;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseQuery
implements Cloneable,
Serializable {
    protected String name;
    protected Vector arguments;
    protected List<DatabaseField> argumentFields;
    protected Vector argumentValues;
    protected Vector argumentTypes;
    protected Vector argumentTypeNames;
    protected transient ClassDescriptor descriptor;
    protected DatabaseQueryMechanism queryMechanism;
    protected QueryRedirector redirector;
    protected boolean doNotRedirect = false;
    protected boolean shouldMaintainCache = true;
    protected Hashtable properties;
    protected transient AbstractSession session;
    protected transient AbstractSession executionSession;
    protected transient Accessor accessor;
    protected AbstractRecord translationRow;
    protected boolean isUserDefined = false;
    protected int cascadePolicy = 1;
    protected String sessionName;
    protected boolean isPrepared = false;
    protected boolean shouldCloneCall = false;
    protected boolean shouldPrepare = true;
    protected Boolean shouldBindAllParameters = null;
    protected Boolean shouldCacheStatement = null;
    protected boolean shouldUseWrapperPolicy = true;
    protected DatabaseMapping sourceMapping;
    protected int queryTimeout = -1;
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    public static final int CascadeDependentParts = 4;
    public static final int CascadeAggregateDelete = 5;
    public static final int CascadeByMapping = 6;
    protected String hintString;
    protected Boolean flushOnExecute;
    protected boolean isExecutionClone = false;
    protected Boolean isCustomQueryUsed;
    protected boolean isNativeConnectionRequired;

    public void addArgument(String argumentName) {
        this.addArgument(argumentName, Object.class);
    }

    public void addArgument(String argumentName, Class type) {
        this.getArguments().add(argumentName);
        this.getArgumentTypes().add(type);
        this.getArgumentTypeNames().add(type.getName());
    }

    public void addArgument(String argumentName, String typeAsString) {
        this.getArguments().add(argumentName);
        this.getArgumentTypes().add(Helper.getObjectClass(ConversionManager.loadClass(typeAsString)));
        this.getArgumentTypeNames().add(typeAsString);
    }

    public void addArgumentByTypeName(String argumentName, String typeAsString) {
        this.getArguments().addElement(argumentName);
        this.getArgumentTypeNames().addElement(typeAsString);
    }

    public void addArgumentValue(Object argumentValue) {
        this.getArgumentValues().addElement(argumentValue);
    }

    public void addArgumentValues(List theArgumentValues) {
        this.getArgumentValues().addAll(theArgumentValues);
    }

    public void addCall(Call call) {
        this.setQueryMechanism(call.buildQueryMechanism(this, this.getQueryMechanism()));
        this.setIsPrepared(false);
    }

    public void addStatement(SQLStatement statement) {
        if (!this.hasQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        } else if (!this.getQueryMechanism().isStatementQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        }
        ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatements().addElement(statement);
        this.setIsPrepared(false);
    }

    public void bindAllParameters() {
        this.setShouldBindAllParameters(true);
    }

    protected void buildSelectionCriteria(AbstractSession session) {
        this.getQueryMechanism().buildSelectionCriteria(session);
    }

    public void cacheStatement() {
        this.setShouldCacheStatement(true);
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadeByMapping() {
        this.setCascadePolicy(6);
    }

    public void cascadeOnlyDependentParts() {
        this.setCascadePolicy(4);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
    }

    public Object checkEarlyReturn(AbstractSession session, AbstractRecord translationRow) {
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        return null;
    }

    public void checkPrepare(AbstractSession session, AbstractRecord translationRow) {
        this.checkPrepare(session, translationRow, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPrepare(AbstractSession session, AbstractRecord translationRow, boolean force) {
        if (!this.isPrepared()) {
            session.startOperationProfile("query prepare", this, Integer.MAX_VALUE);
            if (!force && this.shouldPrepare() && this.checkForCustomQuery(session, translationRow) != null) {
                session.endOperationProfile("query prepare", this, Integer.MAX_VALUE);
                return;
            }
            DatabaseQuery databaseQuery = this;
            synchronized (databaseQuery) {
                if (!this.isPrepared()) {
                    if ((this.isReadQuery() || this.isDataModifyQuery()) && this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism && (translationRow == null || translationRow.isEmpty())) {
                        if (this.isReadObjectQuery() || this.isUserDefined()) {
                            ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                        }
                    } else if (this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism) {
                        ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                    }
                    this.setSession(session);
                    this.prepare();
                    this.setSession(null);
                    this.setIsPrepared(true);
                }
            }
            session.endOperationProfile("query prepare", this, Integer.MAX_VALUE);
        }
    }

    public Object clone() {
        try {
            DatabaseQuery cloneQuery = (DatabaseQuery)super.clone();
            cloneQuery.sourceMapping = this.sourceMapping;
            if (cloneQuery.properties != null) {
                if (cloneQuery.properties.isEmpty()) {
                    cloneQuery.setProperties(null);
                } else {
                    cloneQuery.setProperties((Hashtable)this.getProperties().clone());
                }
            }
            if (this.hasQueryMechanism()) {
                cloneQuery.setQueryMechanism(this.getQueryMechanism().clone(cloneQuery));
            }
            cloneQuery.setIsPrepared(this.isPrepared());
            return cloneQuery;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery query, AbstractSession session) {
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public void dontBindAllParameters() {
        this.setShouldBindAllParameters(false);
    }

    public void dontCacheStatement() {
        this.setShouldCacheStatement(false);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public void dontMaintainCache() {
        this.setShouldMaintainCache(false);
    }

    public abstract Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException;

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        return this.execute(unitOfWork, translationRow);
    }

    public Object execute(AbstractSession session, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        DatabaseQuery customQuery;
        Object earlyReturn;
        DatabaseQuery queryToExecute = this;
        QueryRedirector localRedirector = this.getRedirector();
        if (localRedirector != null) {
            return this.redirectQuery(localRedirector, queryToExecute, session, translationRow);
        }
        if (queryToExecute.isCustomSelectionQuery() && queryToExecute.shouldPrepare()) {
            queryToExecute.checkPrepare(session, translationRow);
        }
        if ((earlyReturn = queryToExecute.checkEarlyReturn(session, translationRow)) == InvalidObject.instance) {
            return null;
        }
        if (earlyReturn != null) {
            return earlyReturn;
        }
        boolean hasCustomQuery = false;
        if (!this.isPrepared() && this.shouldPrepare() && (customQuery = this.checkForCustomQuery(session, translationRow)) != null) {
            hasCustomQuery = true;
            queryToExecute = customQuery;
        }
        if ((queryToExecute = session.prepareDatabaseQuery(queryToExecute)).shouldPrepare()) {
            queryToExecute.checkPrepare(session, translationRow);
        }
        if (!queryToExecute.isExecutionClone()) {
            queryToExecute = (DatabaseQuery)queryToExecute.clone();
        }
        queryToExecute.setTranslationRow(translationRow);
        if (!queryToExecute.shouldPrepare()) {
            queryToExecute.checkPrepare(session, translationRow);
        }
        queryToExecute.setSession(session);
        if (hasCustomQuery) {
            this.prepareCustomQuery(queryToExecute);
            localRedirector = queryToExecute.getRedirector();
            if (localRedirector != null) {
                return this.redirectQuery(localRedirector, queryToExecute, session, queryToExecute.getTranslationRow());
            }
        }
        queryToExecute.prepareForExecution();
        Object result = queryToExecute.executeDatabaseQuery();
        this.clonedQueryExecutionComplete(queryToExecute, session);
        return result;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = NonSynchronizedVector.newInstance();
        }
        return this.arguments;
    }

    public Vector getArgumentTypes() {
        if (this.argumentTypes == null || this.argumentTypes.isEmpty()) {
            this.argumentTypes = new Vector();
            if (this.argumentTypeNames != null) {
                for (String argumentTypeName : this.argumentTypeNames) {
                    this.argumentTypes.addElement(Helper.getObjectClass(ConversionManager.loadClass(argumentTypeName)));
                }
            }
        }
        return this.argumentTypes;
    }

    public Vector getArgumentTypeNames() {
        if (this.argumentTypeNames == null) {
            this.argumentTypeNames = NonSynchronizedVector.newInstance();
        }
        return this.argumentTypeNames;
    }

    public void setArgumentTypes(Vector argumentTypes) {
        this.argumentTypes = argumentTypes;
        this.getArgumentTypeNames().clear();
        Iterator types = argumentTypes.iterator();
        while (types.hasNext()) {
            this.argumentTypeNames.addElement(((Class)types.next()).getName());
        }
    }

    public void setArgumentTypeNames(Vector argumentTypeNames) {
        this.argumentTypeNames = argumentTypeNames;
    }

    public void setArguments(Vector arguments) {
        Vector<Class<Object>> types = new Vector<Class<Object>>(arguments.size());
        Vector<String> typeNames = new Vector<String>(arguments.size());
        Vector<DatabaseField> typeFields = new Vector<DatabaseField>(arguments.size());
        int size = arguments.size();
        for (int index = 0; index < size; ++index) {
            types.add(Object.class);
            typeNames.add("java.lang.Object");
            DatabaseField field = new DatabaseField((String)arguments.get(index));
            typeFields.add(field);
        }
        this.arguments = arguments;
        this.argumentTypes = types;
        this.argumentTypeNames = typeNames;
        this.argumentFields = typeFields;
    }

    public Vector getArgumentValues() {
        if (this.argumentValues == null) {
            this.argumentValues = NonSynchronizedVector.newInstance();
        }
        return this.argumentValues;
    }

    public void setArgumentValues(Vector theArgumentValues) {
        this.argumentValues = theArgumentValues;
    }

    public DatabaseCall getCall() {
        Call call = this.getDatasourceCall();
        if (call instanceof DatabaseCall) {
            return (DatabaseCall)call;
        }
        return null;
    }

    public Call getDatasourceCall() {
        Call call = null;
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism mechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            call = mechanism.getCall();
            if (mechanism.hasMultipleCalls()) {
                call = (Call)mechanism.getCalls().get(0);
            }
        }
        if (call == null && this.getQueryMechanism().isJPQLCallQueryMechanism()) {
            call = ((JPQLCallQueryMechanism)this.getQueryMechanism()).getJPQLCall();
        }
        return call;
    }

    public List getDatasourceCalls() {
        Vector calls = new Vector();
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism mechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            if (mechanism.hasMultipleCalls()) {
                calls = mechanism.getCalls();
            } else {
                calls.add(mechanism.getCall());
            }
        }
        if (calls.isEmpty() && this.getQueryMechanism().isJPQLCallQueryMechanism()) {
            calls.add(((JPQLCallQueryMechanism)this.getQueryMechanism()).getJPQLCall());
        }
        return calls;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(5);
        }
        return this.properties;
    }

    public synchronized Object getProperty(Object property) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(property);
    }

    public DatabaseQueryMechanism getQueryMechanism() {
        if (this.queryMechanism == null) {
            this.queryMechanism = new ExpressionQueryMechanism(this);
        }
        return this.queryMechanism;
    }

    public boolean hasQueryMechanism() {
        return this.queryMechanism != null;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultQueryRedirector();
    }

    public QueryRedirector getRedirector() {
        if (this.doNotRedirect) {
            return null;
        }
        if (this.redirector != null) {
            return this.redirector;
        }
        if (this.descriptor != null) {
            this.redirector = this.getDefaultRedirector();
            if (this.redirector == null) {
                this.doNotRedirect = true;
            }
            return this.redirector;
        }
        return null;
    }

    public Class getReferenceClass() {
        return null;
    }

    public String getReferenceClassName() {
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.getQueryMechanism().getSelectionCriteria();
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public AbstractSession getExecutionSession() {
        if (this.executionSession == null && this.getSession() != null) {
            this.executionSession = this.getSession().getExecutionSession(this);
        }
        return this.executionSession;
    }

    protected void setExecutionSession(AbstractSession executionSession) {
        this.executionSession = executionSession;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SQLStatement getSQLStatement() {
        return ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatement();
    }

    public String getJPQLString() {
        return this.getEJBQLString();
    }

    public String getEJBQLString() {
        if (!this.getQueryMechanism().isJPQLCallQueryMechanism()) {
            return null;
        }
        JPQLCall call = ((JPQLCallQueryMechanism)this.getQueryMechanism()).getJPQLCall();
        return call.getEjbqlString();
    }

    public String getHintString() {
        return this.hintString;
    }

    public String getSQLString() {
        Call call = this.getDatasourceCall();
        if (call == null) {
            return null;
        }
        if (!(call instanceof SQLCall)) {
            return null;
        }
        return ((SQLCall)call).getSQLString();
    }

    public List getSQLStrings() {
        List calls = this.getDatasourceCalls();
        if (calls == null || calls.isEmpty()) {
            return null;
        }
        Vector<String> returnSQL = new Vector<String>(calls.size());
        for (Call call : calls) {
            if (!(call instanceof SQLCall)) {
                return null;
            }
            returnSQL.addElement(((SQLCall)call).getSQLString());
        }
        return returnSQL;
    }

    public Boolean getShouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public DatabaseMapping getSourceMapping() {
        return this.sourceMapping;
    }

    public String getTranslatedSQLString(Session session, Record translationRow) {
        this.prepareCall(session, translationRow);
        CallQueryMechanism queryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (queryMechanism.getCall() == null) {
            return null;
        }
        SQLCall call = (SQLCall)queryMechanism.getCall().clone();
        call.setUsesBinding(false);
        call.translate((AbstractRecord)translationRow, queryMechanism.getModifyRow(), (AbstractSession)session);
        return call.getSQLString();
    }

    public List getTranslatedSQLStrings(Session session, Record translationRow) {
        this.prepareCall(session, translationRow);
        CallQueryMechanism queryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (queryMechanism.getCalls() == null || queryMechanism.getCalls().isEmpty()) {
            return null;
        }
        Vector<String> calls = new Vector<String>(queryMechanism.getCalls().size());
        for (SQLCall call : queryMechanism.getCalls()) {
            call = (SQLCall)call.clone();
            call.setUsesBinding(false);
            call.translate((AbstractRecord)translationRow, queryMechanism.getModifyRow(), (AbstractSession)session);
            calls.add(call.getSQLString());
        }
        return calls;
    }

    public AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public boolean hasAccessor() {
        return this.accessor != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public boolean hasSessionName() {
        return this.sessionName != null;
    }

    public void ignoreBindAllParameters() {
        this.shouldBindAllParameters = null;
    }

    public void ignoreCacheStatement() {
        this.shouldCacheStatement = null;
    }

    public boolean isCallQuery() {
        return this.getQueryMechanism().isCallQueryMechanism();
    }

    public boolean isCascadeOfAggregateDelete() {
        return this.getCascadePolicy() == 5;
    }

    public boolean isDataModifyQuery() {
        return false;
    }

    public boolean isDataReadQuery() {
        return false;
    }

    public boolean isValueReadQuery() {
        return false;
    }

    public boolean isDirectReadQuery() {
        return false;
    }

    public boolean isDeleteAllQuery() {
        return false;
    }

    public boolean isDeleteObjectQuery() {
        return false;
    }

    public boolean isExpressionQuery() {
        return this.getQueryMechanism().isExpressionQueryMechanism();
    }

    public boolean isModifyAllQuery() {
        return false;
    }

    public boolean isModifyQuery() {
        return false;
    }

    public boolean isUpdateAllQuery() {
        return false;
    }

    public boolean isUpdateObjectQuery() {
        return false;
    }

    public Boolean getFlushOnExecute() {
        return this.flushOnExecute;
    }

    public boolean isInsertObjectQuery() {
        return false;
    }

    public boolean isObjectLevelModifyQuery() {
        return false;
    }

    public boolean isObjectLevelReadQuery() {
        return false;
    }

    public boolean isObjectBuildingQuery() {
        return false;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public boolean isReadAllQuery() {
        return false;
    }

    public boolean isReadObjectQuery() {
        return false;
    }

    public boolean isReadQuery() {
        return false;
    }

    public boolean isReportQuery() {
        return false;
    }

    public boolean isSQLCallQuery() {
        Call call = this.getDatasourceCall();
        return call != null && call instanceof SQLCall;
    }

    public boolean isJPQLCallQuery() {
        Call call = this.getDatasourceCall();
        return call != null && call instanceof JPQLCall;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public boolean isDefaultPropertiesQuery() {
        return !this.isUserDefined() && this.shouldPrepare() && this.getQueryTimeout() == -1 && this.getHintString() == null && this.shouldIgnoreBindAllParameters() && this.shouldIgnoreCacheStatement() && this.shouldUseWrapperPolicy();
    }

    public boolean isWriteObjectQuery() {
        return false;
    }

    public void maintainCache() {
        this.setShouldMaintainCache(true);
    }

    protected void prepare() throws QueryException {
        if (this.getQueryTimeout() == -1) {
            if (this.getDescriptor() == null) {
                this.setQueryTimeout(0);
            } else {
                this.setQueryTimeout(this.getDescriptor().getQueryManager().getQueryTimeout());
            }
        }
        if (this.getQueryTimeout() == -1 || this.getQueryTimeout() == 0) {
            this.setQueryTimeout(this.session.getQueryTimeoutDefault());
        }
        this.argumentFields = this.buildArgumentFields();
        this.getQueryMechanism().prepare();
    }

    public void copyFromQuery(DatabaseQuery query) {
        this.prepareFromQuery(query);
        this.cascadePolicy = query.cascadePolicy;
        this.flushOnExecute = query.flushOnExecute;
        this.arguments = query.arguments;
        this.argumentTypes = query.argumentTypes;
        this.argumentTypeNames = query.argumentTypeNames;
        this.argumentValues = query.argumentValues;
        this.queryTimeout = query.queryTimeout;
        this.redirector = query.redirector;
        this.sessionName = query.sessionName;
        this.shouldBindAllParameters = query.shouldBindAllParameters;
        this.shouldCacheStatement = query.shouldCacheStatement;
        this.shouldMaintainCache = query.shouldMaintainCache;
        this.shouldPrepare = query.shouldPrepare;
        this.shouldUseWrapperPolicy = query.shouldUseWrapperPolicy;
        this.properties = query.properties;
    }

    public void prepareFromQuery(DatabaseQuery query) {
        this.setQueryMechanism((DatabaseQueryMechanism)query.getQueryMechanism().clone());
        this.getQueryMechanism().setQuery(this);
        this.descriptor = query.descriptor;
        this.hintString = query.hintString;
        this.isCustomQueryUsed = query.isCustomQueryUsed;
        this.argumentFields = query.argumentFields;
    }

    public void prepareCall(Session session, Record translationRow) throws QueryException {
        this.checkPrepare((AbstractSession)session, (AbstractRecord)translationRow, true);
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
    }

    public void prepareForExecution() throws QueryException {
    }

    protected void prepareForRemoteExecution() {
    }

    public Object redirectQuery(QueryRedirector redirector, DatabaseQuery queryToRedirect, AbstractSession session, AbstractRecord translationRow) {
        if (redirector == null) {
            return null;
        }
        DatabaseQuery queryToExecute = (DatabaseQuery)queryToRedirect.clone();
        queryToExecute.setRedirector(null);
        Object toReturn = redirector.invokeQuery(queryToExecute, translationRow, session);
        this.setDescriptor(queryToExecute.getDescriptor());
        return toReturn;
    }

    protected Object remoteExecute() {
        Transporter transporter = ((RemoteSession)this.getSession()).getRemoteConnection().remoteExecute((DatabaseQuery)this.clone());
        return this.extractRemoteResult(transporter);
    }

    public Object remoteExecute(AbstractSession session) {
        this.setSession(session);
        this.prepareForRemoteExecution();
        return this.remoteExecute();
    }

    public void removeProperty(Object property) {
        this.getProperties().remove(property);
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return null;
    }

    public List<DatabaseField> buildArgumentFields() {
        Vector arguments = this.getArguments();
        Vector argumentTypes = this.getArgumentTypes();
        ArrayList<DatabaseField> argumentFields = new ArrayList<DatabaseField>(arguments.size());
        int size = arguments.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField argumentField = new DatabaseField((String)arguments.get(index));
            argumentField.setType((Class)argumentTypes.get(index));
            argumentFields.add(argumentField);
        }
        return argumentFields;
    }

    public AbstractRecord rowFromArguments(List argumentValues) throws QueryException {
        List<DatabaseField> argumentFields = this.argumentFields;
        if (!this.isPrepared() || argumentFields == null) {
            argumentFields = this.buildArgumentFields();
        }
        if (argumentFields.size() != argumentValues.size()) {
            throw QueryException.argumentSizeMismatchInQueryAndQueryDefinition(this);
        }
        int argumentsSize = argumentFields.size();
        DatabaseRecord row = new DatabaseRecord(argumentsSize);
        for (int index = 0; index < argumentsSize; ++index) {
            row.put(argumentFields.get(index), argumentValues.get(index));
        }
        return row;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setDatasourceCall(Call call) {
        if (call == null) {
            return;
        }
        this.setQueryMechanism(call.buildNewQueryMechanism(this));
    }

    public void setCall(Call call) {
        this.setDatasourceCall(call);
    }

    public void setCascadePolicy(int policyConstant) {
        this.cascadePolicy = policyConstant;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        if (this.descriptor != descriptor) {
            this.setIsPrepared(false);
        }
        this.descriptor = descriptor;
    }

    public void setJPQLString(String jpqlString) {
        this.setEJBQLString(jpqlString);
    }

    public void setEJBQLString(String ejbqlString) {
        if (ejbqlString != null && !ejbqlString.equals("")) {
            JPQLCallQueryMechanism mechanism = new JPQLCallQueryMechanism(this, new JPQLCall(ejbqlString));
            this.setQueryMechanism(mechanism);
        }
    }

    public void setFlushOnExecute(Boolean flushMode) {
        this.flushOnExecute = flushMode;
    }

    public void setHintString(String newHintString) {
        this.hintString = newHintString;
        this.setIsPrepared(false);
    }

    public void setIsPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
        this.isCustomQueryUsed = null;
    }

    public boolean isExecutionClone() {
        return this.isExecutionClone;
    }

    public void setIsExecutionClone(boolean isExecutionClone) {
        this.isExecutionClone = isExecutionClone;
    }

    public Boolean isCustomQueryUsed() {
        return this.isCustomQueryUsed;
    }

    protected boolean isCustomSelectionQuery() {
        return this.getQueryMechanism().isCallQueryMechanism() && this.getArguments().isEmpty();
    }

    protected void setIsCustomQueryUsed(boolean isCustomQueryUsed) {
        this.isCustomQueryUsed = isCustomQueryUsed ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setIsUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
    }

    public void setName(String queryName) {
        this.name = queryName;
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public synchronized void setProperty(Object property, Object value) {
        this.getProperties().put(property, value);
    }

    protected void setQueryMechanism(DatabaseQueryMechanism queryMechanism) {
        this.queryMechanism = queryMechanism;
        this.setIsPrepared(false);
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        this.shouldCloneCall = true;
    }

    public void setRedirector(QueryRedirector redirector) {
        this.redirector = redirector;
        this.doNotRedirect = false;
    }

    public void setSelectionCriteria(Expression expression) {
        if (expression == null && !this.getQueryMechanism().isExpressionQueryMechanism()) {
            return;
        }
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            this.setQueryMechanism(new ExpressionQueryMechanism(this, expression));
        } else {
            ((ExpressionQueryMechanism)this.getQueryMechanism()).setSelectionCriteria(expression);
        }
        this.setIsPrepared(false);
    }

    public void setSession(AbstractSession session) {
        this.session = session;
        this.executionSession = null;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setShouldBindAllParameters(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters;
        this.setIsPrepared(false);
    }

    public void setShouldBindAllParameters(Boolean bindAllParams) {
        this.shouldBindAllParameters = bindAllParams;
    }

    public void setShouldCacheStatement(boolean shouldCacheStatement) {
        this.shouldCacheStatement = shouldCacheStatement;
        this.setIsPrepared(false);
    }

    public void setShouldMaintainCache(boolean shouldMaintainCache) {
        this.shouldMaintainCache = shouldMaintainCache;
    }

    public void setShouldPrepare(boolean shouldPrepare) {
        this.shouldPrepare = shouldPrepare;
        this.setIsPrepared(false);
    }

    public void setShouldUseWrapperPolicy(boolean shouldUseWrapperPolicy) {
        this.shouldUseWrapperPolicy = shouldUseWrapperPolicy;
    }

    public void setSourceMapping(DatabaseMapping sourceMapping) {
        this.sourceMapping = sourceMapping;
    }

    public void setSQLStatement(SQLStatement sqlStatement) {
        this.setQueryMechanism(new StatementQueryMechanism(this, sqlStatement));
    }

    public void setSQLString(String sqlString) {
        if (sqlString != null && !sqlString.equals("")) {
            this.setCall(new SQLCall(sqlString));
        }
    }

    public void setTranslationRow(AbstractRecord translationRow) {
        this.translationRow = translationRow;
    }

    public boolean shouldBindAllParameters() {
        return Boolean.TRUE.equals(this.shouldBindAllParameters);
    }

    public boolean shouldCacheStatement() {
        return Boolean.TRUE.equals(this.shouldCacheStatement);
    }

    public boolean shouldCascadeAllParts() {
        return this.cascadePolicy == 3;
    }

    public boolean shouldCascadeByMapping() {
        return this.cascadePolicy == 6;
    }

    public boolean shouldCascadeOnlyDependentParts() {
        return this.cascadePolicy == 4;
    }

    public boolean shouldCascadeParts() {
        return this.cascadePolicy != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.cascadePolicy == 2 || this.cascadePolicy == 3;
    }

    public boolean shouldCloneCall() {
        return this.shouldCloneCall;
    }

    public boolean shouldIgnoreBindAllParameters() {
        return this.shouldBindAllParameters == null;
    }

    public boolean shouldIgnoreCacheStatement() {
        return this.shouldCacheStatement == null;
    }

    public boolean shouldMaintainCache() {
        return this.shouldMaintainCache;
    }

    public boolean shouldPrepare() {
        return this.shouldPrepare;
    }

    public boolean shouldUseWrapperPolicy() {
        return this.shouldUseWrapperPolicy;
    }

    public String toString() {
        String referenceClassString = "";
        String nameString = "";
        String queryString = "";
        if (this.getReferenceClass() != null) {
            referenceClassString = "referenceClass=" + this.getReferenceClass().getSimpleName() + " ";
        }
        if (this.getName() != null && !this.getName().equals("")) {
            nameString = "name=\"" + this.getName() + "\" ";
        }
        if (this.isSQLCallQuery()) {
            queryString = "sql=\"" + this.getSQLString() + "\"";
        } else if (this.isJPQLCallQuery()) {
            queryString = "jpql=\"" + this.getJPQLString() + "\"";
        }
        return this.getClass().getSimpleName() + "(" + nameString + referenceClassString + queryString + ")";
    }

    public String getDomainClassNounName(String sessionName) {
        if (this.getProperty("DMSDomainClassNounName") == null) {
            StringBuffer buffer = new StringBuffer("EclipseLink");
            if (sessionName != null) {
                buffer.append(sessionName);
            }
            if (this.getReferenceClassName() != null) {
                buffer.append("_");
                buffer.append(this.getReferenceClassName());
            }
            this.setProperty("DMSDomainClassNounName", buffer.toString());
        }
        return (String)this.getProperty("DMSDomainClassNounName");
    }

    public String getQueryNounName(String sessionName) {
        if (this.getProperty("DMSQueryNounName") == null) {
            StringBuffer buffer = new StringBuffer(this.getDomainClassNounName(sessionName));
            buffer.append("_");
            buffer.append(this.getClass().getSimpleName());
            if (this.getName() != null) {
                buffer.append("_");
                buffer.append(this.getName());
            }
            this.setProperty("DMSQueryNounName", buffer.toString());
        }
        return (String)this.getProperty("DMSQueryNounName");
    }

    public String getSensorName(String operationName, String sessionName) {
        Object sensorName;
        if (operationName == null) {
            return this.getQueryNounName(sessionName);
        }
        Hashtable sensorNames = (Hashtable)this.getProperty("DMSSensorNames");
        if (sensorNames == null) {
            sensorNames = new Hashtable();
            this.setProperty("DMSSensorNames", sensorNames);
        }
        if ((sensorName = sensorNames.get(operationName)) == null) {
            StringBuffer buffer = new StringBuffer(this.getQueryNounName(sessionName));
            buffer.append("_");
            buffer.append(operationName);
            sensorName = buffer.toString();
            sensorNames.put(operationName, sensorName);
        }
        return (String)sensorName;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    public boolean getDoNotRedirect() {
        return this.doNotRedirect;
    }

    public void setDoNotRedirect(boolean doNotRedirect) {
        this.doNotRedirect = doNotRedirect;
    }
}

