/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.util.Hashtable;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlIndexTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;

public class Typemap {
    public static final int UNSUPPORTED_TYPE = 0;
    public static final int BYTE_ARRAY = 1;
    public static final int DOUBLE = 2;
    public static final int FLOAT = 3;
    public static final int INT = 4;
    public static final int SHORT = 5;
    public static final int BOOLEAN = 6;
    public static final int OS_BFILE = 7;
    public static final int OS_BLOB = 8;
    public static final int OS_CHAR = 9;
    public static final int OS_CLOB = 10;
    public static final int OS_DATE = 11;
    public static final int OS_NUMBER = 12;
    public static final int OS_RAW = 13;
    public static final int OS_ROWID = 14;
    public static final int OS_NCHAR = 15;
    public static final int OS_NCLOB = 16;
    public static final int OS_BINARY_FLOAT = 17;
    public static final int OS_BINARY_DOUBLE = 18;
    public static final int OS_TIMESTAMP = 19;
    public static final int OS_TIMESTAMPTZ = 20;
    public static final int OS_TIMESTAMPLTZ = 21;
    public static final int OS_CUSTOMDATUM = 22;
    public static final int OS_NSTRING = 23;
    public static final int JL_DOUBLE = 24;
    public static final int JL_FLOAT = 25;
    public static final int JL_INTEGER = 26;
    public static final int JL_SHORT = 27;
    public static final int JL_STRING = 28;
    public static final int JM_BIGDECIMAL = 29;
    public static final int JS_ARRAY = 30;
    public static final int JS_BLOB = 31;
    public static final int JS_CLOB = 32;
    public static final int JS_REF = 33;
    public static final int JS_RESULTSET = 34;
    public static final int JS_SQLDATA = 35;
    public static final int JS_DATE = 36;
    public static final int JS_TIMESTAMP = 37;
    public static final int OCI_BFILELOCATOR = 38;
    public static final int OCI_BLOBLOCATOR = 39;
    public static final int OCI_CLOBLOCATOR = 40;
    public static final int OCI_DATE = 41;
    public static final int OCI_DATETIME = 42;
    public static final int OCI_INTERVAL = 43;
    public static final int OCI_NUMBER = 44;
    public static final int OCI_RAW = 45;
    public static final int OCI_STRING = 46;
    public static final int C_GENERATEDTYPE = 47;
    public static final int OCI_TABLE = 48;
    public static final int OCCI_BFILE = 49;
    public static final int OCCI_BYTES = 50;
    public static final int OCCI_BLOB = 51;
    public static final int OCCI_CLOB = 52;
    public static final int OCCI_DATE = 53;
    public static final int OCCI_TIMESTAMP = 54;
    public static final int OCCI_INTERVALYM = 55;
    public static final int OCCI_INTERVALDS = 56;
    public static final int OCCI_NUMBER = 57;
    public static final int CPP_STRING = 58;
    public static final int CPP_WSTRING = 59;
    public static final int OCCI_COLLECTION = 60;
    public static final int OCCI_REF = 61;
    public static final int OCCI_OBJ = 62;
    public static final int OCCI_COLLECTION_OF_REFS = 63;
    private static final int ORACLE_TYPES_BINARY_DOUBLE = 101;
    private static final int ORACLE_TYPES_BINARY_FLOAT = 100;
    private static final int ORACLE_TYPES_JAVA_STRUCT = 2008;
    private static final int ORACLE_TYPES_OPAQUE = 2007;
    private static final int ORACLE_TYPES_TIMESTAMPLTZ = -102;
    private static final int ORACLE_TYPES_TIMESTAMPTZ = -101;
    protected boolean m_mapInitialized = false;
    protected String m_package;
    protected Hashtable m_field_map = null;
    protected int m_mapping;
    protected int arrayMap;
    protected int bfileMap;
    protected int binaryMap;
    protected int blobMap;
    protected int charMap;
    protected int ncharMap;
    protected int clobMap;
    protected int cursorMap;
    protected int dateMap;
    protected int timeMap;
    protected int timestampMap;
    protected int intervalYMMap;
    protected int intervalDSMap;
    protected int decimalMap;
    protected int doubleMap;
    protected int floatMap;
    protected int integerMap;
    protected int longVarBinaryMap;
    protected int numericMap;
    protected int realMap;
    protected int refMap;
    protected int rowidMap;
    protected int smallintMap;
    protected int structMap;
    protected int varcharMap;
    protected int tableMap;
    protected int binaryFloatMap;
    protected int binaryDoubleMap;
    protected SqlReflector m_reflector;
    static final String[] NAMES = new String[]{"<unsupported type>", "byte[]", "double", "float", "int", "short", "boolean", "oracle.sql.BFILE", "oracle.sql.BLOB", "oracle.sql.CHAR", "oracle.sql.CLOB", "oracle.sql.DATE", "oracle.sql.NUMBER", "oracle.sql.RAW", "oracle.sql.ROWID", "oracle.sql.NCHAR", "oracle.sql.NCLOB", "oracle.sql.BINARY_FLOAT", "oracle.sql.BINARY_DOUBLE", "oracle.sql.TIMESTAMP", "oracle.sql.TIMESTAMPTZ", "oracle.sql.TIMESTAMPLTZ", null, "java.lang.String", "Double", "Float", "Integer", "Short", "String", "java.math.BigDecimal", "java.sql.Array", "java.sql.Blob", "java.sql.Clob", "java.sql.Ref", "java.sql.ResultSet", null, "java.sql.Date", "java.sql.Timestamp", "OCIBFileLocator *", "OCIBlobLocator *", "OCIClobLocator *", "OCIDate", "OCIDateTime *", "OCIInterval *", "OCINumber", "OCIRaw *", "OCIString *", null, null, "oracle::occi::Bfile", "oracle::occi::Bytes", "oracle::occi::Blob", "oracle::occi::Clob", "oracle::occi::Date", "oracle::occi::Timestamp", "oracle::occi::IntervalYM", "oracle::occi::IntervalDS", "oracle::occi::Number", "OCCI_STD_NAMESPACE::string", "OCCI_STD_NAMESPACE::wstring", null, null, null, null};
    static final String[] ACCESSOR_METHODS = new String[]{null, "Bytes", "Double", "Float", "Int", "Short", "Boolean", "BFILE", "BLOB", "CHAR", "CLOB", "DATE", "NUMBER", "RAW", "ROWID", "NCHAR", "NCLOB", "Object", "Object", "TIMESTAMP", "TIMESTAMPTZ", "TIMESTAMPLTZ", null, "String", "Double", "Float", "Int", "Short", "String", "BigDecimal", "Array", "Blob", "Clob", "Ref", "Cursor", null, "Date", "Timestamp", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};

    public Typemap(TypeClass s, SqlReflector reflector) {
        if (s != null && s instanceof JavaType) {
            this.m_field_map = null;
            this.m_package = s.getNameObject().getDeclPackage();
        } else if (s != null) {
            SqlName sn = ((SqlType)s).getSqlName();
            this.m_field_map = ((SqlType)s).getAttributes();
            this.m_package = sn.getDeclPackage();
        }
        this.m_reflector = reflector;
        this.mapInit();
    }

    void mapInit() {
        this.bfileMap = 7;
        this.cursorMap = 34;
        this.rowidMap = 14;
    }

    public String getMemberName(String sqlName, boolean wordBoundary, boolean onlyIfRegistered, Name name) {
        return null;
    }

    public String getMemberNameAsSuffix(String sqlName) {
        return null;
    }

    public String getMemberName(String sqlName, Name name) {
        return this.getMemberName(sqlName, false, false, name);
    }

    public String getMemberName(String sqlName) {
        return this.getMemberName(sqlName, false, false, null);
    }

    public String getMemberName(String sqlName, boolean wordBoundary, boolean onlyIfRegistered) {
        return this.getMemberName(sqlName, wordBoundary, onlyIfRegistered, null);
    }

    public String writeTypeName(TypeClass type) {
        return null;
    }

    public String writeTypeName(TypeClass type, boolean itfIfPossible) {
        return null;
    }

    public int getMapping() {
        return this.m_mapping;
    }

    public int getJavaTypecode(int sqlTypecode) {
        if (!this.m_mapInitialized) {
            this.javaMapping();
            this.m_mapInitialized = true;
        }
        switch (sqlTypecode) {
            case 2003: {
                return this.arrayMap;
            }
            case -13: {
                return this.bfileMap;
            }
            case -2: {
                return this.binaryMap;
            }
            case 2004: {
                return this.blobMap;
            }
            case 1: {
                return this.charMap;
            }
            case 2005: {
                return this.clobMap;
            }
            case -10: {
                return this.cursorMap;
            }
            case 91: {
                return this.dateMap;
            }
            case 92: {
                return this.timeMap;
            }
            case 93: {
                return this.timestampMap;
            }
            case -101: {
                return this.timestampMap == 37 ? this.timestampMap : 20;
            }
            case -102: {
                return 21;
            }
            case 1994: {
                return this.intervalYMMap;
            }
            case 1993: {
                return this.intervalDSMap;
            }
            case 3: {
                return this.decimalMap;
            }
            case 8: {
                return this.doubleMap;
            }
            case 6: {
                return this.floatMap;
            }
            case 4: {
                return this.integerMap;
            }
            case -4: {
                return this.longVarBinaryMap;
            }
            case 2: {
                return this.numericMap;
            }
            case 2007: {
                return 22;
            }
            case 2008: {
                return this.structMap;
            }
            case 7: {
                return this.realMap;
            }
            case 2006: {
                return this.refMap;
            }
            case -8: {
                return this.rowidMap;
            }
            case 5: {
                return this.smallintMap;
            }
            case 2002: {
                return this.structMap;
            }
            case 12: {
                return this.varcharMap;
            }
            case 1995: {
                return this.tableMap;
            }
            case -72054: {
                return this.ncharMap;
            }
            case -72055: {
                return 16;
            }
            case -72056: {
                return 6;
            }
            case -14: {
                return this.tableMap;
            }
            case 1991: {
                return this.tableMap;
            }
            case 1990: {
                return this.tableMap;
            }
            case 100: {
                return this.binaryFloatMap;
            }
            case 101: {
                return this.binaryDoubleMap;
            }
        }
        return 0;
    }

    protected String writePredefinedName(int typecode) {
        return NAMES[this.getJavaTypecode(typecode)];
    }

    protected void javaMapping() {
        this.bfileMap = 7;
        this.cursorMap = 34;
        this.rowidMap = 14;
    }

    public SqlType getPlsqlTableType(SqlType elemType) {
        int typecode = this.getJavaTypecode(elemType.getTypecode());
        switch (typecode) {
            case 2: {
                return SqlReflector.plsqlTableDouble;
            }
            case 3: {
                return SqlReflector.plsqlTableFloat;
            }
            case 4: {
                return SqlReflector.plsqlTableInt;
            }
            case 5: {
                return SqlReflector.plsqlTableShort;
            }
            case 24: {
                return SqlReflector.plsqlTableJldouble;
            }
            case 25: {
                return SqlReflector.plsqlTableJlfloat;
            }
            case 26: {
                return SqlReflector.plsqlTableJlinteger;
            }
            case 27: {
                return SqlReflector.plsqlTableJlshort;
            }
            case 29: {
                return SqlReflector.plsqlTableJmbigdecimal;
            }
            case 28: {
                return SqlReflector.plsqlTableString;
            }
        }
        return null;
    }

    public String accessorMethod(TypeClass type) {
        if ("boolean".equals(this.writeTypeName(type)) || "Boolean".equals(this.writeTypeName(type)) || "java.lang.Boolean".equals(this.writeTypeName(type))) {
            return "Boolean";
        }
        if (type instanceof PlsqlIndexTableType) {
            return "PlsqlIndexTable";
        }
        int typecode = this.getJavaTypecode(type.getTypecode());
        String acc = null;
        if (typecode != 0) {
            acc = ACCESSOR_METHODS[typecode];
        }
        if (acc != null) {
            return acc;
        }
        String className = this.writeTypeName(type);
        if (className != null) {
            if (Util.isWrappedType(className)) {
                className = Util.getWrappedType(className);
            }
            if (className.equals("String")) {
                return "String";
            }
            if (className.equals("byte")) {
                return "Byte";
            }
            if (className.equals("char")) {
                return "Byte";
            }
            if (className.equals("float")) {
                return "Float";
            }
            if (className.equals("int")) {
                return "Int";
            }
            if (className.equals("boolean")) {
                return "Boolean";
            }
            if (className.equals("long")) {
                return "Long";
            }
            if (className.equals("short")) {
                return "Short";
            }
            if (className.equals("double")) {
                return "Double";
            }
        }
        if (this.m_reflector.isUserType(type) && this.m_mapping == 0) {
            return "CustomDatum";
        }
        if (this.isOpaque(type)) {
            return "ORAData";
        }
        return "Object";
    }

    private boolean isOpaque(TypeClass type) {
        SqlType sqlType;
        String name;
        boolean opaque = false;
        if (type instanceof SqlType && "SYS.XMLTYPE".equalsIgnoreCase(name = (sqlType = (SqlType)type).getSqlName().getFullTargetTypeName(1))) {
            opaque = true;
        }
        return opaque;
    }
}

