/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.visit;

import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlArrayType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlObjectType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlPackageType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlToplevelType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherListener;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;

public class PublisherWalker
implements PublisherVisitor {
    protected PublisherListener listener;

    public PublisherWalker(PublisherListener listener) {
        this.listener = listener;
    }

    public PublisherListener getListener() {
        return this.listener;
    }

    public void visit(SqlType sqlType) {
        String targetTypeName = null;
        if (sqlType.hasConversion()) {
            targetTypeName = sqlType.getTargetTypeName();
        }
        this.listener.handleSqlType(sqlType.getName(), sqlType.getTypecode(), targetTypeName);
    }

    @Override
    public void visit(SqlObjectType sqlObjectType) {
        String targetTypeName = null;
        if (sqlObjectType.hasConversion()) {
            targetTypeName = sqlObjectType.getTargetTypeName();
        }
        int numAttributes = 0;
        AttributeField[] fields = null;
        try {
            fields = sqlObjectType.getDeclaredFields(false);
            numAttributes = fields.length;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.listener.handleObjectType(sqlObjectType.getName(), targetTypeName, numAttributes);
        if (numAttributes > 0) {
            for (AttributeField field : fields) {
                TypeClass typeClass = field.getType();
                this.listener.handleAttributeField(field.getName());
                ((SqlType)typeClass).accept(this);
            }
        }
    }

    @Override
    public void visit(SqlArrayType sqlArrayType) {
        String targetTypeName = null;
        if (sqlArrayType.hasConversion()) {
            targetTypeName = sqlArrayType.getTargetTypeName();
        }
        this.listener.handleSqlArrayType(sqlArrayType.getName(), targetTypeName);
        try {
            TypeClass componentType = sqlArrayType.getComponentType();
            ((SqlType)componentType).accept(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void visit(SqlTableType sqlTableType) {
        String targetTypeName = null;
        if (sqlTableType.hasConversion()) {
            targetTypeName = sqlTableType.getTargetTypeName();
        }
        this.listener.handleSqlTableType(sqlTableType.getName(), targetTypeName);
        try {
            TypeClass componentType = sqlTableType.getComponentType();
            ((SqlType)componentType).accept(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void visit(SqlPackageType sqlPackageType) {
        this.listener.beginPackage(sqlPackageType.getName());
        try {
            ProcedureMethod[] declaredMethods;
            for (ProcedureMethod m : declaredMethods = sqlPackageType.getDeclaredMethods()) {
                m.accept(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listener.endPackage();
    }

    @Override
    public void visit(SqlToplevelType sqlToplevelType) {
        this.listener.beginPackage("toplevel");
        try {
            ProcedureMethod[] declaredMethods;
            for (ProcedureMethod m : declaredMethods = sqlToplevelType.getDeclaredMethods()) {
                m.accept(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listener.endPackage();
    }

    @Override
    public void visit(PlsqlRecordType plsqlRecordType) {
        String targetTypeName = null;
        if (plsqlRecordType.hasConversion()) {
            targetTypeName = plsqlRecordType.getTargetTypeName();
        }
        AttributeField[] fields = null;
        int fieldsLength = 0;
        try {
            fields = plsqlRecordType.getFields(true);
            fieldsLength = fields.length;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.listener.beginPlsqlRecord(plsqlRecordType.getTypeName(), targetTypeName, fieldsLength);
        if (fields != null && fieldsLength > 0) {
            for (int idx = 0; idx < fieldsLength; ++idx) {
                AttributeField f = fields[idx];
                this.listener.beginPlsqlRecordField(f.getName(), idx);
                ((SqlType)f.getType()).accept(this);
                this.listener.endPlsqlRecordField(f.getName(), idx);
            }
        }
        this.listener.endPlsqlRecord(plsqlRecordType.getTypeName());
    }

    @Override
    public void visit(PlsqlTableType plsqlTableType) {
        String targetTypeName = null;
        if (plsqlTableType.hasConversion()) {
            targetTypeName = plsqlTableType.getTargetTypeName();
        }
        this.listener.beginPlsqlTable(plsqlTableType.getTypeName(), targetTypeName);
        try {
            if (plsqlTableType.getComponentType() != null) {
                ((SqlType)plsqlTableType.getComponentType()).accept(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listener.endPlsqlTable(plsqlTableType.getTypeName());
    }

    @Override
    public void visit(ProcedureMethod method) {
        TypeClass[] paramTypes = method.getParamTypes();
        int len = paramTypes.length;
        this.listener.beginMethod(method.getName(), len);
        SqlType returnType = (SqlType)method.getReturnType();
        if (returnType != null) {
            this.listener.handleMethodReturn(returnType.getName());
            returnType.accept(this);
        }
        String[] paramNames = method.getParamNames();
        int[] paramModes = method.getParamModes();
        for (int idx = 0; idx < len; ++idx) {
            SqlType argType = (SqlType)paramTypes[idx];
            int mode = paramModes[idx];
            String modeStr = "IN";
            if (mode == 2) {
                modeStr = "OUT";
            } else if (mode == 3) {
                modeStr = "INOUT";
            }
            this.listener.beginMethodArg(paramNames[idx], modeStr, idx);
            argType.accept(this);
            this.listener.endMethodArg(paramNames[idx]);
        }
        this.listener.endMethod(method.getName());
    }
}

