/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.AnnotationDefaultAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.CodeAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantValueAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.DeprecatedAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.EnclosingMethodAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.ExceptionsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClass;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClassesAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.LineNumberTableAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariableTableAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariableTypeTableAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SignatureAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SourceDebugExtensionAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SourceFileAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SyntheticAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.UnknownAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.io.StringBufferWriter;

public abstract class Attribute {
    private AttributePool pool;
    private short nameIndex;
    private int length;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static Attribute read(ClassFileDataInputStream stream, AttributePool pool) throws IOException {
        short nameIndex = stream.readU2();
        String name = pool.constantPool().getUTF8String(nameIndex);
        if (name.equals("ConstantValue")) {
            return new ConstantValueAttribute(stream, nameIndex, pool);
        }
        if (name.equals("Code")) {
            return new CodeAttribute(stream, nameIndex, pool);
        }
        if (name.equals("Exceptions")) {
            return new ExceptionsAttribute(stream, nameIndex, pool);
        }
        if (name.equals("InnerClasses")) {
            return new InnerClassesAttribute(stream, nameIndex, pool);
        }
        if (name.equals("EnclosingMethod")) {
            return new EnclosingMethodAttribute(stream, nameIndex, pool);
        }
        if (name.equals("Synthetic")) {
            return new SyntheticAttribute(stream, nameIndex, pool);
        }
        if (name.equals("Signature")) {
            return new SignatureAttribute(stream, nameIndex, pool);
        }
        if (name.equals("SourceFile")) {
            return new SourceFileAttribute(stream, nameIndex, pool);
        }
        if (name.equals("SourceDebugExtension")) {
            return new SourceDebugExtensionAttribute(stream, nameIndex, pool);
        }
        if (name.equals("LineNumberTable")) {
            return new LineNumberTableAttribute(stream, nameIndex, pool);
        }
        if (name.equals("LocalVariableTable")) {
            return new LocalVariableTableAttribute(stream, nameIndex, pool);
        }
        if (name.equals("LocalVariableTypeTable")) {
            return new LocalVariableTypeTableAttribute(stream, nameIndex, pool);
        }
        if (name.equals("Deprecated")) {
            return new DeprecatedAttribute(stream, nameIndex, pool);
        }
        if (name.equals("RuntimeVisibleAnnotations")) {
            return new RuntimeVisibleAnnotationsAttribute(stream, nameIndex, pool);
        }
        if (name.equals("RuntimeInvisibleAnnotations")) {
            return new RuntimeInvisibleAnnotationsAttribute(stream, nameIndex, pool);
        }
        if (name.equals("RuntimeVisibleParameterAnnotations")) {
            return new RuntimeVisibleParameterAnnotationsAttribute(stream, nameIndex, pool);
        }
        if (name.equals("RuntimeInvisibleParameterAnnotations")) {
            return new RuntimeInvisibleParameterAnnotationsAttribute(stream, nameIndex, pool);
        }
        if (name.equals("AnnotationDefault")) {
            return new AnnotationDefaultAttribute(stream, nameIndex, pool);
        }
        return new UnknownAttribute(stream, nameIndex, pool);
    }

    Attribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        this.pool = pool;
        this.nameIndex = nameIndex;
        this.initialize(stream);
    }

    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.length = stream.readU4();
        this.initializeInfo(stream);
    }

    abstract void initializeInfo(ClassFileDataInputStream var1) throws IOException;

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        this.displayNameOn(writer);
        writer.println();
        writer.indent();
        this.displayInfoStringOn(writer);
        writer.undent();
    }

    public void displayNameOn(IndentingPrintWriter writer) {
        writer.print(this.name());
    }

    abstract void displayInfoStringOn(IndentingPrintWriter var1);

    public Object fieldConstantValue() {
        return null;
    }

    public void printFieldInitializationClauseOn(PrintWriter writer) {
    }

    public String[] exceptionClassNames() {
        return null;
    }

    public String sourceFileName() {
        return null;
    }

    public InnerClass innerClassNamed(String className) {
        return null;
    }

    public String declaringClassName() {
        return null;
    }

    public String nestedClassName() {
        return null;
    }

    public short nestedClassAccessFlags() {
        return 0;
    }

    public String[] nestedClassNames() {
        return null;
    }

    public String[] declaredMemberClassNames() {
        return null;
    }

    public void printThrowsClauseOn(PrintWriter writer) {
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isNestedClass() {
        return false;
    }

    public boolean isMemberClass() {
        return false;
    }

    public boolean isLocalClass() {
        return false;
    }

    public boolean isAnonymousClass() {
        return false;
    }

    public ClassFile classFile() {
        return this.pool.getClassFile();
    }

    public ConstantPool constantPool() {
        return this.classFile().getConstantPool();
    }

    public String name() {
        return this.constantPool().getUTF8String(this.nameIndex);
    }

    public AttributePool getPool() {
        return this.pool;
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public int getLength() {
        return this.length;
    }

    void appendHexStringTo(byte[] bytes, StringBuffer sb) {
        this.writeHexStringOn(bytes, new StringBufferWriter(sb));
    }

    void writeHexStringOn(byte[] bytes, Writer writer) {
        try {
            this.writeHexStringOnInternal(bytes, writer);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeHexStringOnInternal(byte[] bytes, Writer writer) throws IOException {
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            b = (byte)(b / 16);
            writer.write(HEX_CHARS[b]);
            b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            b = (byte)(b % 16);
            writer.write(HEX_CHARS[b]);
        }
    }

    public abstract void accept(Visitor var1);

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassTools.shortClassNameForObject(this));
        sb.append('(');
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    void toString(StringBuffer sb) {
    }
}

