/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.types.SDOChangeSummaryType;
import org.eclipse.persistence.sdo.types.SDODataObjectType;
import org.eclipse.persistence.sdo.types.SDODataType;
import org.eclipse.persistence.sdo.types.SDOOpenSequencedType;
import org.eclipse.persistence.sdo.types.SDOTypeType;
import org.eclipse.persistence.sdo.types.SDOWrapperType;
import org.eclipse.persistence.sdo.types.SDOXMLHelperLoadOptionsType;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOTypeHelperDelegate
implements SDOTypeHelper {
    private Map typesHashMap;
    private Map<QName, SDOType> wrappersHashMap;
    private Map<Class, SDOType> interfacesToSDOTypeHashMap = new HashMap<Class, SDOType>();
    private Map<Class, SDOType> implClassesToSDOType = new HashMap<Class, SDOType>();
    private final Map commonjHashMap = new HashMap();
    private final Map commonjJavaHashMap = new HashMap();
    private static final Map sdoTypeForSimpleJavaType = new HashMap();
    private final Map sdoToXSDTypes = new HashMap();
    private final Map xsdToSDOType = new HashMap();
    private Map openContentProperties;
    private List anonymousTypes;
    private HelperContext aHelperContext;
    private NamespaceResolver namespaceResolver;
    private SDOWrapperType SDO_BOOLEAN_WRAPPER;
    private SDOWrapperType SDO_BYTE_WRAPPER;
    private SDOWrapperType SDO_BYTES_WRAPPER;
    private SDOWrapperType SDO_CHARACTER_WRAPPER;
    private SDOWrapperType SDO_DATE_WRAPPER;
    private SDOWrapperType SDO_DATETIME_WRAPPER;
    private SDOWrapperType SDO_DAY_WRAPPER;
    private SDOWrapperType SDO_DECIMAL_WRAPPER;
    private SDOWrapperType SDO_DOUBLE_WRAPPER;
    private SDOWrapperType SDO_DURATION_WRAPPER;
    private SDOWrapperType SDO_FLOAT_WRAPPER;
    private SDOWrapperType SDO_INT_WRAPPER;
    private SDOWrapperType SDO_INTEGER_WRAPPER;
    private SDOWrapperType SDO_LONG_WRAPPER;
    private SDOWrapperType SDO_MONTH_WRAPPER;
    private SDOWrapperType SDO_MONTHDAY_WRAPPER;
    private SDOWrapperType SDO_OBJECT_WRAPPER;
    private SDOWrapperType SDO_SHORT_WRAPPER;
    private SDOWrapperType SDO_STRING_WRAPPER;
    private SDOWrapperType SDO_STRINGS_WRAPPER;
    private SDOWrapperType SDO_TIME_WRAPPER;
    private SDOWrapperType SDO_URI_WRAPPER;
    private SDOWrapperType SDO_YEAR_WRAPPER;
    private SDOWrapperType SDO_YEARMONTH_WRAPPER;
    private SDOWrapperType SDO_YEARMONTHDAY_WRAPPER;
    private SDOWrapperType SDO_BOOLEANOBJECT_WRAPPER;
    private SDOWrapperType SDO_BYTEOBJECT_WRAPPER;
    private SDOWrapperType SDO_CHARACTEROBJECT_WRAPPER;
    private SDOWrapperType SDO_DOUBLEOBJECT_WRAPPER;
    private SDOWrapperType SDO_FLOATOBJECT_WRAPPER;
    private SDOWrapperType SDO_INTOBJECT_WRAPPER;
    private SDOWrapperType SDO_LONGOBJECT_WRAPPER;
    private SDOWrapperType SDO_SHORTOBJECT_WRAPPER;

    public SDOTypeHelperDelegate(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.initWrapperTypes();
        this.initTypesHashMap();
        this.initCommonjHashMap();
        this.initCommonjJavaHashMap();
        this.initXsdToSDOType();
        this.initSdoToXSDType();
        this.initOpenProps();
    }

    public void initWrapperTypes() {
        this.SDO_BOOLEAN_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BOOLEAN, "Boolean", (SDOTypeHelper)this, XMLConstants.BOOLEAN_QNAME);
        this.SDO_BYTE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTE, "Byte", (SDOTypeHelper)this, XMLConstants.BYTE_QNAME);
        this.SDO_BYTES_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTES, "Bytes", (SDOTypeHelper)this, new QName[]{XMLConstants.BASE_64_BINARY_QNAME, XMLConstants.HEX_BINARY_QNAME});
        this.SDO_CHARACTER_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_CHARACTER, "Character", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_DATE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DATE, "Date", (SDOTypeHelper)this, XMLConstants.DATE_QNAME);
        this.SDO_DATETIME_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DATETIME, "DateTime", (SDOTypeHelper)this, XMLConstants.DATE_TIME_QNAME);
        this.SDO_DAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DAY, "Day", (SDOTypeHelper)this, XMLConstants.G_DAY_QNAME);
        this.SDO_DECIMAL_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DECIMAL, "Decimal", (SDOTypeHelper)this, XMLConstants.DECIMAL_QNAME);
        this.SDO_DOUBLE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DOUBLE, "Double", (SDOTypeHelper)this, XMLConstants.DOUBLE_QNAME);
        this.SDO_DURATION_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DURATION, "Duration", (SDOTypeHelper)this, XMLConstants.DURATION_QNAME);
        this.SDO_FLOAT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_FLOAT, "Float", (SDOTypeHelper)this, XMLConstants.FLOAT_QNAME);
        this.SDO_INT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INT, "Int", (SDOTypeHelper)this, XMLConstants.INT_QNAME);
        this.SDO_INTEGER_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INTEGER, "Integer", (SDOTypeHelper)this, XMLConstants.INTEGER_QNAME);
        this.SDO_LONG_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_LONG, "Long", (SDOTypeHelper)this, XMLConstants.LONG_QNAME);
        this.SDO_MONTH_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_MONTH, "Month", (SDOTypeHelper)this, XMLConstants.G_MONTH_QNAME);
        this.SDO_MONTHDAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_MONTHDAY, "MonthDay", (SDOTypeHelper)this, XMLConstants.G_MONTH_DAY_QNAME);
        this.SDO_OBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_OBJECT, "Object", (SDOTypeHelper)this, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        this.SDO_SHORT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_SHORT, "Short", (SDOTypeHelper)this, XMLConstants.SHORT_QNAME);
        this.SDO_STRING_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_STRING, "String", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_STRINGS_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_STRINGS, "Strings", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_TIME_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_TIME, "Time", (SDOTypeHelper)this, XMLConstants.TIME_QNAME);
        this.SDO_URI_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_URI, "URI", (SDOTypeHelper)this, XMLConstants.ANY_URI_QNAME);
        this.SDO_YEAR_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEAR, "Year", (SDOTypeHelper)this, XMLConstants.G_YEAR_QNAME);
        this.SDO_YEARMONTH_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEARMONTH, "YearMonth", (SDOTypeHelper)this, XMLConstants.G_YEAR_MONTH_QNAME);
        this.SDO_YEARMONTHDAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEARMONTHDAY, "YearMonthDay", (SDOTypeHelper)this, XMLConstants.DATE_QNAME);
        this.SDO_BOOLEANOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BOOLEANOBJECT, "BooleanObject", (SDOTypeHelper)this, XMLConstants.BOOLEAN_QNAME);
        this.SDO_BYTEOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTEOBJECT, "ByteObject", (SDOTypeHelper)this, XMLConstants.BYTE_QNAME);
        this.SDO_CHARACTEROBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_CHARACTEROBJECT, "CharacterObject", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_DOUBLEOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DOUBLEOBJECT, "DoubleObject", (SDOTypeHelper)this, XMLConstants.DOUBLE_QNAME);
        this.SDO_FLOATOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_FLOATOBJECT, "FloatObject", (SDOTypeHelper)this, XMLConstants.FLOAT_QNAME);
        this.SDO_INTOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INTOBJECT, "IntObject", (SDOTypeHelper)this, XMLConstants.INT_QNAME);
        this.SDO_LONGOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_LONGOBJECT, "LongObject", (SDOTypeHelper)this, XMLConstants.LONG_QNAME);
        this.SDO_SHORTOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_SHORTOBJECT, "ShortObject", (SDOTypeHelper)this, XMLConstants.SHORT_QNAME);
    }

    @Override
    public void addWrappersToProject(Project project) {
        this.SDO_BOOLEAN_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTE_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTES_WRAPPER.addDescriptorToProject(project);
        this.SDO_CHARACTER_WRAPPER.addDescriptorToProject(project);
        this.SDO_DATE_WRAPPER.addDescriptorToProject(project);
        this.SDO_DAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_DECIMAL_WRAPPER.addDescriptorToProject(project);
        this.SDO_DOUBLE_WRAPPER.addDescriptorToProject(project);
        this.SDO_DURATION_WRAPPER.addDescriptorToProject(project);
        this.SDO_FLOAT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INTEGER_WRAPPER.addDescriptorToProject(project);
        this.SDO_LONG_WRAPPER.addDescriptorToProject(project);
        this.SDO_MONTH_WRAPPER.addDescriptorToProject(project);
        this.SDO_MONTHDAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_OBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_SHORT_WRAPPER.addDescriptorToProject(project);
        this.SDO_STRINGS_WRAPPER.addDescriptorToProject(project);
        this.SDO_TIME_WRAPPER.addDescriptorToProject(project);
        this.SDO_URI_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEAR_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEARMONTH_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEARMONTHDAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_STRING_WRAPPER.addDescriptorToProject(project);
        this.SDO_DATETIME_WRAPPER.addDescriptorToProject(project);
        this.SDO_BOOLEANOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTEOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_CHARACTEROBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_DOUBLEOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_FLOATOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INTOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_LONGOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_SHORTOBJECT_WRAPPER.addDescriptorToProject(project);
    }

    private void initCommonjHashMap() {
        this.commonjHashMap.put("Boolean", SDOConstants.SDO_BOOLEAN);
        this.commonjHashMap.put("Byte", SDOConstants.SDO_BYTE);
        this.commonjHashMap.put("Bytes", SDOConstants.SDO_BYTES);
        this.commonjHashMap.put("Character", SDOConstants.SDO_CHARACTER);
        SDODataObjectType dataObjectType = new SDODataObjectType(this);
        this.commonjHashMap.put(((SDOType)dataObjectType).getName(), dataObjectType);
        this.commonjHashMap.put("Date", SDOConstants.SDO_DATE);
        this.commonjHashMap.put("DateTime", SDOConstants.SDO_DATETIME);
        this.commonjHashMap.put("Day", SDOConstants.SDO_DAY);
        this.commonjHashMap.put("Decimal", SDOConstants.SDO_DECIMAL);
        this.commonjHashMap.put("Double", SDOConstants.SDO_DOUBLE);
        this.commonjHashMap.put("Duration", SDOConstants.SDO_DURATION);
        this.commonjHashMap.put("Float", SDOConstants.SDO_FLOAT);
        this.commonjHashMap.put("Int", SDOConstants.SDO_INT);
        this.commonjHashMap.put("Integer", SDOConstants.SDO_INTEGER);
        this.commonjHashMap.put("Long", SDOConstants.SDO_LONG);
        this.commonjHashMap.put("Month", SDOConstants.SDO_MONTH);
        this.commonjHashMap.put("MonthDay", SDOConstants.SDO_MONTHDAY);
        this.commonjHashMap.put("Object", SDOConstants.SDO_OBJECT);
        this.commonjHashMap.put("Short", SDOConstants.SDO_SHORT);
        this.commonjHashMap.put("String", SDOConstants.SDO_STRING);
        this.commonjHashMap.put("Strings", SDOConstants.SDO_STRINGS);
        this.commonjHashMap.put("Time", SDOConstants.SDO_TIME);
        this.commonjHashMap.put("Year", SDOConstants.SDO_YEAR);
        this.commonjHashMap.put("YearMonth", SDOConstants.SDO_YEARMONTH);
        this.commonjHashMap.put("YearMonthDay", SDOConstants.SDO_YEARMONTHDAY);
        this.commonjHashMap.put("URI", SDOConstants.SDO_URI);
        SDOChangeSummaryType changeSummaryType = new SDOChangeSummaryType(this);
        this.commonjHashMap.put(((SDOType)changeSummaryType).getName(), changeSummaryType);
        SDOTypeType typeType = new SDOTypeType(this);
        this.commonjHashMap.put(((SDOType)typeType).getName(), typeType);
    }

    private void initCommonjJavaHashMap() {
        this.commonjJavaHashMap.put("BooleanObject", SDOConstants.SDO_BOOLEANOBJECT);
        this.commonjJavaHashMap.put("ByteObject", SDOConstants.SDO_BYTEOBJECT);
        this.commonjJavaHashMap.put("CharacterObject", SDOConstants.SDO_CHARACTEROBJECT);
        this.commonjJavaHashMap.put("DoubleObject", SDOConstants.SDO_DOUBLEOBJECT);
        this.commonjJavaHashMap.put("FloatObject", SDOConstants.SDO_FLOATOBJECT);
        this.commonjJavaHashMap.put("IntObject", SDOConstants.SDO_INTOBJECT);
        this.commonjJavaHashMap.put("LongObject", SDOConstants.SDO_LONGOBJECT);
        this.commonjJavaHashMap.put("ShortObject", SDOConstants.SDO_SHORTOBJECT);
    }

    private void initTypesHashMap() {
        this.typesHashMap = new HashMap();
        SDOType typeType = this.getType("commonj.sdo", "Type");
        SDOXMLHelperLoadOptionsType xmlHelperLoadOptionsType = new SDOXMLHelperLoadOptionsType(this, typeType);
        this.typesHashMap.put(xmlHelperLoadOptionsType.getQName(), xmlHelperLoadOptionsType);
        SDOOpenSequencedType openSequencedType = new SDOOpenSequencedType(this);
        this.typesHashMap.put(openSequencedType.getQName(), openSequencedType);
        this.typesHashMap.put(this.SDO_BOOLEAN_WRAPPER.getQName(), this.SDO_BOOLEAN_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTE_WRAPPER.getQName(), this.SDO_BYTE_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTES_WRAPPER.getQName(), this.SDO_BYTES_WRAPPER);
        this.typesHashMap.put(this.SDO_CHARACTER_WRAPPER.getQName(), this.SDO_CHARACTER_WRAPPER);
        this.typesHashMap.put(this.SDO_DATE_WRAPPER.getQName(), this.SDO_DATE_WRAPPER);
        this.typesHashMap.put(this.SDO_DATETIME_WRAPPER.getQName(), this.SDO_DATETIME_WRAPPER);
        this.typesHashMap.put(this.SDO_DAY_WRAPPER.getQName(), this.SDO_DAY_WRAPPER);
        this.typesHashMap.put(this.SDO_DECIMAL_WRAPPER.getQName(), this.SDO_DECIMAL_WRAPPER);
        this.typesHashMap.put(this.SDO_DOUBLE_WRAPPER.getQName(), this.SDO_DOUBLE_WRAPPER);
        this.typesHashMap.put(this.SDO_DURATION_WRAPPER.getQName(), this.SDO_DURATION_WRAPPER);
        this.typesHashMap.put(this.SDO_FLOAT_WRAPPER.getQName(), this.SDO_FLOAT_WRAPPER);
        this.typesHashMap.put(this.SDO_INT_WRAPPER.getQName(), this.SDO_INT_WRAPPER);
        this.typesHashMap.put(this.SDO_INTEGER_WRAPPER.getQName(), this.SDO_INTEGER_WRAPPER);
        this.typesHashMap.put(this.SDO_LONG_WRAPPER.getQName(), this.SDO_LONG_WRAPPER);
        this.typesHashMap.put(this.SDO_MONTH_WRAPPER.getQName(), this.SDO_MONTH_WRAPPER);
        this.typesHashMap.put(this.SDO_MONTHDAY_WRAPPER.getQName(), this.SDO_MONTHDAY_WRAPPER);
        this.typesHashMap.put(this.SDO_OBJECT_WRAPPER.getQName(), this.SDO_OBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_SHORT_WRAPPER.getQName(), this.SDO_SHORT_WRAPPER);
        this.typesHashMap.put(this.SDO_STRING_WRAPPER.getQName(), this.SDO_STRING_WRAPPER);
        this.typesHashMap.put(this.SDO_STRINGS_WRAPPER.getQName(), this.SDO_STRINGS_WRAPPER);
        this.typesHashMap.put(this.SDO_TIME_WRAPPER.getQName(), this.SDO_TIME_WRAPPER);
        this.typesHashMap.put(this.SDO_URI_WRAPPER.getQName(), this.SDO_URI_WRAPPER);
        this.typesHashMap.put(this.SDO_YEAR_WRAPPER.getQName(), this.SDO_YEAR_WRAPPER);
        this.typesHashMap.put(this.SDO_YEARMONTH_WRAPPER.getQName(), this.SDO_YEARMONTH_WRAPPER);
        this.typesHashMap.put(this.SDO_YEARMONTHDAY_WRAPPER.getQName(), this.SDO_YEARMONTHDAY_WRAPPER);
        this.typesHashMap.put(this.SDO_BOOLEANOBJECT_WRAPPER.getQName(), this.SDO_BOOLEANOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTEOBJECT_WRAPPER.getQName(), this.SDO_BYTEOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_CHARACTEROBJECT_WRAPPER.getQName(), this.SDO_CHARACTEROBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_DOUBLEOBJECT_WRAPPER.getQName(), this.SDO_DOUBLEOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_FLOATOBJECT_WRAPPER.getQName(), this.SDO_FLOATOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_INTOBJECT_WRAPPER.getQName(), this.SDO_INTOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_LONGOBJECT_WRAPPER.getQName(), this.SDO_LONGOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_SHORTOBJECT_WRAPPER.getQName(), this.SDO_SHORTOBJECT_WRAPPER);
    }

    private void initWrappersHashMap() {
        this.wrappersHashMap = new HashMap<QName, SDOType>();
        this.wrappersHashMap.put(SDOConstants.SDO_BOOLEAN.getQName(), this.SDO_BOOLEAN_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTE.getQName(), this.SDO_BYTE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTES.getQName(), this.SDO_BYTES_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_CHARACTER.getQName(), this.SDO_CHARACTER_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DATE.getQName(), this.SDO_DATE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DATETIME.getQName(), this.SDO_DATETIME_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DAY.getQName(), this.SDO_DAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DECIMAL.getQName(), this.SDO_DECIMAL_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DOUBLE.getQName(), this.SDO_DOUBLE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DURATION.getQName(), this.SDO_DURATION_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_FLOAT.getQName(), this.SDO_FLOAT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INT.getQName(), this.SDO_INT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INTEGER.getQName(), this.SDO_INTEGER_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_LONG.getQName(), this.SDO_LONG_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_MONTH.getQName(), this.SDO_MONTH_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_MONTHDAY.getQName(), this.SDO_MONTHDAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_OBJECT.getQName(), this.SDO_OBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_SHORT.getQName(), this.SDO_SHORT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_STRING.getQName(), this.SDO_STRING_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_STRINGS.getQName(), this.SDO_STRINGS_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_TIME.getQName(), this.SDO_TIME_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_URI.getQName(), this.SDO_URI_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEAR.getQName(), this.SDO_YEAR_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEARMONTH.getQName(), this.SDO_YEARMONTH_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEARMONTHDAY.getQName(), this.SDO_YEARMONTHDAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BOOLEANOBJECT.getQName(), this.SDO_BOOLEANOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTEOBJECT.getQName(), this.SDO_BYTEOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_CHARACTEROBJECT.getQName(), this.SDO_CHARACTEROBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DOUBLEOBJECT.getQName(), this.SDO_DOUBLEOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_FLOATOBJECT.getQName(), this.SDO_FLOATOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INTOBJECT.getQName(), this.SDO_INTOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_LONGOBJECT.getQName(), this.SDO_LONGOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_SHORTOBJECT.getQName(), this.SDO_SHORTOBJECT_WRAPPER);
        for (SDOWrapperType sDOWrapperType : this.wrappersHashMap.values()) {
            for (XMLDescriptor d : sDOWrapperType.getDescriptorsMap().values()) {
                this.implClassesToSDOType.put(d.getJavaClass(), sDOWrapperType);
            }
        }
    }

    private void initSdoToXSDType() {
        this.sdoToXSDTypes.put(SDOConstants.SDO_BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTE, XMLConstants.BYTE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTES, XMLConstants.HEX_BINARY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_CHARACTER, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DATE, XMLConstants.DATE_TIME_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DATETIME, XMLConstants.DATE_TIME_QNAME);
        SDOType dataObjectType = this.getType("commonj.sdo", "DataObject");
        this.sdoToXSDTypes.put(dataObjectType, SDOConstants.ANY_TYPE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DAY, SDOConstants.GDAY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DECIMAL, XMLConstants.DECIMAL_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DOUBLE, XMLConstants.DOUBLE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DURATION, SDOConstants.DURATION_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_FLOAT, XMLConstants.FLOAT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INT, XMLConstants.INT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INTEGER, XMLConstants.INTEGER_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_LONG, XMLConstants.LONG_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_MONTH, SDOConstants.GMONTH_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_MONTHDAY, SDOConstants.GMONTHDAY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_OBJECT, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_SHORT, XMLConstants.SHORT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_STRING, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_STRINGS, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_TIME, XMLConstants.TIME_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEAR, SDOConstants.GYEAR_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTH, SDOConstants.GYEARMONTH_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTHDAY, XMLConstants.DATE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_URI, SDOConstants.ANY_URI_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BOOLEANOBJECT, XMLConstants.BOOLEAN_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTEOBJECT, XMLConstants.BYTE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_CHARACTEROBJECT, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DOUBLEOBJECT, XMLConstants.DOUBLE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_FLOATOBJECT, XMLConstants.FLOAT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INTOBJECT, XMLConstants.INT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_LONGOBJECT, XMLConstants.LONG_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_SHORTOBJECT, XMLConstants.SHORT_QNAME);
    }

    private void initXsdToSDOType() {
        this.xsdToSDOType.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, SDOConstants.SDO_OBJECT);
        SDOType dataObjectType = this.getType("commonj.sdo", "DataObject");
        this.xsdToSDOType.put(SDOConstants.ANY_TYPE_QNAME, dataObjectType);
        this.xsdToSDOType.put(SDOConstants.ANY_URI_QNAME, SDOConstants.SDO_URI);
        this.xsdToSDOType.put(XMLConstants.BASE_64_BINARY_QNAME, SDOConstants.SDO_BYTES);
        this.xsdToSDOType.put(XMLConstants.BOOLEAN_QNAME, SDOConstants.SDO_BOOLEAN);
        this.xsdToSDOType.put(XMLConstants.BYTE_QNAME, SDOConstants.SDO_BYTE);
        this.xsdToSDOType.put(XMLConstants.DATE_QNAME, SDOConstants.SDO_YEARMONTHDAY);
        this.xsdToSDOType.put(XMLConstants.DATE_TIME_QNAME, SDOConstants.SDO_DATETIME);
        this.xsdToSDOType.put(XMLConstants.DECIMAL_QNAME, SDOConstants.SDO_DECIMAL);
        this.xsdToSDOType.put(XMLConstants.DOUBLE_QNAME, SDOConstants.SDO_DOUBLE);
        this.xsdToSDOType.put(SDOConstants.DURATION_QNAME, SDOConstants.SDO_DURATION);
        this.xsdToSDOType.put(SDOConstants.ENTITIES_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(SDOConstants.ENTITY_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.FLOAT_QNAME, SDOConstants.SDO_FLOAT);
        this.xsdToSDOType.put(SDOConstants.GDAY_QNAME, SDOConstants.SDO_DAY);
        this.xsdToSDOType.put(SDOConstants.GMONTH_QNAME, SDOConstants.SDO_MONTH);
        this.xsdToSDOType.put(SDOConstants.GMONTHDAY_QNAME, SDOConstants.SDO_MONTHDAY);
        this.xsdToSDOType.put(SDOConstants.GYEAR_QNAME, SDOConstants.SDO_YEAR);
        this.xsdToSDOType.put(SDOConstants.GYEARMONTH_QNAME, SDOConstants.SDO_YEARMONTH);
        this.xsdToSDOType.put(XMLConstants.HEX_BINARY_QNAME, SDOConstants.SDO_BYTES);
        this.xsdToSDOType.put(SDOConstants.ID_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.IDREF_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.IDREFS_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(XMLConstants.INT_QNAME, SDOConstants.SDO_INT);
        this.xsdToSDOType.put(XMLConstants.INTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.LANGUAGE_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.LONG_QNAME, SDOConstants.SDO_LONG);
        this.xsdToSDOType.put(SDOConstants.NAME_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NCNAME_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NMTOKEN_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NMTOKENS_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(SDOConstants.NONNEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NONPOSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NORMALIZEDSTRING_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NOTATION_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.POSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(XMLConstants.QNAME_QNAME, SDOConstants.SDO_URI);
        this.xsdToSDOType.put(XMLConstants.SHORT_QNAME, SDOConstants.SDO_SHORT);
        this.xsdToSDOType.put(XMLConstants.STRING_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.TIME_QNAME, SDOConstants.SDO_TIME);
        this.xsdToSDOType.put(SDOConstants.TOKEN_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_BYTE_QNAME, SDOConstants.SDO_SHORT);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_INT_QNAME, SDOConstants.SDO_LONG);
        this.xsdToSDOType.put(SDOConstants.UNSIGNEDLONG_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_SHORT_QNAME, SDOConstants.SDO_INT);
    }

    private static void initSDOTypeForSimpleJavaTypeMap() {
        sdoTypeForSimpleJavaType.put(ClassConstants.STRING, SDOConstants.SDO_STRING);
        sdoTypeForSimpleJavaType.put(ClassConstants.BOOLEAN, SDOConstants.SDO_BOOLEANOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBOOLEAN, SDOConstants.SDO_BOOLEAN);
        sdoTypeForSimpleJavaType.put(ClassConstants.BYTE, SDOConstants.SDO_BYTEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBYTE, SDOConstants.SDO_BYTE);
        sdoTypeForSimpleJavaType.put(ClassConstants.ABYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.APBYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.CHAR, SDOConstants.SDO_CHARACTEROBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PCHAR, SDOConstants.SDO_CHARACTER);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGDECIMAL, SDOConstants.SDO_DECIMAL);
        sdoTypeForSimpleJavaType.put(ClassConstants.UTILDATE, SDOConstants.SDO_DATE);
        sdoTypeForSimpleJavaType.put(ClassConstants.DOUBLE, SDOConstants.SDO_DOUBLEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PDOUBLE, SDOConstants.SDO_DOUBLE);
        sdoTypeForSimpleJavaType.put(ClassConstants.FLOAT, SDOConstants.SDO_FLOATOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PFLOAT, SDOConstants.SDO_FLOAT);
        sdoTypeForSimpleJavaType.put(ClassConstants.INTEGER, SDOConstants.SDO_INTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PINT, SDOConstants.SDO_INT);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGINTEGER, SDOConstants.SDO_INTEGER);
        sdoTypeForSimpleJavaType.put(ClassConstants.LONG, SDOConstants.SDO_LONGOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PLONG, SDOConstants.SDO_LONG);
        sdoTypeForSimpleJavaType.put(ClassConstants.SHORT, SDOConstants.SDO_SHORTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PSHORT, SDOConstants.SDO_SHORT);
    }

    @Override
    public Class getJavaWrapperTypeForSDOType(Type sdoType) {
        if (sdoType.getInstanceClass() != null) {
            return sdoType.getInstanceClass();
        }
        Class javaClass = null;
        if (sdoType.getBaseTypes() != null) {
            for (int i = 0; i < sdoType.getBaseTypes().size(); ++i) {
                Type baseType = (Type)sdoType.getBaseTypes().get(i);
                javaClass = this.getJavaWrapperTypeForSDOType(baseType);
                if (javaClass == null) continue;
                return javaClass;
            }
        }
        return javaClass;
    }

    public SDOType getType(String uri, String typeName) {
        if (typeName == null) {
            return null;
        }
        if (uri != null && uri.equals("commonj.sdo")) {
            return (SDOType)this.commonjHashMap.get(typeName);
        }
        if (uri != null && uri.equals("commonj.sdo/java")) {
            return (SDOType)this.commonjJavaHashMap.get(typeName);
        }
        QName qName = new QName(uri, typeName);
        return (SDOType)this.getTypesHashMap().get(qName);
    }

    @Override
    public void addType(SDOType newType) {
        if ("commonj.sdo".equals(newType.getURI())) {
            this.commonjHashMap.put(newType.getName(), newType);
        } else if ("commonj.sdo/java".equals(newType.getURI())) {
            this.commonjJavaHashMap.put(newType.getName(), newType);
        } else {
            this.getTypesHashMap().put(newType.getQName(), newType);
        }
    }

    public SDOType getType(Class interfaceClass) {
        SDOType value;
        SDOType type = (SDOType)this.getInterfacesToSDOTypeHashMap().get(interfaceClass);
        if (type != null) {
            return type;
        }
        type = this.getTypeForSimpleJavaType(interfaceClass);
        if (type != null) {
            return type;
        }
        for (Object key : this.getTypesHashMap().keySet()) {
            value = (SDOType)this.getTypesHashMap().get(key);
            if (value.getInstanceClass() != interfaceClass) continue;
            return value;
        }
        for (SDOType value2 : this.getAnonymousTypes()) {
            if (value2.getInstanceClass() != interfaceClass) continue;
            return value2;
        }
        for (Object key : this.commonjHashMap.keySet()) {
            value = (SDOType)this.commonjHashMap.get(key);
            if (value.getInstanceClass() != interfaceClass) continue;
            return value;
        }
        return null;
    }

    @Override
    public SDOType getTypeForImplClass(Class implClass) {
        SDOType type = this.getTypeForSimpleJavaType(implClass);
        if (type != null) {
            return type;
        }
        type = this.getImplClassesToSDOType().get(implClass);
        if (type != null) {
            return type;
        }
        for (Object key : this.commonjHashMap.keySet()) {
            SDOType value = (SDOType)this.commonjHashMap.get(key);
            if (value.isDataType() || value.getImplClass() != implClass) continue;
            return value;
        }
        return null;
    }

    @Override
    public SDOType getTypeForSimpleJavaType(Class implClass) {
        return (SDOType)SDOTypeHelperDelegate.getSDOTypeForSimpleJavaTypeMap().get(implClass);
    }

    public synchronized Type define(DataObject dataObject) {
        ArrayList types = new ArrayList();
        Type rootType = this.define(dataObject, types);
        this.initializeTypes(types);
        return rootType;
    }

    private void initializeTypes(List types) {
        SDOType nextType;
        int i;
        ArrayList<SDOType> descriptorsToAdd = new ArrayList<SDOType>(types);
        for (i = 0; i < types.size(); ++i) {
            nextType = (SDOType)types.get(i);
            if (nextType.isDataType()) continue;
            nextType.postInitialize();
        }
        for (i = 0; i < types.size(); ++i) {
            nextType = (SDOType)types.get(i);
            if ((!nextType.isDataType() && nextType.getBaseTypes() == null || nextType.getBaseTypes().size() == 0) && nextType.getSubTypes().size() > 0) {
                nextType.setupInheritance(null);
                continue;
            }
            if (nextType.isDataType() || nextType.getBaseTypes().size() <= 0 || types.contains(nextType.getBaseTypes().get(0))) continue;
            SDOType baseType = (SDOType)nextType.getBaseTypes().get(0);
            while (baseType != null && !baseType.isDataType()) {
                descriptorsToAdd.add(baseType);
                if (baseType.getBaseTypes().size() == 0) {
                    descriptorsToAdd.add(baseType);
                    baseType.setupInheritance(null);
                    baseType = null;
                    continue;
                }
                baseType = (SDOType)baseType.getBaseTypes().get(0);
            }
        }
        ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(descriptorsToAdd);
    }

    public synchronized Type define(DataObject dataObject, List types) {
        SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        if (dataObject == null || dataObject.getType() == null || !dataObject.getType().getURI().equals("commonj.sdo") || !dataObject.getType().getName().equals("Type")) {
            throw new IllegalArgumentException((Throwable)SDOException.errorDefiningType());
        }
        String uri = dataObject.getString("uri");
        String name = dataObject.getString("name");
        if (name == null) {
            throw new IllegalArgumentException((Throwable)SDOException.errorDefiningTypeNoName());
        }
        SDOType type = (SDOType)typeHelper.getType(uri, name);
        if (null != type) {
            return type;
        }
        boolean isDataType = dataObject.getBoolean("dataType");
        if (isDataType) {
            type = new SDODataType(uri, name, this);
        } else {
            type = new SDOType(uri, name, this);
            if (dataObject.getBoolean("sequenced")) {
                type.setSequenced(true);
                type.setMixed(true);
            }
        }
        type.setDataType(isDataType);
        this.addType(type);
        types.add(type);
        type.setAbstract(dataObject.getBoolean("abstract"));
        List baseTypes = dataObject.getList("baseType");
        for (int i = 0; i < baseTypes.size(); ++i) {
            SDOType baseType = (SDOType)this.getValueFromObject(baseTypes.get(i), types);
            type.addBaseType(baseType);
        }
        List aliasNames = dataObject.getList("aliasName");
        for (int i = 0; i < aliasNames.size(); ++i) {
            Object aliasName = aliasNames.get(i);
            type.getAliasNames().add(aliasName);
        }
        List openProps = ((SDODataObject)dataObject)._getOpenContentProperties();
        for (int i = 0; i < openProps.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openProps.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            type.setInstanceProperty(nextProp, value);
        }
        List openPropsAttrs = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        for (int i = 0; i < openPropsAttrs.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openPropsAttrs.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            type.setInstanceProperty(nextProp, value);
        }
        if (!type.isDataType()) {
            type.preInitialize(null, null);
        }
        List properties = dataObject.getList("property");
        for (int i = 0; i < properties.size(); ++i) {
            Object nextValue = properties.get(i);
            if (!(nextValue instanceof DataObject)) continue;
            this.buildPropertyFromDataObject((DataObject)nextValue, type, types);
        }
        type.setOpen(dataObject.getBoolean("open"));
        if (type.isDataType()) {
            QName typeQName = new QName("http://www.w3.org/2001/XMLSchema", name);
            if (typeHelper.getWrappersHashMap().get(typeQName) != null) {
                return type;
            }
            QName currentTypeQName = null;
            if (!type.getBaseTypes().isEmpty()) {
                SDOType baseType = (SDOType)type.getBaseTypes().get(0);
                currentTypeQName = new QName("http://www.w3.org/2001/XMLSchema", baseType.getName());
            }
            SDOWrapperType wrapperType = new SDOWrapperType((Type)type, name, (SDOTypeHelper)this, currentTypeQName);
            typeHelper.getWrappersHashMap().put(typeQName, wrapperType);
            typeHelper.getTypesHashMap().put(typeQName, wrapperType);
            typeHelper.getImplClassesToSDOType().put(wrapperType.getXmlDescriptor().getJavaClass(), wrapperType);
            ArrayList<SDOWrapperType> list = new ArrayList<SDOWrapperType>(1);
            list.add(wrapperType);
            ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(list);
        }
        return type;
    }

    private boolean isBaseTypeBytes(Type theType) {
        List baseTypes = theType.getBaseTypes();
        if (baseTypes.size() > 0) {
            Type nextType = (Type)baseTypes.get(0);
            if (nextType == SDOConstants.SDO_BYTES) {
                return true;
            }
            return this.isBaseTypeBytes(nextType);
        }
        return false;
    }

    private Object getValueFromObject(Object objectValue, List types) {
        if (objectValue instanceof SDODataObject && ((SDODataObject)objectValue).getType().isTypeType()) {
            return this.define((DataObject)objectValue, types);
        }
        return objectValue;
    }

    private SDOProperty buildPropertyFromDataObject(DataObject dataObject, Type containingType, List types) {
        String nameValue = dataObject.getString("name");
        Object typeObjectValue = dataObject.get("type");
        SDOProperty newProperty = new SDOProperty(this.aHelperContext);
        newProperty.setName(nameValue);
        Type typeValue = (Type)this.getValueFromObject(typeObjectValue, types);
        newProperty.setType(typeValue);
        if (typeValue != null) {
            if (typeValue == SDOConstants.SDO_BYTES) {
                newProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            } else if (typeValue.isDataType() && this.isBaseTypeBytes(typeValue)) {
                newProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            }
        }
        if (dataObject.isSet("containment")) {
            newProperty.setContainment(dataObject.getBoolean("containment"));
        } else if (typeValue != null) {
            newProperty.setContainment(!typeValue.isDataType());
        }
        newProperty.setReadOnly(dataObject.getBoolean("readOnly"));
        newProperty.setMany(dataObject.getBoolean("many"));
        newProperty.setNullable(dataObject.getBoolean("nullable"));
        List aliasNames = dataObject.getList("aliasName");
        for (int i = 0; i < aliasNames.size(); ++i) {
            Object aliasName = aliasNames.get(i);
            newProperty.getAliasNames().add(aliasName);
        }
        Object opposite = dataObject.get("opposite");
        if (opposite != null) {
            SDOProperty prop;
            if (opposite instanceof SDOProperty) {
                newProperty.setOpposite((SDOProperty)opposite);
                ((SDOProperty)opposite).setOpposite(newProperty);
            } else if (opposite instanceof DataObject && (prop = (SDOProperty)typeValue.getProperty(((DataObject)opposite).getString("name"))) != null) {
                newProperty.setOpposite(prop);
                prop.setOpposite(newProperty);
            }
        }
        if (dataObject.isSet("default")) {
            newProperty.setDefault(dataObject.get("default"));
        }
        List openProps = ((SDODataObject)dataObject)._getOpenContentProperties();
        for (int i = 0; i < openProps.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openProps.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            newProperty.setInstanceProperty(nextProp, value);
        }
        List openPropsAttrs = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        for (int i = 0; i < openPropsAttrs.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openPropsAttrs.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            newProperty.setInstanceProperty(nextProp, value);
        }
        if (newProperty.getType() == null) {
            throw SDOException.noTypeSpecifiedForProperty((String)newProperty.getName());
        }
        if (containingType != null) {
            ((SDOType)containingType).addDeclaredProperty(newProperty);
            if (this.aHelperContext.getXSDHelper().isElement((Property)newProperty) || newProperty.getType().isChangeSummaryType()) {
                newProperty.setNamespaceQualified(true);
            }
            newProperty.buildMapping(containingType.getURI());
        }
        return newProperty;
    }

    public synchronized List define(List types) {
        if (types == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"define", (String)"types"));
        }
        ArrayList<Type> definedTypes = new ArrayList<Type>();
        for (int i = 0; i < types.size(); ++i) {
            Type definedType = this.define((DataObject)types.get(i));
            definedTypes.add(definedType);
        }
        return definedTypes;
    }

    @Override
    public QName getXSDTypeFromSDOType(Type aType) {
        return (QName)this.sdoToXSDTypes.get(aType);
    }

    @Override
    public SDOType getSDOTypeFromXSDType(QName aName) {
        return (SDOType)this.xsdToSDOType.get(aName);
    }

    @Override
    public void setTypesHashMap(Map typesHashMap) {
        this.typesHashMap = typesHashMap;
    }

    @Override
    public Map getTypesHashMap() {
        if (this.typesHashMap == null) {
            this.initTypesHashMap();
        }
        return this.typesHashMap;
    }

    @Override
    public Map getWrappersHashMap() {
        if (this.wrappersHashMap == null) {
            this.initWrappersHashMap();
        }
        return this.wrappersHashMap;
    }

    @Override
    public void setWrappersHashMap(Map aMap) {
        this.wrappersHashMap = aMap;
    }

    @Override
    public void reset() {
        this.interfacesToSDOTypeHashMap = new HashMap<Class, SDOType>();
        this.initWrapperTypes();
        this.initWrappersHashMap();
        this.initTypesHashMap();
        this.namespaceResolver = new NamespaceResolver();
        this.initOpenProps();
        SDOType openSequencedType = (SDOType)this.typesHashMap.get(new QName("org.eclipse.persistence.sdo", "OpenSequencedType"));
        openSequencedType.getXmlDescriptor().setNamespaceResolver(null);
        this.initSdoToXSDType();
        this.initXsdToSDOType();
    }

    public Property defineOpenContentProperty(String uri, DataObject propertyDO) {
        if (propertyDO == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"defineOpenContentProperty", (String)"propertyDO"));
        }
        String name = propertyDO.getString("name");
        Property propertyToReturn = this.aHelperContext.getXSDHelper().getGlobalProperty(uri, name, true);
        if (propertyToReturn == null) {
            propertyToReturn = this.aHelperContext.getXSDHelper().getGlobalProperty(uri, name, false);
        }
        if (propertyToReturn == null || !(propertyToReturn instanceof Property)) {
            ArrayList types = new ArrayList();
            propertyToReturn = this.buildPropertyFromDataObject(propertyDO, null, types);
            this.initializeTypes(types);
            this.defineOpenContentProperty(uri, name, propertyToReturn);
        }
        if (propertyToReturn != null) {
            DataObject newTypeDO;
            Object propDOType = propertyDO.get("type");
            SDOType existingType = (SDOType)propertyToReturn.getType();
            boolean typeMismatch = false;
            if (propDOType instanceof SDOType) {
                SDOType newType = (SDOType)propDOType;
                if (!newType.getQName().equals(existingType.getQName())) {
                    typeMismatch = true;
                }
            } else if (!(!(propDOType instanceof DataObject) || (newTypeDO = (DataObject)propDOType).get("name").equals(existingType.getName()) && newTypeDO.get("uri").equals(existingType.getURI()))) {
                typeMismatch = true;
            }
            if (typeMismatch) {
                throw new IllegalArgumentException("Should not be able to redefine a Property with a different Type.");
            }
        }
        return propertyToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineOpenContentProperty(String propertyUri, String propertyName, Property property) {
        if (propertyUri != null) {
            QName propertyQName = new QName(propertyUri, propertyName);
            this.openContentProperties.put(propertyQName, property);
            boolean isElement = this.aHelperContext.getXSDHelper().isElement(property);
            ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(propertyQName, property, isElement);
            ((SDOProperty)property).setUri(propertyUri);
            if (property.getType().isDataType()) {
                SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
                SDOWrapperType wrapperType = (SDOWrapperType)typeHelper.getWrappersHashMap().get(((SDOProperty)property).getType().getQName());
                if (wrapperType != null) {
                    QName descriptorQname = new QName(propertyUri, propertyName);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().addDescriptorByQName(descriptorQname, wrapperType.getXmlDescriptor(((SDOProperty)property).getXsdType()));
                }
                return;
            }
            XMLDescriptor aDescriptor = ((SDOType)property.getType()).getXmlDescriptor();
            if (aDescriptor != null) {
                XMLDescriptor xMLDescriptor = aDescriptor;
                synchronized (xMLDescriptor) {
                    String rootName = propertyName;
                    String prefix = aDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(propertyUri);
                    if (prefix == null || prefix.equals("")) {
                        prefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(propertyUri);
                        aDescriptor.getNonNullNamespaceResolver().put(prefix, propertyUri);
                    }
                    if (prefix != null && !prefix.equals("")) {
                        rootName = prefix + ":" + rootName;
                    }
                    aDescriptor.setDefaultRootElement(rootName);
                    QName elementType = new QName(propertyUri, rootName);
                    aDescriptor.setDefaultRootElementType(elementType);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().storeXMLDescriptorByQName(aDescriptor);
                }
            }
        }
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        QName qname = new QName(uri, propertyName);
        return (Property)this.openContentProperties.get(qname);
    }

    private static Map getSDOTypeForSimpleJavaTypeMap() {
        return sdoTypeForSimpleJavaType;
    }

    @Override
    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    @Override
    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            return null;
        }
        NamespaceResolver nr = this.getNamespaceResolver();
        String existingPrefixForUri = nr.resolveNamespaceURI(uri);
        if (existingPrefixForUri == null || existingPrefixForUri.equals("")) {
            String newPrefix = this.generatePrefix(uri);
            nr.put(newPrefix, uri);
            return newPrefix;
        }
        return existingPrefixForUri;
    }

    private String generatePrefix(String uri) {
        NamespaceResolver nr = this.getNamespaceResolver();
        if (uri.equals("commonj.sdo")) {
            return nr.generatePrefix("sdo");
        }
        if (uri.equals("commonj.sdo/xml")) {
            return nr.generatePrefix("sdoXML");
        }
        if (uri.equals("commonj.sdo/java")) {
            return nr.generatePrefix("sdoJava");
        }
        return nr.generatePrefix();
    }

    @Override
    public String addNamespace(String prefix, String uri) {
        NamespaceResolver nr = this.getNamespaceResolver();
        String existingPrefixForURI = nr.resolveNamespaceURI(uri);
        if (existingPrefixForURI != null && !existingPrefixForURI.equals("")) {
            return existingPrefixForURI;
        }
        String existingUriForPrefix = nr.resolveNamespacePrefix(prefix);
        if (existingUriForPrefix == null) {
            nr.put(prefix, uri);
            return prefix;
        }
        prefix = this.generatePrefix(uri);
        nr.put(prefix, uri);
        return prefix;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    @Override
    public Map getOpenContentProperties() {
        return this.openContentProperties;
    }

    private void initOpenProps() {
        SDOType typeType = this.getType("commonj.sdo", "Type");
        this.openContentProperties = new HashMap();
        this.openContentProperties.put(SDOConstants.MIME_TYPE_QNAME, SDOConstants.MIME_TYPE_PROPERTY);
        this.openContentProperties.put(SDOConstants.MIME_TYPE_PROPERTY_QNAME, SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        this.openContentProperties.put(SDOConstants.SCHEMA_TYPE_QNAME, new SDOProperty(this.aHelperContext, "org.eclipse.persistence.sdo", "xmlSchemaType", typeType));
        this.openContentProperties.put(SDOConstants.JAVA_CLASS_QNAME, SDOConstants.JAVA_CLASS_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_ELEMENT_QNAME, SDOConstants.XMLELEMENT_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_DATATYPE_QNAME, new SDOProperty(this.aHelperContext, "commonj.sdo/xml", "dataType", typeType));
        this.openContentProperties.put(SDOConstants.XML_ID_PROPERTY_QNAME, SDOConstants.ID_PROPERTY);
        this.openContentProperties.put(SDOConstants.DOCUMENTATION_PROPERTY_QNAME, SDOConstants.DOCUMENTATION_PROPERTY);
    }

    @Override
    public Map getInterfacesToSDOTypeHashMap() {
        return this.interfacesToSDOTypeHashMap;
    }

    @Override
    public Map<Class, SDOType> getImplClassesToSDOType() {
        return this.implClassesToSDOType;
    }

    @Override
    public List getAnonymousTypes() {
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new ArrayList();
        }
        return this.anonymousTypes;
    }

    static {
        SDOTypeHelperDelegate.initSDOTypeForSimpleJavaTypeMap();
    }
}

