/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * The API for this class and its comments are derived from the JPA 2.0 specification 
 * which is developed under the Java Community Process (JSR 317) and is copyright 
 * Sun Microsystems, Inc. 
 *
 * Contributors:
 *     dclarke - Java Persistence 2.0 - Proposed Final Draft (March 13, 2009)
 *               Specification and licensing terms available from
 *               http://jcp.org/en/jsr/detail?id=317
 *
 * EARLY ACCESS - PUBLIC DRAFT
 * This is an implementation of an early-draft specification developed under the 
 * Java Community Process (JCP) and is made available for testing and evaluation 
 * purposes only. The code is not compatible with any specification of the JCP.
 ******************************************************************************/

package javax.persistence;

import java.lang.annotation.Target;
import java.lang.annotation.Retention;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * The OrderColumn annotation specifies a column that is used to maintain the
 * persistent order of a list. The persistence provider is responsible for
 * maintaining the order upon retrieval and in the database. The persistence
 * provider is responsible for updating the ordering upon flushing to the
 * database to reflect any insertion, deletion, or reordering affecting the
 * list. The OrderColumn annotation is specified on a one-to-many or
 * many-to-many relationship or on an element collection. The OrderColumn
 * annotation is specified on the side of the relationship that references the
 * collection that is to be ordered. The order column is not visible as part of
 * the state of the entity or embeddable class.[78] [78]The OrderBy annotation
 * should be used for ordering that is visible as persistent state and
 * maintained by the application. The OrderBy annotation is not used when
 * OrderColumn is specified.
 * 
 * @since Java Persistence 2.0
 */
@Target( { METHOD, FIELD })
@Retention(RUNTIME)
public @interface OrderColumn {
	/** (Optional) The name of the ordering column. */
	String name() default "";

	/** (Optional) Whether the database column is nullable. */
	boolean nullable() default true;

	/**
	 * (Optional) Whether the column is included in SQL INSERT statements
	 * generated by the persistence provider.
	 */
	boolean insertable() default true;

	/**
	 * (Optional) Whether the column is included in SQL UPDATE statements
	 * generated by the persistence provider.
	 */
	boolean updatable() default true;

	/**
	 * (Optional) The SQL fragment that is used when generating the DDL for the
	 * column.
	 */
	String columnDefinition() default "";

	/**
	 * (Optional) Whether the value of the ordering column need to be contiguous
	 * or may be sparse.
	 */
	boolean contiguous() default true;

	/** (Optional) The ordering column value for the first element of the list. */
	int base() default 0;

	/** (Optional) The name of the table that contains the column. */
	String table() default "";
}