/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.models.jpa.metamodel;

import java.util.HashSet;
import java.util.Collection;
import javax.persistence.*;

import static javax.persistence.FetchType.EAGER;
import static javax.persistence.GenerationType.*;
import static javax.persistence.CascadeType.*;

@Entity(name="ComputerMetamodel")
@Table(name="CMP3_MM_COMPUTER")
public class Computer implements java.io.Serializable{
    @Id
    @GeneratedValue(strategy=TABLE, generator="COMPUTER_MM_TABLE_GENERATOR")
    @TableGenerator(
        name="COMPUTER_MM_TABLE_GENERATOR", 
        table="CMP3_MM_COMPUTER_SEQ", 
        pkColumnName="SEQ_MM_NAME", 
        valueColumnName="SEQ_MM_COUNT",
        pkColumnValue="CUST_MM_SEQ"
    )
    @Column(name="COMPUTER_ID")    
    private Integer id;
    
    @Version
    @Column(name="COMPUTER_VERSION")
    private int version;

    @OneToOne
    private Location location;
    
    private String name;

    // The M:1 side is the owning side
    @ManyToOne(fetch=EAGER)//LAZY)
    @JoinTable(name="CMP3_MM_MANUF_MM_COMPUTER", 
            joinColumns = @JoinColumn(name="COMPUTER_ID"), 
            inverseJoinColumns =@JoinColumn(name="PERSON_ID"))   
    private Manufacturer manufacturer;
    
    public Computer() {}

    public Manufacturer getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(Manufacturer manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Location getLocation() {
        return location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    public Integer getId() {    
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int getVersion() { 
        return version; 
    }
    
    protected void setVersion(int version) {
        this.version = version;
    }

}
