/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnPairHandle
extends MWHandle {
    private volatile MWColumnPair columnPair;
    private volatile String tableName;
    private volatile String referenceName;
    private volatile String columnPairName;

    private MWColumnPairHandle() {
    }

    public MWColumnPairHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWColumnPairHandle(MWModel parent, MWColumnPair columnPair, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.columnPair = columnPair;
    }

    public MWColumnPair getColumnPair() {
        return this.columnPair;
    }

    public void setColumnPair(MWColumnPair columnPair) {
        this.columnPair = columnPair;
    }

    protected Node node() {
        return this.getColumnPair();
    }

    public int compareTo(Object o) {
        return this.columnPair.compareTo(((MWColumnPairHandle)o).columnPair);
    }

    public void toString(StringBuffer sb) {
        if (this.columnPair == null) {
            sb.append("null");
        } else {
            this.columnPair.toString(sb);
        }
    }

    public MWColumnPairHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    public void postProjectBuild() {
        MWReference reference;
        MWTable table;
        super.postProjectBuild();
        if (this.tableName != null && this.referenceName != null && this.columnPairName != null && (table = this.getDatabase().tableNamed(this.tableName)) != null && (reference = table.referenceNamed(this.referenceName)) != null) {
            this.columnPair = reference.columnPairNamed(this.columnPairName);
        }
        this.tableName = null;
        this.referenceName = null;
        this.columnPairName = null;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWColumnPairHandle.class);
        descriptor.addDirectMapping("tableName", "getTableNameForTopLink", "setTableNameForTopLink", "table-name/text()");
        descriptor.addDirectMapping("referenceName", "getReferenceNameForTopLink", "setReferenceNameForTopLink", "reference-name/text()");
        descriptor.addDirectMapping("columnPairName", "getColumnPairNameForTopLink", "setColumnPairNameForTopLink", "column-pair-name/text()");
        return descriptor;
    }

    private String getTableNameForTopLink() {
        return this.columnPair == null ? null : this.columnPair.sourceTable().getName();
    }

    private void setTableNameForTopLink(String tableName) {
        this.tableName = tableName;
    }

    private String getReferenceNameForTopLink() {
        return this.columnPair == null ? null : this.columnPair.getReference().getName();
    }

    private void setReferenceNameForTopLink(String referenceName) {
        this.referenceName = referenceName;
    }

    private String getColumnPairNameForTopLink() {
        return this.columnPair == null ? null : this.columnPair.getName();
    }

    private void setColumnPairNameForTopLink(String columnPairName) {
        this.columnPairName = columnPairName;
    }
}

