/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.HashSet;
import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWSetContainerPolicy
extends MWModel
implements MWContainerPolicy {
    private DefaultingContainerClass containerClass;
    private boolean usesSorting;
    private MWClassHandle comparatorClass;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWSetContainerPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        XMLCompositeObjectMapping containerClassMapping = new XMLCompositeObjectMapping();
        containerClassMapping.setAttributeName("containerClass");
        containerClassMapping.setReferenceClass(DefaultingContainerClass.class);
        containerClassMapping.setXPath("container-class");
        descriptor.addMapping((DatabaseMapping)containerClassMapping);
        XMLDirectMapping usesSortingMapping = new XMLDirectMapping();
        usesSortingMapping.setAttributeName("usesSorting");
        usesSortingMapping.setXPath("uses-sorting/text()");
        usesSortingMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)usesSortingMapping);
        XMLCompositeObjectMapping comparatorClassMapping = new XMLCompositeObjectMapping();
        comparatorClassMapping.setAttributeName("comparatorClass");
        comparatorClassMapping.setSetMethodName("setComparatorClassHandleForTopLink");
        comparatorClassMapping.setGetMethodName("getComparatorClassHandleForTopLink");
        comparatorClassMapping.setReferenceClass(MWClassHandle.class);
        comparatorClassMapping.setXPath("comparator-class-handle");
        descriptor.addMapping((DatabaseMapping)comparatorClassMapping);
        return descriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWSetContainerPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        XMLCompositeObjectMapping containerClassMapping = new XMLCompositeObjectMapping();
        containerClassMapping.setAttributeName("containerClass");
        containerClassMapping.setReferenceClass(DefaultingContainerClass.class);
        containerClassMapping.setXPath("container-class");
        descriptor.addMapping((DatabaseMapping)containerClassMapping);
        return descriptor;
    }

    private MWSetContainerPolicy() {
    }

    public MWSetContainerPolicy(MWContainerMapping parent) {
        super(parent);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.containerClass = new DefaultingContainerClass(this);
        this.comparatorClass = new MWClassHandle(this, this.buildComparatorTypeScrubber());
    }

    private MWHandle.NodeReferenceScrubber buildComparatorTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWSetContainerPolicy.this.setComparatorClass(null);
            }

            public String toString() {
                return "MWSetContainerPolicy.buildComparatorTypeScrubber()";
            }
        };
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.containerClass);
        list.add(this.comparatorClass);
    }

    public DefaultingContainerClass getDefaultingContainerClass() {
        return this.containerClass;
    }

    private MWContainerMapping getContainerMapping() {
        return (MWContainerMapping)this.getParent();
    }

    private MWMapping getMapping() {
        return (MWMapping)this.getParent();
    }

    private MWClassAttribute getInstanceVariable() {
        return ((MWMapping)this.getParent()).getInstanceVariable();
    }

    public boolean usesSorting() {
        return this.usesSorting;
    }

    public void setUsesSorting(boolean sort) {
        boolean oldValue = this.usesSorting;
        this.usesSorting = sort;
        this.firePropertyChanged("sort", oldValue, this.usesSorting);
    }

    public MWClass getComparatorClass() {
        return this.comparatorClass.getType();
    }

    public void setComparatorClass(MWClass comparatorClass) {
        MWClass oldValue = this.comparatorClass.getType();
        this.comparatorClass.setType(comparatorClass);
        this.firePropertyChanged("comparatorClass", oldValue, this.comparatorClass.getType());
    }

    public MWClass defaultContainerClass() {
        if (this.getContainerMapping().usesTransparentIndirection()) {
            return this.defaultIndirectContainerClass();
        }
        MWClassAttribute instanceVariable = this.getInstanceVariable();
        MWClass attributeContainerType = instanceVariable.isValueHolder() ? this.getInstanceVariable().getValueType() : this.getInstanceVariable().getType();
        if (attributeContainerType.isAssignableToSet() && attributeContainerType.isInstantiable()) {
            return attributeContainerType;
        }
        return this.typeFor(HashSet.class);
    }

    private MWClass defaultIndirectContainerClass() {
        return this.typeFor(IndirectSet.class);
    }

    public void referenceDescriptorChanged(MWDescriptor newReferenceDescriptor) {
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        MWClass containerType = this.getDefaultingContainerClass().getContainerClass();
        if (containerType != null && !containerType.mightBeAssignableToSet()) {
            currentProblems.add(this.buildProblem("0485"));
        }
        if (this.usesSorting() && containerType != null && !containerType.mightBeAssignableToSortedSet()) {
            currentProblems.add(this.buildProblem("0486"));
        }
        MWClass comparatorType = this.getComparatorClass();
        if (this.usesSorting() && comparatorType == null) {
            currentProblems.add(this.buildProblem("0487"));
        }
        if (this.usesSorting() && comparatorType != null && !comparatorType.mightBeAssignableToComparator()) {
            currentProblems.add(this.buildProblem("0488"));
        }
    }

    public ContainerPolicy runtimeContainerPolicy() {
        return new CollectionContainerPolicy(this.getDefaultingContainerClass().getContainerClass().getName());
    }

    protected void legacy60PostBuild(DescriptorEvent event) {
        super.legacy60PostBuild(event);
        this.comparatorClass = new MWClassHandle(this, this.buildComparatorTypeScrubber());
    }

    private MWClassHandle getComparatorClassHandleForTopLink() {
        return this.comparatorClass.getType() == null ? null : this.comparatorClass;
    }

    private void setComparatorClassHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildComparatorTypeScrubber();
        this.comparatorClass = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

