/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWQueryKeyHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWCollectionOrdering
extends MWModel {
    private volatile boolean ascending;
    public static final String ASCENDING_PROPERTY = "ascending";
    private MWQueryKeyHandle queryKeyHandle;
    public static final String QUERY_KEY_PROPERTY = "queryKey";

    private MWCollectionOrdering() {
    }

    MWCollectionOrdering(MWCollectionMapping owner) {
        super(owner);
    }

    public MWCollectionMapping getOwner() {
        return (MWCollectionMapping)this.getParent();
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.queryKeyHandle = new MWQueryKeyHandle(this, this.buildQueryKeyScrubber());
        this.ascending = true;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean newAscending) {
        boolean oldValue = this.ascending;
        this.ascending = newAscending;
        this.firePropertyChanged(ASCENDING_PROPERTY, oldValue, newAscending);
    }

    public MWQueryKey getQueryKey() {
        return this.queryKeyHandle.getQueryKey();
    }

    public void setQueryKey(MWQueryKey queryKey) {
        MWQueryKey oldValue = this.getQueryKey();
        this.queryKeyHandle.setQueryKey(queryKey);
        this.firePropertyChanged(QUERY_KEY_PROPERTY, oldValue, queryKey);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryKeyHandle);
    }

    private MWHandle.NodeReferenceScrubber buildQueryKeyScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWCollectionOrdering.this.setQueryKey(null);
            }

            public String toString() {
                return "MWCollectionMapping.buildQueryKeyScrubber()";
            }
        };
    }

    public void descriptorUnmapped(Collection mappings) {
        super.descriptorUnmapped(mappings);
        for (MWMapping mapping : mappings) {
            MWQueryKey queryKey = mapping.getAutoGeneratedQueryKey();
            if (queryKey == null || this.getQueryKey() != queryKey) continue;
            this.setQueryKey(null);
            return;
        }
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkQueryKey(currentProblems);
    }

    private void checkQueryKey(List currentProblems) {
        if (this.getQueryKey() == null) {
            currentProblems.add(this.buildProblem("0479"));
        }
    }

    public void adjustRuntimeMapping(CollectionMapping runtimeMapping) {
        if (this.getQueryKey() != null) {
            if (this.isAscending()) {
                runtimeMapping.addAscendingOrdering(this.getQueryKey().getName());
            } else {
                runtimeMapping.addDescendingOrdering(this.getQueryKey().getName());
            }
        }
    }

    public void toString(StringBuffer sb) {
        if (this.getQueryKey() != null) {
            sb.append(this.getQueryKey().getName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWCollectionOrdering.class);
        XMLDirectMapping ascendingMapping = (XMLDirectMapping)descriptor.addDirectMapping(ASCENDING_PROPERTY, "ascending/text()");
        ascendingMapping.setNullValue((Object)Boolean.TRUE);
        XMLCompositeObjectMapping queryKeyHandleMapping = new XMLCompositeObjectMapping();
        queryKeyHandleMapping.setAttributeName("queryKeyHandle");
        queryKeyHandleMapping.setGetMethodName("getQueryKeyHandleForTopLink");
        queryKeyHandleMapping.setSetMethodName("setQueryKeyHandleForTopLink");
        queryKeyHandleMapping.setReferenceClass(MWQueryKeyHandle.class);
        queryKeyHandleMapping.setXPath("query-key-handle");
        descriptor.addMapping((DatabaseMapping)queryKeyHandleMapping);
        return descriptor;
    }

    private MWQueryKeyHandle getQueryKeyHandleForTopLink() {
        return this.queryKeyHandle.getQueryKey() == null ? null : this.queryKeyHandle;
    }

    private void setQueryKeyHandleForTopLink(MWQueryKeyHandle queryKeyHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildQueryKeyScrubber();
        this.queryKeyHandle = queryKeyHandle == null ? new MWQueryKeyHandle(this, scrubber) : queryKeyHandle.setScrubber(scrubber);
    }
}

