/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;

public final class MWOneToManyMapping
extends MWCollectionMapping {
    private MWOneToManyMapping() {
    }

    MWOneToManyMapping(MWRelationalClassDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    public MWOneToManyMapping asMWOneToManyMapping() {
        return this;
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWOneToManyMapping(this);
    }

    protected MWOneToOneMapping backPointerMapping() {
        if (this.getReferenceDescriptor() == null) {
            return null;
        }
        Iterator it = this.getReferenceDescriptor().mappings();
        while (it.hasNext()) {
            MWOneToOneMapping oneToOneMapping;
            MWMapping mapping = (MWMapping)it.next();
            if (!(mapping instanceof MWOneToOneMapping) || (oneToOneMapping = (MWOneToOneMapping)mapping).getReference() == null || oneToOneMapping.getReference() != this.getReference()) continue;
            return oneToOneMapping;
        }
        return null;
    }

    public boolean isOneToManyMapping() {
        return true;
    }

    public MWMethodCodeGenPolicy accessorCodeGenPolicy(MWMethod accessor, MWClassCodeGenPolicy classCodeGenPolicy) {
        MWOneToOneMapping backPointerMapping;
        if (!this.maintainsBidirectionalRelationship() && (backPointerMapping = this.backPointerMapping()) != null) {
            return this.getInstanceVariable().accessorCodeGenPolicy(accessor, backPointerMapping.getInstanceVariable(), this.isPrivateOwned(), classCodeGenPolicy);
        }
        return super.accessorCodeGenPolicy(accessor, classCodeGenPolicy);
    }

    public String iconKey() {
        return "mapping.oneToMany";
    }

    protected Set buildCandidateReferences() {
        return this.buildCandidateTargetReferences();
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new OneToManyMapping();
    }

    public DatabaseMapping runtimeMapping() {
        OneToManyMapping runtimeMapping = (OneToManyMapping)super.runtimeMapping();
        if (this.getReference() != null) {
            Iterator stream = this.getReference().columnPairs();
            while (stream.hasNext()) {
                MWColumnPair pair = (MWColumnPair)stream.next();
                MWColumn sourceColumn = pair.getSourceColumn();
                MWColumn targetColumn = pair.getTargetColumn();
                if (sourceColumn == null || targetColumn == null) continue;
                if (!this.parentDescriptorIsAggregate()) {
                    runtimeMapping.addTargetForeignKeyFieldName(sourceColumn.qualifiedName(), targetColumn.qualifiedName());
                    continue;
                }
                runtimeMapping.addTargetForeignKeyFieldName(sourceColumn.qualifiedName(), this.getName() + "->" + targetColumn.getName() + "_IN_REFERENCE_" + this.getReference().getName());
            }
        }
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWOneToManyMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWCollectionMapping.class);
        return descriptor;
    }
}

