/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.Collection;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class AbstractMWClassRefreshPolicy
implements MWClassRefreshPolicy {
    protected AbstractMWClassRefreshPolicy() {
    }

    public void refreshAttributes(MWClass mwClass, ExternalField[] externalFields) {
        Collection missingAttributes = CollectionTools.collection(mwClass.attributes());
        for (int i = 0; i < externalFields.length; ++i) {
            this.refreshAttribute(mwClass, externalFields[i], missingAttributes);
        }
        this.resolveMissingAttributes(mwClass, missingAttributes);
    }

    private void refreshAttribute(MWClass mwClass, ExternalField externalField, Collection missingAttributes) {
        if (externalField.isSynthetic()) {
            return;
        }
        MWClassAttribute existingAttribute = mwClass.attributeNamed(externalField.getName());
        if (existingAttribute == null) {
            mwClass.addAttribute(externalField);
        } else {
            existingAttribute.refresh(externalField);
            missingAttributes.remove(existingAttribute);
        }
    }

    protected abstract void resolveMissingAttributes(MWClass var1, Collection var2);
}

