/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractReadQuery
extends MWAbstractQuery
implements MWReadQuery {
    private volatile boolean refreshIdentityMapResult;
    private volatile boolean refreshRemoteIdentityMapResult;
    private volatile boolean useWrapperPolicy;
    private volatile boolean maintainCache;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractReadQuery.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractQuery.class);
        XMLDirectMapping maintainCacheMapping = new XMLDirectMapping();
        maintainCacheMapping.setAttributeName("maintainCache");
        maintainCacheMapping.setXPath("maintain-cache/text()");
        maintainCacheMapping.setNullValue((Object)Boolean.TRUE);
        descriptor.addMapping((DatabaseMapping)maintainCacheMapping);
        XMLDirectMapping refreshIdentityMapResultMapping = new XMLDirectMapping();
        refreshIdentityMapResultMapping.setAttributeName("refreshIdentityMapResult");
        refreshIdentityMapResultMapping.setXPath("refresh-identity-map-result/text()");
        refreshIdentityMapResultMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)refreshIdentityMapResultMapping);
        XMLDirectMapping refreshRemoteIdentityMapResultMapping = new XMLDirectMapping();
        refreshRemoteIdentityMapResultMapping.setAttributeName("refreshRemoteIdentityMapResult");
        refreshRemoteIdentityMapResultMapping.setXPath("refresh-remote-identity-map-result/text()");
        refreshRemoteIdentityMapResultMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)refreshRemoteIdentityMapResultMapping);
        XMLDirectMapping useWrapperPolicyMapping = new XMLDirectMapping();
        useWrapperPolicyMapping.setAttributeName("useWrapperPolicy");
        useWrapperPolicyMapping.setXPath("use-wrapper-policy/text()");
        useWrapperPolicyMapping.setNullValue((Object)Boolean.TRUE);
        descriptor.addMapping((DatabaseMapping)useWrapperPolicyMapping);
        return descriptor;
    }

    protected MWAbstractReadQuery() {
    }

    protected MWAbstractReadQuery(MWQueryManager queryManager, String name) {
        super(queryManager, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.refreshIdentityMapResult = false;
        this.refreshRemoteIdentityMapResult = false;
        this.useWrapperPolicy = true;
        this.maintainCache = true;
    }

    public void initializeFrom(MWReadQuery query) {
        super.initializeFrom(query);
        this.setMaintainCache(query.isMaintainCache());
        this.setRefreshIdentityMapResult(query.isRefreshIdentityMapResult());
        this.setRefreshRemoteIdentityMapResult(query.isRefreshRemoteIdentityMapResult());
        this.setUseWrapperPolicy(query.isUseWrapperPolicy());
    }

    public boolean isMaintainCache() {
        return this.maintainCache;
    }

    public void setMaintainCache(boolean maintainCache) {
        boolean oldMaintainCache = this.isMaintainCache();
        this.maintainCache = maintainCache;
        this.firePropertyChanged("maintainCache", oldMaintainCache, maintainCache);
    }

    public boolean isRefreshIdentityMapResult() {
        return this.refreshIdentityMapResult;
    }

    public void setRefreshIdentityMapResult(boolean refreshIdentityMapResult) {
        boolean oldRefreshIdentityMapResult = this.isRefreshIdentityMapResult();
        this.refreshIdentityMapResult = refreshIdentityMapResult;
        this.setRefreshRemoteIdentityMapResult(refreshIdentityMapResult);
        this.firePropertyChanged("refreshIdentityMapResult", oldRefreshIdentityMapResult, refreshIdentityMapResult);
    }

    public boolean isRefreshRemoteIdentityMapResult() {
        return this.refreshRemoteIdentityMapResult;
    }

    public void setRefreshRemoteIdentityMapResult(boolean refreshRemoteIdentityMapResult) {
        boolean oldRefreshRemoteIdentityMapResult = this.isRefreshRemoteIdentityMapResult();
        this.refreshRemoteIdentityMapResult = refreshRemoteIdentityMapResult;
        this.firePropertyChanged("refreshRemoteIdentityMapResult", oldRefreshRemoteIdentityMapResult, refreshRemoteIdentityMapResult);
    }

    public boolean isUseWrapperPolicy() {
        return this.useWrapperPolicy;
    }

    public void setUseWrapperPolicy(boolean useWrapperPolicy) {
        boolean oldUseWrapperPolicy = this.isUseWrapperPolicy();
        this.useWrapperPolicy = useWrapperPolicy;
        this.firePropertyChanged("useWrapperPolicy", oldUseWrapperPolicy, useWrapperPolicy);
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkDoesNotMaintainCacheButDoesRefreshIdentityMapResults(currentProblems);
        this.checkRefreshesIdentityButDoesNotRemoteIdentityMapResults(currentProblems);
    }

    private void checkDoesNotMaintainCacheButDoesRefreshIdentityMapResults(List currentProblems) {
        if (!this.isMaintainCache()) {
            if (this.isRefreshIdentityMapResult()) {
                currentProblems.add(this.buildProblem("0243", this.getName()));
            }
            if (this.isRefreshRemoteIdentityMapResult()) {
                currentProblems.add(this.buildProblem("0242", this.getName()));
            }
        }
    }

    private void checkRefreshesIdentityButDoesNotRemoteIdentityMapResults(List currentProblems) {
        if (this.isRefreshIdentityMapResult() && !this.isRefreshRemoteIdentityMapResult()) {
            currentProblems.add(this.buildProblem("0245", this.getName()));
        }
    }

    public DatabaseQuery runtimeQuery() {
        ObjectLevelReadQuery runtimeQuery = (ObjectLevelReadQuery)super.runtimeQuery();
        runtimeQuery.setShouldMaintainCache(this.isMaintainCache());
        runtimeQuery.setShouldRefreshIdentityMapResult(this.isRefreshIdentityMapResult());
        runtimeQuery.setShouldRefreshRemoteIdentityMapResult(this.isRefreshRemoteIdentityMapResult());
        runtimeQuery.setShouldUseWrapperPolicy(this.isUseWrapperPolicy());
        return runtimeQuery;
    }

    public void adjustFromRuntime(ObjectLevelReadQuery runtimeQuery) {
        super.adjustFromRuntime(runtimeQuery);
        this.setMaintainCache(runtimeQuery.shouldMaintainCache());
        this.setRefreshIdentityMapResult(runtimeQuery.shouldRefreshIdentityMapResult());
        this.setRefreshRemoteIdentityMapResult(runtimeQuery.shouldRefreshRemoteIdentityMapResult());
        this.setUseWrapperPolicy(runtimeQuery.shouldUseWrapperPolicy());
    }
}

