/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class JAXBPrimitiveArrayAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private String componentClassName;
    private Class componentClass;

    public JAXBPrimitiveArrayAttributeAccessor(AttributeAccessor nestedAccessor, ContainerPolicy containerPolicy) {
        this.nestedAccessor = nestedAccessor;
        this.containerPolicy = containerPolicy;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object value = this.nestedAccessor.getAttributeValueFromObject(object);
        Object itemList = this.buildCollectionFromArray(value);
        return itemList;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        Object convertedValue = this.getConvertedValue(value);
        this.nestedAccessor.setAttributeValueInObject(object, convertedValue);
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.componentClass == null && this.componentClassName != null) {
            this.componentClass = ConversionManager.getDefaultManager().convertClassNameToClass(this.getComponentClassName());
        }
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(Class componentClass) {
        this.componentClass = componentClass;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    private Object getConvertedValue(Object collectionValue) {
        Object iterator = this.containerPolicy.iteratorFor(collectionValue);
        int size = this.containerPolicy.sizeFor(collectionValue);
        int i = 0;
        if (this.getComponentClass().equals(ClassConstants.PBOOLEAN)) {
            boolean[] newArray = new boolean[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = (Boolean)this.containerPolicy.next(iterator, null);
            }
            return newArray;
        }
        if (this.getComponentClass().equals(ClassConstants.PCHAR)) {
            char[] newArray = new char[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = ((Character)this.containerPolicy.next(iterator, null)).charValue();
            }
            return newArray;
        }
        if (this.getComponentClass().equals(ClassConstants.PFLOAT)) {
            float[] newArray = new float[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = ((Float)this.containerPolicy.next(iterator, null)).floatValue();
            }
            return newArray;
        }
        if (this.getComponentClass().equals(ClassConstants.PINT)) {
            int[] newArray = new int[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = (Integer)this.containerPolicy.next(iterator, null);
            }
            return newArray;
        }
        if (this.getComponentClass().equals(ClassConstants.PDOUBLE)) {
            double[] newArray = new double[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = (Double)this.containerPolicy.next(iterator, null);
            }
            return newArray;
        }
        if (this.getComponentClass().equals(ClassConstants.PLONG)) {
            long[] newArray = new long[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = (Long)this.containerPolicy.next(iterator, null);
            }
            return newArray;
        }
        if (this.getComponentClass().equals(ClassConstants.PSHORT)) {
            short[] newArray = new short[size];
            while (this.containerPolicy.hasNext(iterator)) {
                newArray[i++] = (Short)this.containerPolicy.next(iterator, null);
            }
            return newArray;
        }
        return null;
    }

    private Object buildCollectionFromArray(Object arrayValue) {
        block9: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                if (ClassConstants.PBOOLEAN.equals(this.componentClass)) {
                                    boolean[] booleanArray = (boolean[])arrayValue;
                                    Object results = this.containerPolicy.containerInstance(booleanArray.length);
                                    for (boolean i : booleanArray) {
                                        this.containerPolicy.addInto((Object)i, results, null);
                                    }
                                    return results;
                                }
                                if (!ClassConstants.PCHAR.equals(this.componentClass)) break block8;
                                char[] charArray = (char[])arrayValue;
                                Object results = this.containerPolicy.containerInstance(charArray.length);
                                for (char i : charArray) {
                                    this.containerPolicy.addInto((Object)Character.valueOf(i), results, null);
                                }
                                break block9;
                            }
                            if (!ClassConstants.PFLOAT.equals(this.componentClass)) break block10;
                            float[] floatArray = (float[])arrayValue;
                            Object results = this.containerPolicy.containerInstance(floatArray.length);
                            for (float i : floatArray) {
                                this.containerPolicy.addInto((Object)Float.valueOf(i), results, null);
                            }
                            break block9;
                        }
                        if (!ClassConstants.PINT.equals(this.componentClass)) break block11;
                        int[] intArray = (int[])arrayValue;
                        Object results = this.containerPolicy.containerInstance(intArray.length);
                        for (int i : intArray) {
                            this.containerPolicy.addInto((Object)i, results, null);
                        }
                        break block9;
                    }
                    if (!ClassConstants.PDOUBLE.equals(this.componentClass)) break block12;
                    double[] doubleArray = (double[])arrayValue;
                    Object results = this.containerPolicy.containerInstance(doubleArray.length);
                    for (double i : doubleArray) {
                        this.containerPolicy.addInto((Object)i, results, null);
                    }
                    break block9;
                }
                if (!ClassConstants.PLONG.equals(this.componentClass)) break block13;
                long[] longArray = (long[])arrayValue;
                Object results = this.containerPolicy.containerInstance(longArray.length);
                for (long i : longArray) {
                    this.containerPolicy.addInto((Object)i, results, null);
                }
                break block9;
            }
            if (!ClassConstants.PSHORT.equals(this.componentClass)) break block9;
            short[] shortArray = (short[])arrayValue;
            Object results = this.containerPolicy.containerInstance(shortArray.length);
            for (short i : shortArray) {
                this.containerPolicy.addInto((Object)i, results, null);
            }
        }
        return null;
    }
}

