/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORMetadata {
    private MetadataAnnotation m_annotation;
    private MetadataAccessibleObject m_accessibleObject;
    private Object m_location;
    private XMLEntityMappings m_entityMappings;
    private String m_xmlElement;

    protected ORMetadata() {
    }

    public ORMetadata(String xmlElement) {
        this.m_xmlElement = xmlElement;
    }

    public ORMetadata(MetadataAccessibleObject accessibleObject) {
        this.m_location = accessibleObject;
        this.m_accessibleObject = accessibleObject;
    }

    public ORMetadata(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject) {
        this.m_location = accessibleObject;
        this.m_annotation = annotation;
        this.m_accessibleObject = accessibleObject;
    }

    protected MetadataAccessibleObject getAccessibleObject() {
        return this.m_accessibleObject;
    }

    public MetadataFactory getMetadataFactory() {
        if (this.getAccessibleObject() != null) {
            return this.getAccessibleObject().getMetadataFactory();
        }
        return this.getEntityMappings().getMetadataFactory();
    }

    public MetadataClass getMetadataClass(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        return this.getMetadataClass(javaClass.getName());
    }

    public MetadataClass getMetadataClass(String className) {
        return this.getMetadataFactory().getClassMetadata(className);
    }

    public Class getJavaClass(MetadataClass metadataClass) {
        return this.getJavaClass(metadataClass.getName());
    }

    public Class getJavaClass(String className) {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getClassForName(className);
        }
        if (className == null || className.equals("") || className.equals("void")) {
            return Void.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("byte[]")) {
            return new byte[0].getClass();
        }
        if (className.equals("java.lang.Byte[]")) {
            return new Byte[0].getClass();
        }
        if (className.equals("char[]")) {
            return new char[0].getClass();
        }
        if (className.equals("java.lang.Character[]")) {
            return new Character[0].getClass();
        }
        return MetadataHelper.getClassForName(className, this.getMetadataFactory().getLoader());
    }

    protected MetadataAnnotation getAnnotation() {
        return this.m_annotation;
    }

    public XMLEntityMappings getEntityMappings() {
        return this.m_entityMappings;
    }

    protected String getIdentifier() {
        return "";
    }

    public Object getLocation() {
        return this.m_location;
    }

    protected String getXMLElement() {
        return this.m_xmlElement;
    }

    protected boolean hasIdentifier() {
        return !this.getIdentifier().equals("");
    }

    protected MetadataClass initXMLClassName(String className) {
        return this.getMetadataFactory().getClassMetadata(this.getEntityMappings().getFullClassName(className));
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        this.m_accessibleObject = accessibleObject;
        this.setEntityMappings(entityMappings);
    }

    protected void initXMLObject(ORMetadata metadata, MetadataAccessibleObject accessibleObject) {
        if (metadata != null) {
            metadata.initXMLObject(accessibleObject, this.m_entityMappings);
        }
    }

    protected void initXMLObjects(List metadatas, MetadataAccessibleObject accessibleObject) {
        for (ORMetadata metadata : metadatas) {
            metadata.initXMLObject(accessibleObject, this.m_entityMappings);
        }
    }

    protected boolean loadedFromAnnotation() {
        return this.m_annotation != null || !(this.getLocation() instanceof URL);
    }

    protected boolean loadedFromEclipseLinkXML() {
        if (this.loadedFromXML()) {
            return this.getLocation().toString().contains("META-INF/eclipselink-orm.xml");
        }
        return false;
    }

    protected boolean loadedFromXML() {
        return this.m_entityMappings != null;
    }

    protected void merge(ORMetadata metadata) {
    }

    protected List mergeORObjectLists(List list1, List list2) {
        boolean found;
        ArrayList<ORMetadata> newList = new ArrayList<ORMetadata>();
        for (ORMetadata obj1 : list1) {
            found = false;
            for (ORMetadata obj2 : list2) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                if (obj2.shouldOverride(obj1)) {
                    newList.add(obj2);
                } else {
                    newList.add(obj1);
                }
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj1);
        }
        for (ORMetadata obj2 : list2) {
            found = false;
            for (ORMetadata obj1 : list1) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj2);
        }
        return newList;
    }

    protected ORMetadata mergeORObjects(ORMetadata obj1, ORMetadata obj2) {
        if (obj2 != null) {
            if (obj1 != null) {
                if (obj2.shouldOverride(obj1)) {
                    return obj2;
                }
            } else {
                return obj2;
            }
        }
        return obj1;
    }

    protected boolean mergePrimitiveBoolean(boolean value1, boolean value2, ORMetadata otherMetadata, String xmlElement) {
        Boolean bool2;
        Boolean bool1 = value1 ? new Boolean(true) : null;
        Boolean bl = bool2 = value2 ? new Boolean(true) : null;
        if (bool1 == null && bool2 == null) {
            return false;
        }
        return (Boolean)this.mergeSimpleObjects(bool1, bool2, otherMetadata, xmlElement);
    }

    protected Object mergeSimpleObjects(Object obj1, Object obj2, ORMetadata otherMetadata, String xmlElement) {
        if (obj1 == null && obj2 == null) {
            return null;
        }
        SimpleORMetadata object1 = obj1 == null ? null : new SimpleORMetadata(obj1, this.getAccessibleObject(), this.getEntityMappings(), xmlElement);
        SimpleORMetadata object2 = obj2 == null ? null : new SimpleORMetadata(obj2, otherMetadata.getAccessibleObject(), otherMetadata.getEntityMappings(), xmlElement);
        return ((SimpleORMetadata)this.mergeORObjects(object1, object2)).getValue();
    }

    protected EntityAccessor reloadEntity(EntityAccessor entity, MetadataDescriptor descriptor) {
        if (this.getEntityMappings() == null) {
            EntityAccessor entityAccessor = new EntityAccessor(entity.getAnnotation(), entity.getJavaClass(), entity.getProject());
            descriptor.setDefaultAccess(entity.getDescriptor().getDefaultAccess());
            entityAccessor.setDescriptor(descriptor);
            return entityAccessor;
        }
        return this.getEntityMappings().reloadEntity(entity, descriptor);
    }

    protected MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor mappedSuperclass, MetadataDescriptor descriptor) {
        if (this.getEntityMappings() == null) {
            MappedSuperclassAccessor mappedSuperclassAccessor = new MappedSuperclassAccessor(mappedSuperclass.getAnnotation(), mappedSuperclass.getJavaClass(), descriptor);
            return mappedSuperclassAccessor;
        }
        return this.getEntityMappings().reloadMappedSuperclass(mappedSuperclass, descriptor);
    }

    public void setAccessibleObject(MetadataAccessibleObject accessibleObject) {
        this.m_accessibleObject = accessibleObject;
    }

    public void setEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings = entityMappings;
        this.m_location = entityMappings.getMappingFile();
    }

    public boolean shouldOverride(ORMetadata existing) {
        MetadataLogger logger = this.getAccessibleObject().getLogger();
        if (existing == null) {
            return true;
        }
        if (!existing.equals(this)) {
            if (this.loadedFromXML() && existing.loadedFromAnnotation()) {
                if (this.hasIdentifier()) {
                    logger.logWarningMessage("metadata_warning_override_named_annotation_with_xml", existing.getAnnotation(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                } else {
                    logger.logWarningMessage("metadata_warning_override_annotation_with_xml", existing.getAnnotation(), existing.getLocation(), this.getLocation());
                }
                return true;
            }
            if (this.loadedFromAnnotation() && existing.loadedFromXML()) {
                if (this.hasIdentifier()) {
                    logger.logWarningMessage("metadata_warning_override_named_annotation_with_xml", this.m_annotation, this.getIdentifier(), this.getLocation(), existing.getLocation());
                } else {
                    logger.logWarningMessage("metadata_warning_override_annotation_with_xml", this.m_annotation, this.getLocation(), existing.getLocation());
                }
            } else {
                if (this.loadedFromEclipseLinkXML() && !existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logWarningMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                    } else {
                        logger.logWarningMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), existing.getLocation(), this.getLocation());
                    }
                    return true;
                }
                if (!this.loadedFromEclipseLinkXML() && existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logWarningMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), this.getLocation(), existing.getLocation());
                    } else {
                        logger.logWarningMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), this.getLocation(), existing.getLocation());
                    }
                } else {
                    if (this.loadedFromAnnotation()) {
                        if (this.hasIdentifier()) {
                            throw ValidationException.conflictingNamedAnnotations(this.getIdentifier(), this.m_annotation, this.getLocation(), existing.getAnnotation(), existing.getLocation());
                        }
                        throw ValidationException.conflictingAnnotations(this.m_annotation, this.getLocation(), existing.getAnnotation(), existing.getLocation());
                    }
                    if (this.hasIdentifier()) {
                        throw ValidationException.conflictingNamedXMLElements(this.getIdentifier(), this.m_xmlElement, this.getLocation(), existing.getLocation());
                    }
                    throw ValidationException.conflictingXMLElements(this.m_xmlElement, this.getAccessibleObject(), this.getLocation(), existing.getLocation());
                }
            }
        }
        return false;
    }

    protected boolean valuesMatch(List<Object> list1, List<Object> list2) {
        if (list1.size() == list2.size()) {
            for (Object obj1 : list1) {
                if (list2.contains(obj1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean valuesMatch(Object value1, Object value2) {
        if (value1 == null && value2 != null || value2 == null && value1 != null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1.equals(value2);
    }

    private class SimpleORMetadata
    extends ORMetadata {
        private Object m_value;

        public SimpleORMetadata(Object value, MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings, String xmlElement) {
            super(xmlElement);
            this.setAccessibleObject(accessibleObject);
            this.setEntityMappings(entityMappings);
            this.m_value = value;
        }

        public boolean equals(Object objectToCompare) {
            if (objectToCompare instanceof SimpleORMetadata) {
                return this.valuesMatch(this.getValue(), ((SimpleORMetadata)objectToCompare).getValue());
            }
            return false;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

