/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

public class EmbeddableAccessor
extends ClassAccessor {
    public EmbeddableAccessor() {
        super("<embeddable>");
    }

    public EmbeddableAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    protected void addPotentialEmbeddableAccessor(MetadataClass potentialEmbeddableClass) {
        EmbeddableAccessor embeddableAccessor;
        if (potentialEmbeddableClass != null && (embeddableAccessor = this.getProject().getEmbeddableAccessor(potentialEmbeddableClass, true)) != null && !embeddableAccessor.isPreProcessed()) {
            embeddableAccessor.setOwningDescriptor(this.getOwningDescriptor());
            embeddableAccessor.preProcess();
        }
    }

    public boolean isEmbeddableAccessor() {
        return true;
    }

    public void preProcess() {
        this.setIsPreProcessed();
        this.processEmbeddable();
        this.addAccessors();
        this.addConverters();
    }

    public void process() {
        this.setIsProcessed();
        if (this.isAnnotationPresent(Cache.class)) {
            throw ValidationException.cacheNotSupportedWithEmbeddable(this.getJavaClass());
        }
        this.processCustomizer();
        this.processCopyPolicy();
        this.processChangeTracking();
        this.processProperties();
        this.processAccessors();
    }

    public void process(MetadataDescriptor owningDescriptor) {
        if (this.isProcessed()) {
            if (!this.hasAccess() && !this.getDescriptor().getDefaultAccess().equals(owningDescriptor.getDefaultAccess())) {
                throw ValidationException.conflictingAccessTypeForEmbeddable(this.getJavaClass(), this.usesPropertyAccess(), owningDescriptor.getJavaClass(), owningDescriptor.getClassAccessor().usesPropertyAccess());
            }
        } else {
            this.setOwningDescriptor(owningDescriptor);
            this.process();
        }
    }

    protected void processAccessType() {
        String owningClassAccessorsAccess = this.getOwningDescriptor().getClassAccessor().getAccessType();
        this.getDescriptor().setDefaultAccess(owningClassAccessorsAccess);
        if (this.getAccess() == null) {
            this.getLogger().logConfigMessage("metadata_access_type", owningClassAccessorsAccess, (Object)this.getJavaClass());
        }
    }

    protected void processEmbeddable() {
        this.processAccessType();
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        }
    }
}

