/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();
    protected HashMap<DatabaseField, MappingAccessor> m_idAccessors = new HashMap();

    public EmbeddedIdAccessor() {
        super("<embedded-id>");
    }

    public EmbeddedIdAccessor(MetadataAnnotation embeddedId, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(embeddedId, accessibleObject, classAccessor);
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, DatabaseMapping aggregatesMapping) {
        super.addFieldNameTranslation(embeddableMapping, overrideName, overrideField, aggregatesMapping);
        this.m_idFields.put(aggregatesMapping.getAttributeName(), overrideField);
    }

    protected void addIdFieldFromAccessor(MappingAccessor accessor) {
        String attributeName = accessor.getAttributeName();
        if (this.m_idFields.containsKey(attributeName)) {
            this.m_idAccessors.put(this.m_idFields.get(attributeName), accessor);
        } else {
            DatabaseField field = accessor.getMapping().getField();
            this.m_idFields.put(attributeName, field);
            this.m_idAccessors.put(field, accessor);
        }
    }

    public boolean isEmbeddedId() {
        return true;
    }

    public void process() {
        if (this.getOwningDescriptor().hasEmbeddedId()) {
            throw ValidationException.multipleEmbeddedIdAnnotationsFound(this.getJavaClass(), this.getAttributeName(), this.getOwningDescriptor().getEmbeddedIdAttributeName());
        }
        if (this.getOwningDescriptor().hasPrimaryKeyFields()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound(this.getJavaClass(), this.getAttributeName(), this.getOwningDescriptor().getIdAttributeName());
        }
        super.process();
        this.getOwningDescriptor().setPKClass(this.getReferenceClass());
        this.getOwningDescriptor().setEmbeddedIdAccessor(this);
        if (this.getReferenceDescriptor().getAccessors().isEmpty()) {
            throw ValidationException.embeddedIdHasNoAttributes(this.getDescriptor().getJavaClass(), this.getReferenceDescriptor().getJavaClass(), this.getReferenceDescriptor().getClassAccessor().getAccessType());
        }
        for (MappingAccessor accessor : this.getReferenceAccessors()) {
            if (accessor.isBasic()) {
                accessor.getMapping().setIsDerivedIdMapping(true);
                this.addIdFieldFromAccessor(accessor);
                continue;
            }
            if (accessor.isDerivedIdClass()) {
                for (MappingAccessor embeddedAccessor : accessor.getReferenceAccessors()) {
                    this.addIdFieldFromAccessor(embeddedAccessor);
                }
                continue;
            }
            throw ValidationException.invalidMappingForEmbeddedId(this.getAttributeName(), this.getJavaClass(), accessor.getAttributeName(), this.getReferenceDescriptor().getJavaClass());
        }
        for (DatabaseField field : this.m_idFields.values()) {
            if (this.getOwningDescriptor().getPrimaryKeyFieldNames().contains(field.getName())) continue;
            DatabaseField clone = (DatabaseField)field.clone();
            if (clone.getTableName().equals("")) {
                clone.setTable(this.getOwningDescriptor().getPrimaryTable());
            }
            this.getOwningDescriptor().addPrimaryKeyField(clone, this.m_idAccessors.get(clone));
        }
    }
}

