/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedGetMethods;

public class EntityListenerMetadata
extends ORMetadata
implements Cloneable {
    private MetadataClass m_entityListenerClass;
    protected EntityListener m_listener;
    private String m_className;
    private String m_postLoad;
    private String m_postPersist;
    private String m_postRemove;
    private String m_postUpdate;
    private String m_prePersist;
    private String m_preRemove;
    private String m_preUpdate;

    public EntityListenerMetadata() {
        super("<entity-listener>");
    }

    public EntityListenerMetadata(MetadataAnnotation entityListeners, MetadataClass entityListenerClass, MetadataAccessibleObject accessibleObject) {
        super(entityListeners, accessibleObject);
        this.m_entityListenerClass = entityListenerClass;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException error) {
            throw new InternalError(error.getMessage());
        }
    }

    protected Method getCallbackMethod(String methodName, Method[] methods) {
        Method method = this.getMethod(methodName, methods);
        if (method == null) {
            throw ValidationException.invalidCallbackMethod(this.m_listener.getListenerClass(), methodName);
        }
        return method;
    }

    Method[] getCandidateCallbackMethodsForEntityListener() {
        HashSet<Method> candidateMethods = new HashSet<Method>();
        Class listenerClass = this.m_listener.getListenerClass();
        Method[] declaredMethods = this.getDeclaredMethods(listenerClass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            candidateMethods.add(declaredMethods[i]);
        }
        Method[] methods = this.getMethods(listenerClass);
        for (int i = 0; i < methods.length; ++i) {
            if (candidateMethods.contains(methods[i])) continue;
            candidateMethods.add(methods[i]);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    Class getClassForName(String classname, ClassLoader loader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, loader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    Method[] getDeclaredMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods(cls);
    }

    public String getIdentifier() {
        return this.m_className;
    }

    Method getMethod(String methodName, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    Method[] getMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethods(cls);
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_entityListenerClass = this.initXMLClassName(this.m_className);
    }

    public void process(MetadataDescriptor descriptor, ClassLoader loader, boolean isDefaultListener) {
        if (this.m_entityListenerClass == null) {
            this.m_entityListenerClass = this.getMetadataFactory().getClassMetadata(this.m_className);
        }
        this.m_listener = new EntityListener(this.getClassForName(this.m_entityListenerClass.getName(), loader), this.getClassForName(descriptor.getJavaClass().getName(), loader));
        this.processCallbackMethods(this.getCandidateCallbackMethodsForEntityListener(), descriptor);
        if (isDefaultListener) {
            descriptor.addDefaultEventListener(this.m_listener);
        } else {
            descriptor.addEntityListenerEventListener(this.m_listener);
        }
    }

    protected void processCallbackMethods(Method[] methods, MetadataDescriptor descriptor) {
        if (this.m_postLoad != null) {
            this.setPostLoad(this.getCallbackMethod(this.m_postLoad, methods));
        }
        if (this.m_postPersist != null) {
            this.setPostPersist(this.getCallbackMethod(this.m_postPersist, methods));
        }
        if (this.m_postRemove != null) {
            this.setPostRemove(this.getCallbackMethod(this.m_postRemove, methods));
        }
        if (this.m_postUpdate != null) {
            this.setPostUpdate(this.getCallbackMethod(this.m_postUpdate, methods));
        }
        if (this.m_prePersist != null) {
            this.setPrePersist(this.getCallbackMethod(this.m_prePersist, methods));
        }
        if (this.m_preRemove != null) {
            this.setPreRemove(this.getCallbackMethod(this.m_preRemove, methods));
        }
        if (this.m_preUpdate != null) {
            this.setPreUpdate(this.getCallbackMethod(this.m_preUpdate, methods));
        }
        for (Method method : methods) {
            MetadataMethod metadataMethod = this.getMetadataClass(method.getDeclaringClass()).getMethod(method.getName(), method.getParameterTypes());
            if (metadataMethod == null) continue;
            if (metadataMethod.isAnnotationPresent(PostLoad.class, descriptor)) {
                this.setPostLoad(method);
            }
            if (metadataMethod.isAnnotationPresent(PostPersist.class, descriptor)) {
                this.setPostPersist(method);
            }
            if (metadataMethod.isAnnotationPresent(PostRemove.class, descriptor)) {
                this.setPostRemove(method);
            }
            if (metadataMethod.isAnnotationPresent(PostUpdate.class, descriptor)) {
                this.setPostUpdate(method);
            }
            if (metadataMethod.isAnnotationPresent(PrePersist.class, descriptor)) {
                this.setPrePersist(method);
            }
            if (metadataMethod.isAnnotationPresent(PreRemove.class, descriptor)) {
                this.setPreRemove(method);
            }
            if (!metadataMethod.isAnnotationPresent(PreUpdate.class, descriptor)) continue;
            this.setPreUpdate(method);
        }
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    protected void setPostLoad(Method method) {
        this.m_listener.setPostCloneMethod(method);
        this.m_listener.setPostRefreshMethod(method);
    }

    public void setPostLoad(String postLoad) {
        this.m_postLoad = postLoad;
    }

    protected void setPostPersist(Method method) {
        this.m_listener.setPostInsertMethod(method);
    }

    public void setPostPersist(String postPersist) {
        this.m_postPersist = postPersist;
    }

    protected void setPostRemove(Method method) {
        this.m_listener.setPostDeleteMethod(method);
    }

    public void setPostRemove(String postRemove) {
        this.m_postRemove = postRemove;
    }

    protected void setPostUpdate(Method method) {
        this.m_listener.setPostUpdateMethod(method);
    }

    public void setPostUpdate(String postUpdate) {
        this.m_postUpdate = postUpdate;
    }

    protected void setPrePersist(Method method) {
        this.m_listener.setPrePersistMethod(method);
    }

    public void setPrePersist(String prePersist) {
        this.m_prePersist = prePersist;
    }

    protected void setPreRemove(Method method) {
        this.m_listener.setPreRemoveMethod(method);
    }

    public void setPreRemove(String preRemove) {
        this.m_preRemove = preRemove;
    }

    protected void setPreUpdate(Method method) {
        this.m_listener.setPreUpdateWithChangesMethod(method);
    }

    public void setPreUpdate(String preUpdate) {
        this.m_preUpdate = preUpdate;
    }
}

