/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.lang.reflect.Member;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeImpl<X, T>
implements Attribute<X, T> {
    private ManagedTypeImpl<X> managedType;
    private DatabaseMapping mapping;

    protected AttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping) {
        this.mapping = mapping;
        this.mapping.setProperty(this.getClass().getName(), this);
        this.managedType = managedType;
    }

    public ManagedTypeImpl<X> getManagedTypeImpl() {
        return this.managedType;
    }

    @Override
    public ManagedType<X> getDeclaringType() {
        return this.getManagedTypeImpl();
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected RelationalDescriptor getDescriptor() {
        return this.getManagedTypeImpl().getDescriptor();
    }

    @Override
    public Member getJavaMember() {
        AttributeAccessor accessor = this.getMapping().getAttributeAccessor();
        if (accessor.isMethodAttributeAccessor()) {
            return ((MethodAttributeAccessor)accessor).getGetMethod();
        }
        return ((InstanceVariableAttributeAccessor)accessor).getAttributeField();
    }

    @Override
    public boolean isAssociation() {
        return this.getMapping().isReferenceMapping();
    }

    @Override
    public boolean isCollection() {
        return this.getMapping().isCollectionMapping();
    }

    public abstract boolean isAttribute();

    public String toString() {
        return "Attribute[" + this.getMapping() + "]";
    }

    @Override
    public Class<T> getJavaType() {
        return this.getMapping().getAttributeClassification();
    }

    @Override
    public String getName() {
        return this.getMapping().getAttributeName();
    }

    @Override
    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        if (this.getMapping().isDirectToFieldMapping()) {
            return Attribute.PersistentAttributeType.BASIC;
        }
        if (this.getMapping().isAggregateObjectMapping()) {
            return Attribute.PersistentAttributeType.EMBEDDED;
        }
        if (this.getMapping().isOneToOneMapping()) {
            return Attribute.PersistentAttributeType.ONE_TO_ONE;
        }
        if (this.getMapping().isOneToManyMapping()) {
            return Attribute.PersistentAttributeType.ONE_TO_MANY;
        }
        if (this.getMapping().isManyToManyMapping()) {
            return Attribute.PersistentAttributeType.MANY_TO_MANY;
        }
        throw new IllegalStateException("Unkonwn mapping type: " + this.getMapping());
    }

    public Bindable.BindableType getBindableType() {
        return null;
    }
}

