/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CoalesceNode
extends Node {
    private List clauses = null;

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        ParseTreeContext context = generationContext.getParseTreeContext();
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addItem("Coalesce", expression);
        }
    }

    public Expression generateExpression(GenerationContext context) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            expressions.add(((Node)i.next()).generateExpression(context));
        }
        Expression whereClause = context.getBaseExpression().coalesce(expressions);
        return whereClause;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        for (Node node : this.clauses) {
            node.validate(context);
        }
        this.setType(((Node)this.clauses.get(0)).getType());
    }

    public List getClauses() {
        return this.clauses;
    }

    public void setClauses(List clauses) {
        this.clauses = clauses;
    }
}

