/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import org.eclipse.persistence.internal.jpa.parsing.AbsNode;
import org.eclipse.persistence.internal.jpa.parsing.AllNode;
import org.eclipse.persistence.internal.jpa.parsing.AndNode;
import org.eclipse.persistence.internal.jpa.parsing.AnyNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.AvgNode;
import org.eclipse.persistence.internal.jpa.parsing.BetweenNode;
import org.eclipse.persistence.internal.jpa.parsing.BooleanLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.ClassForInheritanceNode;
import org.eclipse.persistence.internal.jpa.parsing.CoalesceNode;
import org.eclipse.persistence.internal.jpa.parsing.CollectionMemberDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.ConcatNode;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.CountNode;
import org.eclipse.persistence.internal.jpa.parsing.DateFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.DeleteNode;
import org.eclipse.persistence.internal.jpa.parsing.DivideNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.DoubleLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.EmptyCollectionComparisonNode;
import org.eclipse.persistence.internal.jpa.parsing.EqualsAssignmentNode;
import org.eclipse.persistence.internal.jpa.parsing.EqualsNode;
import org.eclipse.persistence.internal.jpa.parsing.EscapeNode;
import org.eclipse.persistence.internal.jpa.parsing.ExistsNode;
import org.eclipse.persistence.internal.jpa.parsing.FetchJoinNode;
import org.eclipse.persistence.internal.jpa.parsing.FloatLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.FromNode;
import org.eclipse.persistence.internal.jpa.parsing.GreaterThanEqualToNode;
import org.eclipse.persistence.internal.jpa.parsing.GreaterThanNode;
import org.eclipse.persistence.internal.jpa.parsing.GroupByNode;
import org.eclipse.persistence.internal.jpa.parsing.HavingNode;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.InNode;
import org.eclipse.persistence.internal.jpa.parsing.IndexNode;
import org.eclipse.persistence.internal.jpa.parsing.IntegerLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.JoinDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.LengthNode;
import org.eclipse.persistence.internal.jpa.parsing.LessThanEqualToNode;
import org.eclipse.persistence.internal.jpa.parsing.LessThanNode;
import org.eclipse.persistence.internal.jpa.parsing.LikeNode;
import org.eclipse.persistence.internal.jpa.parsing.LiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.LocateNode;
import org.eclipse.persistence.internal.jpa.parsing.LongLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.LowerNode;
import org.eclipse.persistence.internal.jpa.parsing.MapEntryNode;
import org.eclipse.persistence.internal.jpa.parsing.MapKeyNode;
import org.eclipse.persistence.internal.jpa.parsing.MaxNode;
import org.eclipse.persistence.internal.jpa.parsing.MemberOfNode;
import org.eclipse.persistence.internal.jpa.parsing.MinNode;
import org.eclipse.persistence.internal.jpa.parsing.MinusNode;
import org.eclipse.persistence.internal.jpa.parsing.ModNode;
import org.eclipse.persistence.internal.jpa.parsing.MultiplyNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.NodeFactory;
import org.eclipse.persistence.internal.jpa.parsing.NotEqualsNode;
import org.eclipse.persistence.internal.jpa.parsing.NotNode;
import org.eclipse.persistence.internal.jpa.parsing.NullComparisonNode;
import org.eclipse.persistence.internal.jpa.parsing.NullIfNode;
import org.eclipse.persistence.internal.jpa.parsing.OrNode;
import org.eclipse.persistence.internal.jpa.parsing.OrderByItemNode;
import org.eclipse.persistence.internal.jpa.parsing.OrderByNode;
import org.eclipse.persistence.internal.jpa.parsing.ParameterNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.PlusNode;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.internal.jpa.parsing.RangeDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.SetNode;
import org.eclipse.persistence.internal.jpa.parsing.SizeNode;
import org.eclipse.persistence.internal.jpa.parsing.SomeNode;
import org.eclipse.persistence.internal.jpa.parsing.SortDirectionNode;
import org.eclipse.persistence.internal.jpa.parsing.SqrtNode;
import org.eclipse.persistence.internal.jpa.parsing.StringLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.SubqueryNode;
import org.eclipse.persistence.internal.jpa.parsing.SubstringNode;
import org.eclipse.persistence.internal.jpa.parsing.SumNode;
import org.eclipse.persistence.internal.jpa.parsing.TrimNode;
import org.eclipse.persistence.internal.jpa.parsing.UnaryMinus;
import org.eclipse.persistence.internal.jpa.parsing.UpdateNode;
import org.eclipse.persistence.internal.jpa.parsing.UpperNode;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.internal.jpa.parsing.WhereNode;

public class NodeFactoryImpl
implements NodeFactory {
    private ParseTreeContext context;
    private String currentIdentificationVariable;

    public NodeFactoryImpl(String queryInfo) {
        this.context = new ParseTreeContext(this, queryInfo);
    }

    public Object newSelectStatement(int line, int column, Object select, Object from, Object where, Object groupBy, Object having, Object orderBy) {
        QueryNode queryNode = (QueryNode)select;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setContext(this.context);
        tree.setQueryNode(queryNode);
        tree.setFromNode((FromNode)from);
        tree.setWhereNode((WhereNode)where);
        tree.setGroupByNode((GroupByNode)groupBy);
        tree.setHavingNode((HavingNode)having);
        tree.setOrderByNode((OrderByNode)orderBy);
        return tree;
    }

    public Object newUpdateStatement(int line, int column, Object update, Object set, Object where) {
        QueryNode queryNode = (QueryNode)update;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setContext(this.context);
        tree.setQueryNode(queryNode);
        tree.setSetNode((SetNode)set);
        tree.setWhereNode((WhereNode)where);
        return tree;
    }

    public Object newDeleteStatement(int line, int column, Object delete, Object where) {
        QueryNode queryNode = (QueryNode)delete;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setContext(this.context);
        tree.setQueryNode(queryNode);
        tree.setWhereNode((WhereNode)where);
        return tree;
    }

    public Object newSelectClause(int line, int column, boolean distinct, List selectExprs) {
        return this.newSelectClause(line, column, distinct, selectExprs, null);
    }

    public Object newSelectClause(int line, int column, boolean distinct, List selectExprs, List identifiers) {
        SelectNode node = new SelectNode();
        node.setContext(this.context);
        node.setSelectExpressions(selectExprs);
        node.setIdentifiers(identifiers);
        if (identifiers != null) {
            for (int i = 0; i < identifiers.size(); ++i) {
                if (identifiers.get(i) == null) continue;
                this.context.registerJoinVariable((String)identifiers.get(i), (Node)selectExprs.get(i), line, column);
            }
        }
        node.setDistinct(distinct);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newFromClause(int line, int column, List decls) {
        FromNode node = new FromNode();
        node.setContext(this.context);
        node.setDeclarations(decls);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newWhereClause(int line, int column, Object condition) {
        WhereNode node = new WhereNode();
        node.setContext(this.context);
        node.setLeft((Node)condition);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newGroupByClause(int line, int column, List items) {
        GroupByNode node = new GroupByNode();
        node.setContext(this.context);
        node.setGroupByItems(items);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newHavingClause(int line, int column, Object arg) {
        HavingNode node = new HavingNode();
        node.setContext(this.context);
        node.setHaving((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newOrderByClause(int line, int column, List items) {
        OrderByNode node = new OrderByNode();
        node.setContext(this.context);
        node.setOrderByItems(items);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newUpdateClause(int line, int column, String schema, String variable) {
        UpdateNode node = new UpdateNode();
        node.setContext(this.context);
        node.setAbstractSchemaName(schema);
        node.setAbstractSchemaIdentifier(variable);
        this.setPosition(node, line, column);
        this.registerSchema(this.calculateCanonicalName(variable), schema, line, column);
        return node;
    }

    public Object newDeleteClause(int line, int column, String schema, String variable) {
        DeleteNode node = new DeleteNode();
        node.setContext(this.context);
        node.setAbstractSchemaName(schema);
        node.setAbstractSchemaIdentifier(variable);
        this.setPosition(node, line, column);
        this.registerSchema(this.calculateCanonicalName(variable), schema, line, column);
        return node;
    }

    public Object newRangeVariableDecl(int line, int column, String schema, String variable) {
        RangeDeclNode node = new RangeDeclNode();
        node.setAbstractSchemaName(schema);
        node.setVariableName(variable);
        this.setPosition(node, line, column);
        this.registerSchema(node.getCanonicalVariableName(), schema, line, column);
        this.currentIdentificationVariable = variable;
        return node;
    }

    public Object newJoinVariableDecl(int line, int column, boolean outerJoin, Object path, String variable) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        rightNode.setOuterJoin(outerJoin);
        JoinDeclNode node = new JoinDeclNode();
        node.setPath(dotNode);
        node.setVariableName(variable);
        node.setOuterJoin(outerJoin);
        this.setPosition(node, line, column);
        this.context.registerJoinVariable(node.getCanonicalVariableName(), dotNode, line, column);
        this.currentIdentificationVariable = variable;
        return node;
    }

    public Object newFetchJoin(int line, int column, boolean outerJoin, Object path) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        rightNode.setOuterJoin(outerJoin);
        FetchJoinNode node = new FetchJoinNode();
        node.setPath(dotNode);
        node.setOuterJoin(outerJoin);
        this.setPosition(node, line, column);
        this.context.registerFetchJoin(this.currentIdentificationVariable, dotNode);
        return node;
    }

    public Object newCollectionMemberVariableDecl(int line, int column, Object path, String variable) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        rightNode.setRequiresCollectionAttribute(true);
        CollectionMemberDeclNode node = new CollectionMemberDeclNode();
        node.setPath(dotNode);
        node.setVariableName(variable);
        this.setPosition(node, line, column);
        this.context.registerJoinVariable(node.getCanonicalVariableName(), dotNode, line, column);
        this.currentIdentificationVariable = variable;
        return node;
    }

    public Object newVariableDecl(int line, int column, Object path, String variable) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        JoinDeclNode node = new JoinDeclNode();
        node.setPath(dotNode);
        node.setVariableName(variable);
        this.setPosition(node, line, column);
        this.context.registerJoinVariable(node.getCanonicalVariableName(), dotNode, line, column);
        this.currentIdentificationVariable = variable;
        return node;
    }

    public Object newDot(int line, int column, Object left, Object right) {
        DotNode node = new DotNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newVariableAccessOrTypeConstant(int line, int column, String identifier) {
        VariableNode node = new VariableNode(identifier);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newAttribute(int line, int column, String identifier) {
        AttributeNode node = new AttributeNode(identifier);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newQualifiedAttribute(int line, int column, String variable, String attribute) {
        Object varNode = this.newVariableAccessOrTypeConstant(line, column, variable);
        Object attrNode = this.newAttribute(line, column, attribute);
        return this.newDot(line, column, varNode, attrNode);
    }

    public Object newAvg(int line, int column, boolean distinct, Object arg) {
        AvgNode node = new AvgNode();
        node.setLeft((Node)arg);
        node.setDistinct(distinct);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMax(int line, int column, boolean distinct, Object arg) {
        MaxNode node = new MaxNode();
        node.setLeft((Node)arg);
        node.setDistinct(distinct);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMin(int line, int column, boolean distinct, Object arg) {
        MinNode node = new MinNode();
        node.setLeft((Node)arg);
        node.setDistinct(distinct);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSum(int line, int column, boolean distinct, Object arg) {
        SumNode node = new SumNode();
        node.setLeft((Node)arg);
        node.setDistinct(distinct);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newCount(int line, int column, boolean distinct, Object arg) {
        CountNode node = new CountNode();
        node.setLeft((Node)arg);
        node.setDistinct(distinct);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newOr(int line, int column, Object left, Object right) {
        OrNode node = new OrNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newAnd(int line, int column, Object left, Object right) {
        AndNode node = new AndNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newEquals(int line, int column, Object left, Object right) {
        EqualsNode node = new EqualsNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newNotEquals(int line, int column, Object left, Object right) {
        NotEqualsNode node = new NotEqualsNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newGreaterThan(int line, int column, Object left, Object right) {
        GreaterThanNode node = new GreaterThanNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newGreaterThanEqual(int line, int column, Object left, Object right) {
        GreaterThanEqualToNode node = new GreaterThanEqualToNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLessThan(int line, int column, Object left, Object right) {
        LessThanNode node = new LessThanNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLessThanEqual(int line, int column, Object left, Object right) {
        LessThanEqualToNode node = new LessThanEqualToNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newPlus(int line, int column, Object left, Object right) {
        PlusNode node = new PlusNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMinus(int line, int column, Object left, Object right) {
        MinusNode node = new MinusNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMultiply(int line, int column, Object left, Object right) {
        MultiplyNode node = new MultiplyNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newBetween(int line, int column, boolean not, Object arg, Object lower, Object upper) {
        BetweenNode node = new BetweenNode();
        node.setLeft((Node)arg);
        node.setRightForBetween((Node)lower);
        node.setRightForAnd((Node)upper);
        this.setPosition(node, line, column);
        return not ? this.newNot(line, column, node) : node;
    }

    public Object newDivide(int line, int column, Object left, Object right) {
        DivideNode node = new DivideNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newUnaryPlus(int line, int column, Object arg) {
        return arg;
    }

    public Object newUnaryMinus(int line, int column, Object arg) {
        UnaryMinus node = new UnaryMinus();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newNot(int line, int column, Object arg) {
        NotNode node = new NotNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLike(int line, int column, boolean not, Object string, Object pattern, Object escape) {
        LikeNode node = new LikeNode();
        node.setLeft((Node)string);
        node.setRight((Node)pattern);
        node.setEscapeNode((EscapeNode)escape);
        this.setPosition(node, line, column);
        return not ? this.newNot(line, column, node) : node;
    }

    public Object newEscape(int line, int column, Object arg) {
        EscapeNode node = new EscapeNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newIn(int line, int column, boolean not, Object expr, List items) {
        InNode node = new InNode();
        if (not) {
            node.indicateNot();
        }
        node.setLeft((Node)expr);
        node.setTheObjects(items);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newIsNull(int line, int column, boolean not, Object expr) {
        NullComparisonNode node = new NullComparisonNode();
        node.setLeft((Node)expr);
        this.setPosition(node, line, column);
        return not ? this.newNot(line, column, node) : node;
    }

    public Object newIsEmpty(int line, int column, boolean not, Object expr) {
        EmptyCollectionComparisonNode node = new EmptyCollectionComparisonNode();
        node.setLeft((Node)expr);
        if (not) {
            node.indicateNot();
        }
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMemberOf(int line, int column, boolean not, Object expr, Object collection) {
        MemberOfNode node = new MemberOfNode();
        node.setLeft((Node)expr);
        node.setRight((Node)collection);
        if (not) {
            node.indicateNot();
        }
        this.setPosition(node, line, column);
        return node;
    }

    public Object newPositionalParameter(int line, int column, String position) {
        ParameterNode node = new ParameterNode(position);
        this.context.addParameter(position);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newNamedParameter(int line, int column, String name) {
        ParameterNode node = new ParameterNode(name);
        this.context.addParameter(name);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newBooleanLiteral(int line, int column, Object value) {
        BooleanLiteralNode node = new BooleanLiteralNode();
        node.setLiteral(value);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newIntegerLiteral(int line, int column, Object value) {
        IntegerLiteralNode node = new IntegerLiteralNode();
        node.setLiteral(value);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLongLiteral(int line, int column, Object value) {
        LongLiteralNode node = new LongLiteralNode();
        node.setLiteral(value);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newFloatLiteral(int line, int column, Object value) {
        FloatLiteralNode node = new FloatLiteralNode();
        node.setLiteral(value);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newDoubleLiteral(int line, int column, Object value) {
        DoubleLiteralNode node = new DoubleLiteralNode();
        node.setLiteral(value);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newStringLiteral(int line, int column, Object value) {
        StringLiteralNode node = new StringLiteralNode();
        node.setLiteral(value);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newNullLiteral(int line, int column) {
        LiteralNode node = new LiteralNode();
        node.setLiteral(null);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newConcat(int line, int column, List objects) {
        ConcatNode node = new ConcatNode();
        node.setObjects(objects);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSubstring(int line, int column, Object string, Object start, Object length) {
        SubstringNode node = new SubstringNode();
        node.setLeft((Node)string);
        node.setStartPosition((Node)start);
        node.setStringLength((Node)length);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newTrim(int line, int column, NodeFactory.TrimSpecification trimSpec, Object trimChar, Object string) {
        TrimNode node = new TrimNode();
        node.setLeft((Node)string);
        node.setTrimChar((Node)trimChar);
        switch (trimSpec) {
            case LEADING: {
                node.setLeading(true);
                break;
            }
            case TRAILING: {
                node.setTrailing(true);
                break;
            }
            case BOTH: {
                node.setBoth(true);
            }
        }
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLower(int line, int column, Object arg) {
        LowerNode node = new LowerNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newUpper(int line, int column, Object arg) {
        UpperNode node = new UpperNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLocate(int line, int column, Object pattern, Object arg, Object startPos) {
        LocateNode node = new LocateNode();
        node.setFind((Node)pattern);
        node.setFindIn((Node)arg);
        node.setStartPosition((Node)startPos);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newLength(int line, int column, Object arg) {
        LengthNode node = new LengthNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newAbs(int line, int column, Object arg) {
        AbsNode node = new AbsNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSqrt(int line, int column, Object arg) {
        SqrtNode node = new SqrtNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMod(int line, int column, Object left, Object right) {
        ModNode node = new ModNode();
        node.setLeft((Node)left);
        node.setDenominator((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSize(int line, int column, Object arg) {
        SizeNode node = new SizeNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newCurrentDate(int line, int column) {
        DateFunctionNode node = new DateFunctionNode();
        node.useCurrentDate();
        this.setPosition(node, line, column);
        return node;
    }

    public Object newCurrentTime(int line, int column) {
        DateFunctionNode node = new DateFunctionNode();
        node.useCurrentTime();
        this.setPosition(node, line, column);
        return node;
    }

    public Object newCurrentTimestamp(int line, int column) {
        DateFunctionNode node = new DateFunctionNode();
        node.useCurrentTimestamp();
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSubquery(int line, int column, Object select, Object from, Object where, Object groupBy, Object having) {
        QueryNode queryNode = (QueryNode)select;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setQueryNode(queryNode);
        tree.setFromNode((FromNode)from);
        tree.setWhereNode((WhereNode)where);
        tree.setGroupByNode((GroupByNode)groupBy);
        tree.setHavingNode((HavingNode)having);
        tree.setContext(this.context);
        SubqueryNode node = new SubqueryNode();
        node.setParseTree(tree);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newExists(int line, int column, boolean not, Object subquery) {
        ExistsNode node = new ExistsNode();
        if (not) {
            node.indicateNot();
        }
        node.setLeft((Node)subquery);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newIn(int line, int column, boolean not, Object expr, Object subquery) {
        InNode node = new InNode();
        if (not) {
            node.indicateNot();
        }
        node.setLeft((Node)expr);
        node.addNodeToTheObjects((Node)subquery);
        this.setPosition(node, line, column);
        node.setIsListParameterOrSubquery(true);
        return node;
    }

    public Object newAll(int line, int column, Object subquery) {
        AllNode node = new AllNode();
        node.setLeft((Node)subquery);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newAny(int line, int column, Object subquery) {
        AnyNode node = new AnyNode();
        node.setLeft((Node)subquery);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSome(int line, int column, Object subquery) {
        SomeNode node = new SomeNode();
        node.setLeft((Node)subquery);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newAscOrdering(int line, int column, Object arg) {
        OrderByItemNode node = new OrderByItemNode();
        SortDirectionNode sortDirection = new SortDirectionNode();
        sortDirection.useAscending();
        node.setDirection(sortDirection);
        node.setOrderByItem(arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newDescOrdering(int line, int column, Object arg) {
        OrderByItemNode node = new OrderByItemNode();
        SortDirectionNode sortDirection = new SortDirectionNode();
        sortDirection.useDescending();
        node.setDirection(sortDirection);
        node.setOrderByItem(arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newConstructor(int line, int column, String className, List args) {
        ConstructorNode node = new ConstructorNode(className);
        node.setConstructorItems(args);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSetClause(int line, int column, List assignments) {
        SetNode node = new SetNode();
        node.setAssignmentNodes(assignments);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newSetAssignmentClause(int line, int column, Object target, Object value) {
        EqualsAssignmentNode node = new EqualsAssignmentNode();
        node.setLeft((Node)target);
        node.setRight((Node)value);
        return node;
    }

    private void setPosition(Node node, int line, int column) {
        node.setLine(line);
        node.setColumn(column);
    }

    private void registerSchema(String variable, String schema, int line, int column) {
        if (variable != null) {
            this.context.registerSchema(variable, schema, line, column);
        } else {
            this.context.registerSchema(this.calculateCanonicalName(schema), schema, line, column);
        }
    }

    private String calculateCanonicalName(String name) {
        return name == null ? null : IdentificationVariableDeclNode.calculateCanonicalName(name);
    }

    public Object newKey(int line, int column, Object left) {
        MapKeyNode node = new MapKeyNode();
        node.setLeft((Node)left);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newMapEntry(int line, int column, Object arg) {
        MapEntryNode node = new MapEntryNode();
        node.setLeft((Node)arg);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newType(int line, int column, Object left) {
        ClassForInheritanceNode node = new ClassForInheritanceNode();
        node.setLeft((Node)left);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newCaseClause(int line, int column, List whenClauses, Object elseClause) {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    public Object newCoalesceClause(int line, int column, List clauses) {
        CoalesceNode node = new CoalesceNode();
        node.setClauses(clauses);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newNullIfClause(int line, int column, Object left, Object right) {
        NullIfNode node = new NullIfNode();
        node.setLeft((Node)left);
        node.setRight((Node)right);
        this.setPosition(node, line, column);
        return node;
    }

    public Object newWhenClause(int line, int column, Object conditionClause, Object thenClause) {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    public Object newIndex(int line, int column, Object object) {
        IndexNode node = new IndexNode();
        node.setLeft((Node)object);
        this.setPosition(node, line, column);
        return node;
    }
}

