/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.deferred.AnyMappingContentHandler;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnyObjectMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements NullCapableValue {
    private XMLAnyObjectMapping xmlAnyObjectMapping;
    private XMLDescriptor workingDescriptor;

    public XMLAnyObjectMappingNodeValue(XMLAnyObjectMapping xmlAnyObjectMapping) {
        this.xmlAnyObjectMapping = xmlAnyObjectMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return null == xPathFragment;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment rootFragment = null;
        if (this.xmlAnyObjectMapping.isReadOnly()) {
            return false;
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlAnyObjectMapping);
        if (this.xmlAnyObjectMapping.getConverter() != null) {
            objectValue = this.xmlAnyObjectMapping.getConverter().convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller());
        }
        if (null == objectValue) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        boolean wasXMLRoot = false;
        XPathFragment xmlRootFragment = null;
        Object originalValue = objectValue;
        if (this.xmlAnyObjectMapping.usesXMLRoot() && objectValue instanceof XMLRoot) {
            xmlRootFragment = new XPathFragment();
            wasXMLRoot = true;
            objectValue = ((XMLRoot)objectValue).getObject();
        }
        if (objectValue instanceof String) {
            this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, objectValue, session, namespaceResolver);
        } else {
            Namespace generatedNamespace;
            AbstractSession childSession = null;
            try {
                childSession = marshaller.getXMLContext().getSession(objectValue);
            }
            catch (XMLMarshalException e) {
                this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, objectValue, session, namespaceResolver);
                return true;
            }
            XMLDescriptor descriptor = (XMLDescriptor)childSession.getDescriptor(objectValue);
            TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
            if (wasXMLRoot && (generatedNamespace = this.setupFragment((XMLRoot)originalValue, xmlRootFragment, marshalRecord)) != null) {
                extraNamespaces.add(generatedNamespace);
            }
            String defaultRootElementString = descriptor.getDefaultRootElement();
            if (!wasXMLRoot && defaultRootElementString == null) {
                AbstractSessionLog.getLog().log(6, "marshal_warning_null_document_root_element", new Object[]{Helper.getShortClassName(this.getClass()), descriptor});
            } else {
                if (marshaller != null && marshaller.getMarshalListener() != null) {
                    marshaller.getMarshalListener().beforeMarshal(objectValue);
                }
                if (xmlRootFragment != null) {
                    rootFragment = xmlRootFragment;
                } else {
                    rootFragment = new XPathFragment(defaultRootElementString);
                    if (rootFragment.getNamespaceURI() == null && rootFragment.getPrefix() != null) {
                        String uri = descriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(rootFragment.getPrefix());
                        rootFragment.setNamespaceURI(uri);
                    }
                }
                if (!wasXMLRoot) {
                    marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
                }
                this.getXPathNode().startElement(marshalRecord, rootFragment, object, session, descriptor.getNonNullNamespaceResolver(), objectBuilder, objectValue);
                if (this.xmlAnyObjectMapping.shouldAddXsiType(marshaller, descriptor, originalValue, wasXMLRoot)) {
                    String typeValue = descriptor.getSchemaReference().getSchemaContext();
                    this.addTypeAttribute(descriptor, marshalRecord, typeValue);
                }
                this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
                objectBuilder.buildRow((AbstractRecord)marshalRecord, objectValue, childSession, marshaller);
                marshalRecord.endElement(rootFragment, namespaceResolver);
                objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
                if (marshaller != null && marshaller.getMarshalListener() != null) {
                    marshaller.getMarshalListener().afterMarshal(objectValue);
                }
            }
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        block7: {
            try {
                XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                this.workingDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlAnyObjectMapping, this.xmlAnyObjectMapping.getKeepAsElementPolicy());
                if (this.workingDescriptor == null) {
                    QName qname = new QName(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName());
                    this.workingDescriptor = xmlContext.getDescriptor(qname);
                    if (this.workingDescriptor != null && this.workingDescriptor.isWrapper()) {
                        this.workingDescriptor = null;
                    }
                }
                UnmarshalKeepAsElementPolicy policy = this.xmlAnyObjectMapping.getKeepAsElementPolicy();
                if (this.workingDescriptor == null && policy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || policy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                    break block7;
                }
                if (this.workingDescriptor != null) {
                    this.processChild(xPathFragment, unmarshalRecord, atts, this.workingDescriptor, this.xmlAnyObjectMapping);
                    break block7;
                }
                AnyMappingContentHandler handler = new AnyMappingContentHandler(unmarshalRecord, this.xmlAnyObjectMapping.usesXMLRoot());
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = xPathFragment.getPrefix() + ":" + qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                unmarshalRecord.getXMLReader().setContentHandler(handler);
                return true;
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.removeNullCapableValue(this);
        Object childObject = null;
        if (null != unmarshalRecord.getChildRecord()) {
            childObject = unmarshalRecord.getChildRecord().getCurrentObject();
            if (this.xmlAnyObjectMapping.getConverter() != null) {
                childObject = this.xmlAnyObjectMapping.getConverter().convertDataValueToObjectValue(childObject, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
            }
            if (!this.xmlAnyObjectMapping.usesXMLRoot()) {
                unmarshalRecord.setAttributeValue(childObject, this.xmlAnyObjectMapping);
            } else if (this.workingDescriptor != null) {
                String prefix = xPathFragment.getPrefix();
                if (prefix == null && xPathFragment.getNamespaceURI() != null) {
                    prefix = unmarshalRecord.resolveNamespaceUri(xPathFragment.getNamespaceURI());
                }
                childObject = this.workingDescriptor.wrapObjectInXMLRoot(childObject, xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), prefix, false);
                unmarshalRecord.setAttributeValue(childObject, this.xmlAnyObjectMapping);
                this.workingDescriptor = null;
            }
        } else {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlAnyObjectMapping.getKeepAsElementPolicy();
            if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && builder.getNodes().size() > 1) {
                this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlAnyObjectMapping, this.xmlAnyObjectMapping.getConverter(), unmarshalRecord, false, null);
            } else if (this.xmlAnyObjectMapping.isMixedContent()) {
                this.endElementProcessText(unmarshalRecord, this.xmlAnyObjectMapping.getConverter(), xPathFragment, null);
            } else {
                unmarshalRecord.resetStringBuffer();
            }
        }
    }

    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        if (!this.xmlAnyObjectMapping.usesXMLRoot()) {
            unmarshalRecord.setAttributeValue(value, this.xmlAnyObjectMapping);
        } else {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setNamespaceURI(xPathFragment.getNamespaceURI());
            xmlRoot.setSchemaType(unmarshalRecord.getTypeQName());
            xmlRoot.setLocalName(xPathFragment.getLocalName());
            xmlRoot.setObject(value);
            unmarshalRecord.setAttributeValue(xmlRoot, this.xmlAnyObjectMapping);
        }
    }

    public void setNullValue(Object object, Session session) {
        this.xmlAnyObjectMapping.setAttributeValueInObject(object, null);
    }

    public boolean isNullCapableValue() {
        return true;
    }

    private Namespace setupFragment(XMLRoot originalValue, XPathFragment xmlRootFragment, MarshalRecord marshalRecord) {
        Namespace generatedNamespace = null;
        String xpath = originalValue.getLocalName();
        if (originalValue.getNamespaceURI() != null) {
            xmlRootFragment.setNamespaceURI(originalValue.getNamespaceURI());
            String prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(originalValue.getNamespaceURI());
            if (prefix == null || prefix.equals("")) {
                prefix = marshalRecord.getNamespaceResolver().generatePrefix("ns0");
                generatedNamespace = new Namespace(prefix, xmlRootFragment.getNamespaceURI());
            }
            xpath = prefix + ":" + xpath;
        }
        xmlRootFragment.setXPath(xpath);
        return generatedNamespace;
    }

    private void marshalSimpleValue(XPathFragment xmlRootFragment, MarshalRecord marshalRecord, Object originalValue, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (xmlRootFragment != null) {
            QName qname = ((XMLRoot)originalValue).getSchemaType();
            value = this.getValueToWrite(qname, value, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), namespaceResolver);
            Namespace generatedNamespace = this.setupFragment((XMLRoot)originalValue, xmlRootFragment, marshalRecord);
            this.getXPathNode().startElement(marshalRecord, xmlRootFragment, object, session, namespaceResolver, null, null);
            if (generatedNamespace != null) {
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + generatedNamespace.getPrefix(), generatedNamespace.getNamespaceURI());
            }
            this.updateNamespaces(qname, marshalRecord, null);
        }
        if (value instanceof String) {
            marshalRecord.characters((String)value);
        } else {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
        }
        if (xmlRootFragment != null) {
            marshalRecord.endElement(xmlRootFragment, namespaceResolver);
        }
    }

    public XMLAnyObjectMapping getMapping() {
        return this.xmlAnyObjectMapping;
    }

    public boolean isWhitespaceAware() {
        return false;
    }

    public boolean isAnyMappingNodeValue() {
        return true;
    }
}

