/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryAttachmentHandler;
import org.eclipse.persistence.internal.oxm.XMLInlineBinaryHandler;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.SAXException;

public class BinaryMappingContentHandler
extends DeferredContentHandler {
    private DatabaseMapping mapping;
    private NodeValue nodeValue;
    private Converter converter;
    private boolean isCollection;

    public BinaryMappingContentHandler(UnmarshalRecord parentRecord, NodeValue nodeValue, XMLBinaryDataMapping mapping) {
        super(parentRecord);
        this.mapping = mapping;
        this.converter = mapping.getConverter();
        this.nodeValue = nodeValue;
        this.isCollection = false;
    }

    public BinaryMappingContentHandler(UnmarshalRecord parentRecord, NodeValue nodeValue, XMLBinaryDataCollectionMapping mapping) {
        super(parentRecord);
        this.mapping = mapping;
        this.converter = mapping.getValueConverter();
        this.nodeValue = nodeValue;
        this.isCollection = true;
    }

    public void processComplexElement() throws SAXException {
        this.getEvents().remove(0);
        this.executeEvents(new XMLBinaryAttachmentHandler(this.getParent(), this.nodeValue, this.mapping, this.converter, this.isCollection));
    }

    public void processSimpleElement() throws SAXException {
        this.getEvents().remove(0);
        this.executeEvents(new XMLInlineBinaryHandler(this.getParent(), this.nodeValue, this.mapping, this.converter, this.isCollection));
    }

    public void processEmptyElement() throws SAXException {
        this.processSimpleElement();
    }
}

