/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelOutputResolver;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelGenerator {
    protected static final String SCHEMA_FILE_NAME = "schema";
    protected static final String SCHEMA_FILE_EXT = ".xsd";
    protected static final String COLON = ":";
    protected static final String EMPTY_STRING = "";
    protected static final String ATTRIBUTE = "@";
    protected static final String TEXT = "text()";
    protected static final String SLASH = "/";
    protected static final String ID = "ID";
    protected static final String IDREF = "IDREF";

    public Map<String, Schema> generateSchemas(java.util.List<XMLDescriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties, Map<QName, Type> additionalGlobalElements) throws DescriptorException {
        Map<String, Schema> schemaForNamespace = this.generateSchemas(descriptorsToProcess, properties);
        if (additionalGlobalElements != null) {
            for (QName qname : additionalGlobalElements.keySet()) {
                Type type = additionalGlobalElements.get(qname);
                if (!(type instanceof Class)) continue;
                Class tClass = (Class)type;
                String nsKey = qname.getNamespaceURI();
                Schema schema = schemaForNamespace.get(nsKey);
                QName typeAsQName = (QName)XMLConversionManager.getDefaultJavaTypes().get(tClass);
                if (typeAsQName == null) {
                    XMLDescriptor desc = this.getDescriptorByClass(tClass, descriptorsToProcess);
                    if (desc == null) continue;
                    if (schema == null) {
                        schema = this.buildNewSchema(nsKey, new NamespaceResolver(), schemaForNamespace.size(), properties);
                        schemaForNamespace.put(nsKey, schema);
                        typeAsQName = desc.getSchemaReference().getSchemaContextAsQName();
                        Schema schemaForUri = schemaForNamespace.get(typeAsQName.getNamespaceURI());
                        if (!this.importExists(schema, schemaForUri.getTargetNamespace())) {
                            Import newImport = new Import();
                            newImport.setNamespace(schemaForUri.getTargetNamespace());
                            newImport.setSchemaLocation(schemaForUri.getName());
                            schema.getImports().add(newImport);
                        }
                    } else {
                        typeAsQName = desc.getSchemaReference().getSchemaContextAsQName(schema.getNamespaceResolver());
                    }
                }
                if (schema == null) {
                    schema = this.buildNewSchema(nsKey, new NamespaceResolver(), schemaForNamespace.size(), properties);
                    schemaForNamespace.put(nsKey, schema);
                }
                Element element = new Element();
                element.setName(qname.getLocalPart());
                element.setType(this.getSchemaTypeString(typeAsQName, schema));
                schema.addTopLevelElement(element);
            }
        }
        return schemaForNamespace;
    }

    public Map<String, Schema> generateSchemas(java.util.List<XMLDescriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties) throws DescriptorException {
        HashMap<String, Schema> schemaForNamespace = new HashMap<String, Schema>();
        Schema workingSchema = null;
        if (properties == null) {
            properties = new SchemaModelGeneratorProperties();
        }
        for (XMLDescriptor desc : descriptorsToProcess) {
            String namespace;
            XMLSchemaReference schemaRef = desc.getSchemaReference();
            if (schemaRef != null) {
                namespace = schemaRef.getSchemaContextAsQName(desc.getNamespaceResolver()).getNamespaceURI();
                workingSchema = this.getSchema(namespace, desc.getNamespaceResolver(), schemaForNamespace, properties);
                this.addNamespacesToWorkingSchema(desc.getNamespaceResolver(), workingSchema);
                continue;
            }
            for (DatabaseTable table : desc.getTables()) {
                namespace = this.getDefaultRootElementAsQName(desc, table.getName()).getNamespaceURI();
                workingSchema = this.getSchema(namespace, desc.getNamespaceResolver(), schemaForNamespace, properties);
                this.addNamespacesToWorkingSchema(desc.getNamespaceResolver(), workingSchema);
            }
        }
        for (XMLDescriptor xdesc : descriptorsToProcess) {
            this.processDescriptor(xdesc, schemaForNamespace, workingSchema, properties, descriptorsToProcess);
        }
        return schemaForNamespace;
    }

    public Map<String, Schema> generateSchemas(java.util.List<XMLDescriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties, SchemaModelOutputResolver outputResolver, Map<QName, Type> additionalGlobalElements) throws DescriptorException {
        Map<String, Schema> schemas = this.generateSchemas(descriptorsToProcess, properties, additionalGlobalElements);
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext(proj);
        XMLMarshaller marshaller = context.createMarshaller();
        XMLDescriptor schemaDescriptor = (XMLDescriptor)proj.getDescriptor(Schema.class);
        int schemaCount = 0;
        for (String key : schemas.keySet()) {
            Schema schema = schemas.get(key);
            try {
                NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
                schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
                schemaDescriptor.setNamespaceResolver(schemaNamespaces);
                Result target = outputResolver.createOutput(schema.getTargetNamespace(), schema.getName());
                marshaller.marshal((Object)schema, target);
                ++schemaCount;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return schemas;
    }

    public Map<String, Schema> generateSchemas(java.util.List<XMLDescriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties, SchemaModelOutputResolver outputResolver) throws DescriptorException {
        return this.generateSchemas(descriptorsToProcess, properties, outputResolver, null);
    }

    protected void processDescriptor(XMLDescriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        boolean simple = this.isSimple(desc);
        XMLSchemaReference schemaRef = desc.getSchemaReference();
        if (schemaRef != null) {
            if (schemaRef.getType() == 1) {
                workingSchema.addTopLevelComplexTypes(this.buildComplexType(false, desc, schemaForNamespace, workingSchema, properties, descriptors));
            } else if (schemaRef.getType() == 2) {
                workingSchema.addTopLevelSimpleTypes(this.buildSimpleType(desc, workingSchema, true));
            } else if (schemaRef.getType() == 3) {
                workingSchema.addTopLevelElement(this.buildElement(desc, schemaForNamespace, workingSchema, properties, descriptors, simple));
            }
            for (DatabaseTable table : desc.getTables()) {
                String localName = this.getDefaultRootElementAsQName(desc, table.getName()).getLocalPart();
                if (workingSchema.getTopLevelElements().get(localName) != null) continue;
                Element topLevelElement = new Element();
                topLevelElement.setName(localName);
                QName qname = schemaRef.getSchemaContextAsQName(workingSchema.getNamespaceResolver());
                String elementType = qname.getLocalPart();
                String elementTypeUri = qname.getNamespaceURI();
                String elementTypePrefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(elementTypeUri);
                if (elementTypePrefix != null) {
                    elementType = elementTypePrefix + COLON + elementType;
                }
                topLevelElement.setType(elementType);
                workingSchema.addTopLevelElement(topLevelElement);
            }
        } else {
            for (DatabaseTable table : desc.getTables()) {
                String localName = this.getDefaultRootElementAsQName(desc, table.getName()).getLocalPart();
                if (workingSchema.getTopLevelElements().get(localName) != null) continue;
                Element topLevelElement = new Element();
                topLevelElement.setName(localName);
                if (simple) {
                    if (this.isComplexTypeWithSimpleContentRequired(desc)) {
                        topLevelElement.setComplexType(this.buildComplexTypeWithSimpleContent(desc, schemaForNamespace, workingSchema, properties, descriptors));
                    } else {
                        topLevelElement.setSimpleType(this.buildSimpleType(desc, workingSchema, false));
                    }
                } else {
                    topLevelElement.setComplexType(this.buildComplexType(true, desc, schemaForNamespace, workingSchema, properties, descriptors));
                }
                workingSchema.addTopLevelElement(topLevelElement);
            }
        }
    }

    protected Schema getSchema(String uri, NamespaceResolver nr, HashMap<String, Schema> schemaForNamespace, SchemaModelGeneratorProperties properties) {
        Schema schema = schemaForNamespace.get(uri);
        if (schema == null) {
            schema = this.buildNewSchema(uri, nr, schemaForNamespace.size(), properties);
            schemaForNamespace.put(uri, schema);
        }
        return schema;
    }

    protected Element buildElement(XMLDescriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors, boolean simple) {
        Element element = new Element();
        element.setName(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
        if (simple) {
            if (this.isComplexTypeWithSimpleContentRequired(desc)) {
                element.setComplexType(this.buildComplexTypeWithSimpleContent(desc, schemaForNamespace, workingSchema, properties, descriptors));
            } else {
                element.setSimpleType(this.buildSimpleType(desc, workingSchema, false));
            }
        } else {
            element.setComplexType(this.buildComplexType(true, desc, schemaForNamespace, workingSchema, properties, descriptors));
        }
        return element;
    }

    protected SimpleType buildSimpleType(XMLDescriptor desc, Schema workingSchema, boolean global) {
        SimpleType st = global ? this.buildNewSimpleType(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart()) : new SimpleType();
        DatabaseMapping mapping = desc.getMappings().get(0);
        QName qname = (QName)XMLConversionManager.getDefaultJavaTypes().get(mapping.getAttributeClassification());
        String baseType = qname.getLocalPart();
        if (qname.getNamespaceURI() != null) {
            String prefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI());
            if (prefix == null) {
                prefix = workingSchema.getNamespaceResolver().generatePrefix();
                workingSchema.getNamespaceResolver().put(prefix, qname.getNamespaceURI());
            }
            baseType = prefix + COLON + baseType;
        }
        Restriction restriction = new Restriction();
        restriction.setBaseType(baseType);
        st.setRestriction(restriction);
        return st;
    }

    protected SimpleType buildNewSimpleType(String name) {
        SimpleType st = new SimpleType();
        st.setName(name);
        return st;
    }

    protected ComplexType buildComplexType(boolean anonymous, XMLDescriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        ComplexType ct = new ComplexType();
        if (!anonymous) {
            ct.setName(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
        }
        InheritancePolicy inheritancePolicy = desc.getInheritancePolicyOrNull();
        Extension extension = null;
        if (inheritancePolicy != null && inheritancePolicy.getParentClass() != null) {
            extension = new Extension();
            extension.setBaseType(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
            ComplexContent complexContent = new ComplexContent();
            complexContent.setExtension(extension);
            ct.setComplexContent(complexContent);
        }
        Sequence seq = new Sequence();
        for (DatabaseMapping mapping : desc.getMappings()) {
            this.processMapping(mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        }
        if (extension != null) {
            extension.setSequence(seq);
        } else {
            ct.setSequence(seq);
        }
        return ct;
    }

    private ComplexType buildComplexTypeWithSimpleContent(XMLDescriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        ComplexType ct = new ComplexType();
        SimpleContent sc = new SimpleContent();
        Extension extension = new Extension();
        sc.setExtension(extension);
        ct.setSimpleContent(sc);
        for (DatabaseMapping mapping : desc.getMappings()) {
            XMLField xFld = (XMLField)mapping.getField();
            if (xFld.getXPath().equals(TEXT)) {
                extension.setBaseType(this.getSchemaTypeForDirectMapping((XMLDirectMapping)mapping, workingSchema));
                continue;
            }
            if (!xFld.getXPathFragment().isAttribute()) continue;
            String schemaTypeString = this.getSchemaTypeForDirectMapping((XMLDirectMapping)mapping, workingSchema);
            Attribute attr = this.buildAttribute((XMLDirectMapping)mapping, schemaTypeString);
            extension.getOrderedAttributes().add(attr);
        }
        return ct;
    }

    protected String getSchemaTypeForDirectMapping(XMLDirectMapping mapping, Schema workingSchema) {
        return this.getSchemaTypeForElement((XMLField)mapping.getField(), mapping.getAttributeClassification(), workingSchema);
    }

    protected String getSchemaTypeForElement(XMLField xmlField, Class attrClass, Schema workingSchema) {
        String schemaTypeString = null;
        QName schemaType = xmlField.getSchemaType();
        if (schemaType != null) {
            schemaTypeString = this.getSchemaTypeString(schemaType, workingSchema);
        } else if (attrClass != null && !attrClass.equals(ClassConstants.STRING)) {
            QName qName = (QName)XMLConversionManager.getDefaultJavaTypes().get(attrClass);
            if (qName != null) {
                schemaTypeString = this.getSchemaTypeString(qName, workingSchema);
            }
        } else {
            schemaTypeString = this.getSchemaTypeString(XMLConstants.STRING_QNAME, workingSchema);
        }
        return schemaTypeString;
    }

    protected XMLDescriptor getDescriptorByName(String javaClassName, java.util.List<XMLDescriptor> descriptors) {
        for (XMLDescriptor xDesc : descriptors) {
            if (!xDesc.getJavaClassName().equals(javaClassName)) continue;
            return xDesc;
        }
        return null;
    }

    protected XMLDescriptor getDescriptorByClass(Class javaClass, java.util.List<XMLDescriptor> descriptors) {
        for (XMLDescriptor xDesc : descriptors) {
            if (xDesc.getJavaClass() == null || xDesc.getJavaClass() != javaClass) continue;
            return xDesc;
        }
        return null;
    }

    protected void processAnyMapping(Sequence seq, boolean isCollection) {
        Any any = new Any();
        any.setProcessContents("lax");
        any.setMinOccurs("0");
        if (isCollection) {
            any.setMaxOccurs("unbounded");
        }
        seq.addAny(any);
    }

    protected void processXMLDirectMapping(XMLDirectMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        Converter converter;
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        if (frag.isSelfFragment()) {
            return;
        }
        boolean isPk = this.isFragPrimaryKey(frag, mapping);
        String schemaTypeString = null;
        schemaTypeString = isPk ? "xsd:ID" : this.getSchemaTypeForDirectMapping(mapping, workingSchema);
        Class attributeClassification = mapping.getAttributeClassification();
        if (attributeClassification != null && Enum.class.isAssignableFrom(attributeClassification) && (converter = mapping.getConverter()) != null && converter instanceof EnumTypeConverter) {
            this.processEnumeration(schemaTypeString, frag, mapping, seq, ct, workingSchema, converter);
            return;
        }
        if (frag.isAttribute()) {
            Attribute attr = this.buildAttribute(mapping, schemaTypeString);
            ct.getOrderedAttributes().add(attr);
        } else {
            seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
            Element elem = this.elementExistsInSequence((frag = this.getTargetXPathFragment(frag)).getLocalName(), frag.getShortName(), seq);
            if (elem == null) {
                elem = frag.getNamespaceURI() != null ? this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, elem, schemaTypeString) : this.buildElement(frag, schemaTypeString, "0", null);
                seq.addElement(elem);
            }
        }
    }

    protected void processXMLCompositeDirectCollectionMapping(XMLCompositeDirectCollectionMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        XMLField field = (XMLField)mapping.getField();
        XPathFragment frag = field.getXPathFragment();
        seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
        frag = this.getTargetXPathFragment(frag);
        String schemaTypeString = this.getSchemaTypeForElement(field, mapping.getAttributeElementClass(), workingSchema);
        Element element = null;
        if (field.usesSingleNode()) {
            SimpleType st = new SimpleType();
            List list = new List();
            if (schemaTypeString == null) {
                schemaTypeString = this.getSchemaTypeString(XMLConstants.ANY_SIMPLE_TYPE_QNAME, workingSchema);
            }
            list.setItemType(schemaTypeString);
            st.setList(list);
            element = this.buildElement(field.getXPathFragment(), null, "0", null);
            element.setSimpleType(st);
        } else if (frag.getNamespaceURI() != null) {
            element = this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, element, schemaTypeString);
            element.setMaxOccurs("unbounded");
        } else {
            element = this.buildElement(frag, schemaTypeString, "0", "unbounded");
        }
        seq.addElement(element);
    }

    protected void processXMLCompositeMapping(AggregateMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors, boolean collection) {
        String refClassName = mapping.getReferenceClassName();
        XMLDescriptor refDesc = this.getDescriptorByName(refClassName, descriptors);
        if (refDesc == null) {
            throw DescriptorException.descriptorIsMissing(refClassName, mapping);
        }
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        seq = this.buildSchemaComponentsForXPath(frag, seq, schemaForNamespace, workingSchema, properties);
        frag = this.getTargetXPathFragment(frag);
        Element element = this.buildElement(frag, null, "0", collection ? "unbounded" : null);
        ComplexType ctype = null;
        if (refDesc.getSchemaReference() == null) {
            ctype = this.buildComplexType(true, refDesc, schemaForNamespace, workingSchema, properties, descriptors);
        } else {
            element.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
        }
        if (frag.getNamespaceURI() != null) {
            element = this.handleFragNamespace(frag, schemaForNamespace, workingSchema, properties, element, ctype, refDesc);
        } else if (ctype != null) {
            element.setComplexType(ctype);
        }
        seq.addElement(element);
    }

    protected void processXMLChoiceCollectionMapping(XMLChoiceCollectionMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        Map<XMLField, Class> fieldToClassMap = mapping.getFieldToClassMappings();
        ArrayList choiceFieldToClassList = mapping.getChoiceFieldToClassAssociations();
        this.processChoiceMapping(fieldToClassMap, choiceFieldToClassList, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, true);
    }

    protected void processXMLChoiceObjectMapping(XMLChoiceObjectMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        Map<XMLField, Class> fieldToClassMap = mapping.getFieldToClassMappings();
        ArrayList choiceFieldToClassList = mapping.getChoiceFieldToClassAssociations();
        this.processChoiceMapping(fieldToClassMap, choiceFieldToClassList, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, false);
    }

    protected void processChoiceMapping(Map<XMLField, Class> fieldToClassMap, java.util.List<XMLChoiceFieldToClassAssociation> choiceFieldToClassList, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors, boolean isCollection) {
        Choice theChoice = new Choice();
        if (isCollection) {
            theChoice.setMaxOccurs("unbounded");
        }
        for (XMLChoiceFieldToClassAssociation next : choiceFieldToClassList) {
            XMLField field = next.getXmlField();
            Element element = this.buildElement(field.getXPathFragment().getShortName(), "0", null);
            QName schemaTypeQName = field.getSchemaType();
            if (schemaTypeQName != null) {
                element.setType(this.getSchemaTypeString(schemaTypeQName, workingSchema));
            } else {
                element = this.processReferenceDescriptor(element, this.getDescriptorByClass(fieldToClassMap.get(field), descriptors), schemaForNamespace, workingSchema, properties, descriptors, field, false);
            }
            theChoice.addElement(element);
        }
        seq.addChoice(theChoice);
    }

    protected void processXMLObjectReferenceMapping(XMLObjectReferenceMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors, boolean isCollection) {
        String tgtClassName = mapping.getReferenceClassName();
        XMLDescriptor tgtDesc = this.getDescriptorByName(tgtClassName, descriptors);
        if (tgtDesc == null) {
            throw DescriptorException.descriptorIsMissing(tgtClassName, mapping);
        }
        String schemaTypeString = null;
        HashMap associations = mapping.getSourceToTargetKeyFieldAssociations();
        for (XMLField srcField : associations.keySet()) {
            XPathFragment frag;
            XMLField tgtField = (XMLField)associations.get(srcField);
            Vector<DatabaseMapping> mappings = tgtDesc.getMappings();
            Enumeration<DatabaseMapping> mappingsNum = mappings.elements();
            while (mappingsNum.hasMoreElements()) {
                XMLField xFld;
                DatabaseMapping dbMapping = mappingsNum.nextElement();
                if (dbMapping.getField() == null || !(dbMapping.getField() instanceof XMLField) || (xFld = (XMLField)dbMapping.getField()) != tgtField) continue;
                schemaTypeString = this.getSchemaTypeForElement(tgtField, dbMapping.getAttributeClassification(), workingSchema);
            }
            if (schemaTypeString == null) {
                schemaTypeString = this.getSchemaTypeString(XMLConstants.STRING_QNAME, workingSchema);
            }
            if ((frag = srcField.getXPathFragment()).isAttribute()) {
                Attribute attr = this.buildAttribute(frag, schemaTypeString);
                ct.getOrderedAttributes().add(attr);
                continue;
            }
            Element elem = this.buildElement(frag, schemaTypeString, "0", null);
            if (isCollection) {
                elem.setMaxOccurs("unbounded");
            }
            seq.addElement(elem);
        }
    }

    protected void processMapping(DatabaseMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        if (mapping instanceof XMLDirectMapping) {
            this.processXMLDirectMapping((XMLDirectMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties);
        } else if (mapping instanceof XMLCompositeDirectCollectionMapping) {
            this.processXMLCompositeDirectCollectionMapping((XMLCompositeDirectCollectionMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties);
        } else if (mapping instanceof XMLCompositeObjectMapping) {
            this.processXMLCompositeMapping((XMLCompositeObjectMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, false);
        } else if (mapping instanceof XMLCompositeCollectionMapping) {
            this.processXMLCompositeMapping((XMLCompositeCollectionMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, true);
        } else if (mapping instanceof XMLAnyAttributeMapping) {
            AnyAttribute anyAttribute = new AnyAttribute();
            anyAttribute.setProcessContents("lax");
            ct.setAnyAttribute(anyAttribute);
        } else if (mapping instanceof XMLAnyObjectMapping) {
            this.processAnyMapping(seq, false);
        } else if (mapping instanceof XMLAnyCollectionMapping) {
            this.processAnyMapping(seq, true);
        } else if (mapping instanceof XMLChoiceObjectMapping) {
            this.processXMLChoiceObjectMapping((XMLChoiceObjectMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        } else if (mapping instanceof XMLChoiceCollectionMapping) {
            this.processXMLChoiceCollectionMapping((XMLChoiceCollectionMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        } else if (mapping instanceof XMLCollectionReferenceMapping) {
            this.processXMLObjectReferenceMapping((XMLCollectionReferenceMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, true);
        } else if (mapping instanceof XMLObjectReferenceMapping) {
            this.processXMLObjectReferenceMapping((XMLObjectReferenceMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors, false);
        }
    }

    protected Element handleFragNamespace(XPathFragment frag, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, Element element, String schemaTypeString) {
        String fragUri = frag.getNamespaceURI();
        Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
        String targetNS = workingSchema.getTargetNamespace();
        if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && !fragUri.equals(EMPTY_STRING)) {
            if (s.getTopLevelElements().get(frag.getLocalName()) == null) {
                Element globalElement = new Element();
                globalElement.setName(frag.getLocalName());
                globalElement.setType(schemaTypeString);
                s.addTopLevelElement(globalElement);
            }
            element = new Element();
            element.setRef(frag.getShortName());
        } else {
            element = this.buildElement(frag, schemaTypeString, "0", null);
        }
        return element;
    }

    protected Element handleFragNamespace(XPathFragment frag, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, Element element, ComplexType ctype, XMLDescriptor refDesc) {
        String fragUri = frag.getNamespaceURI();
        Element globalElement = null;
        Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
        String targetNS = workingSchema.getTargetNamespace();
        if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && !fragUri.equals(EMPTY_STRING)) {
            globalElement = (Element)s.getTopLevelElements().get(frag.getLocalName());
            if (globalElement == null) {
                globalElement = new Element();
                globalElement.setName(frag.getLocalName());
                if (ctype != null) {
                    globalElement.setComplexType(ctype);
                } else {
                    globalElement.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
                }
                s.addTopLevelElement(globalElement);
            }
            element = new Element();
            element.setMaxOccurs("unbounded");
            element.setRef(frag.getShortName());
        }
        if (globalElement == null && ctype != null) {
            element.setComplexType(ctype);
        }
        return element;
    }

    protected XPathFragment getTargetXPathFragment(XPathFragment frag) {
        if (frag.isAttribute() || frag.isSelfFragment()) {
            return frag;
        }
        while (frag.getNextFragment() != null && !frag.getNextFragment().nameIsText() && (frag = frag.getNextFragment()).getNextFragment() != null && !frag.getNextFragment().nameIsText()) {
        }
        return frag;
    }

    protected Sequence buildSchemaComponentsForXPath(XPathFragment frag, Sequence seq, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties) {
        boolean currentElementExists;
        if (frag.getNextFragment() == null || frag.getNextFragment().nameIsText()) {
            return seq;
        }
        Sequence currentSequence = seq;
        Element currentElement = this.elementExistsInSequence(frag.getLocalName(), frag.getShortName(), currentSequence);
        boolean bl = currentElementExists = currentElement != null;
        if (currentElement == null) {
            currentElement = new Element();
            ComplexType cType = new ComplexType();
            Sequence sequence = new Sequence();
            cType.setSequence(sequence);
            currentElement.setComplexType(cType);
        }
        Element globalElement = null;
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
            String targetNS = workingSchema.getTargetNamespace();
            if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && !fragUri.equals(EMPTY_STRING)) {
                globalElement = (Element)s.getTopLevelElements().get(frag.getLocalName());
                if (globalElement == null) {
                    globalElement = new Element();
                    globalElement.setName(frag.getLocalName());
                    ComplexType gCType = new ComplexType();
                    Sequence gSequence = new Sequence();
                    gCType.setSequence(gSequence);
                    globalElement.setComplexType(gCType);
                    s.addTopLevelElement(globalElement);
                }
                if (!currentElementExists) {
                    currentElement.setComplexType(null);
                    currentElement.setRef(frag.getShortName());
                    currentSequence.addElement(currentElement);
                    currentElementExists = true;
                }
                currentElement = globalElement;
            }
        }
        if (!currentElementExists && globalElement == null) {
            currentElement.setName(frag.getLocalName());
            currentSequence.addElement(currentElement);
        }
        currentSequence = currentElement.getComplexType().getSequence();
        if ((frag = frag.getNextFragment()).getNextFragment() != null && !frag.getNextFragment().nameIsText()) {
            Element childElt = this.buildElement(frag, null, "0", null);
            currentSequence.addElement(childElt);
        }
        return this.buildSchemaComponentsForXPath(frag, currentSequence, schemaForNamespace, workingSchema, properties);
    }

    protected Attribute buildAttribute(XMLDirectMapping mapping, String schemaType) {
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        Attribute attr = new Attribute();
        attr.setName(frag.getShortName());
        attr.setType(schemaType);
        return attr;
    }

    protected Attribute buildAttribute(XPathFragment frag, String schemaType) {
        Attribute attr = new Attribute();
        attr.setName(frag.getShortName());
        attr.setType(schemaType);
        return attr;
    }

    protected Element buildElement(XPathFragment frag, String schemaType, String minOccurs, String maxOccurs) {
        Element element = new Element();
        element.setName(frag.getLocalName());
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(frag.containsIndex() ? "unbounded" : maxOccurs);
        if (schemaType != null) {
            element.setType(schemaType);
        }
        return element;
    }

    protected Element buildElement(String name, String minOccurs, String maxOccurs) {
        Element element = new Element();
        element.setName(name);
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(maxOccurs);
        return element;
    }

    public boolean areNamespacesEqual(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null || ns2.equals(EMPTY_STRING);
        }
        return ns1.equals(ns2) || ns1.equals(EMPTY_STRING) && ns2 == null;
    }

    protected String getSchemaTypeString(QName schemaType, Schema workingSchema) {
        String schemaTypeString = schemaType.getLocalPart();
        String uri = schemaType.getNamespaceURI();
        String prefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(uri);
        if (prefix == null && !this.areNamespacesEqual(uri, workingSchema.getDefaultNamespace())) {
            prefix = uri.equals("http://www.w3.org/2001/XMLSchema") ? workingSchema.getNamespaceResolver().generatePrefix("xsd") : (uri.equals("http://www.w3.org/2001/XMLSchema-instance") ? workingSchema.getNamespaceResolver().generatePrefix("xsi") : workingSchema.getNamespaceResolver().generatePrefix());
            workingSchema.getNamespaceResolver().put(prefix, uri);
        }
        if (prefix != null) {
            schemaTypeString = prefix + COLON + schemaTypeString;
        }
        return schemaTypeString;
    }

    protected void addNamespacesToWorkingSchema(NamespaceResolver nr, Schema workingSchema) {
        if (nr != null) {
            Vector descNamespaces = nr.getNamespaces();
            for (Namespace nextNamespace : descNamespaces) {
                workingSchema.getNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
            }
        }
    }

    protected Schema buildNewSchema(String uri, NamespaceResolver nr, int schemaCount, SchemaModelGeneratorProperties properties) {
        Properties props;
        Schema schema = new Schema();
        schema.setName(SCHEMA_FILE_NAME + schemaCount + SCHEMA_FILE_EXT);
        ++schemaCount;
        String defaultNamespace = null;
        if (nr != null && (defaultNamespace = nr.getDefaultNamespaceURI()) != null) {
            schema.setDefaultNamespace(defaultNamespace);
            schema.getNamespaceResolver().setDefaultNamespaceURI(defaultNamespace);
        }
        if (!uri.equals(EMPTY_STRING)) {
            schema.setTargetNamespace(uri);
            String prefix = null;
            if (nr != null) {
                prefix = nr.resolveNamespaceURI(uri);
            }
            if (prefix == null && !uri.equals(defaultNamespace)) {
                prefix = schema.getNamespaceResolver().generatePrefix();
                schema.getNamespaceResolver().put(prefix, uri);
            }
        }
        if (properties != null && (props = properties.getProperties(uri)) != null) {
            if (props.containsKey("elementFormQualified")) {
                schema.setElementFormDefault((Boolean)props.get("elementFormQualified"));
            }
            if (props.containsKey("attributeFormQualified")) {
                schema.setAttributeFormDefault((Boolean)props.get("attributeFormQualified"));
            }
        }
        return schema;
    }

    protected boolean importExists(Schema schema, String schemaName) {
        java.util.List imports = schema.getImports();
        for (Import nextImport : imports) {
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }

    protected QName getDefaultRootElementAsQName(XMLDescriptor desc, String qualifiedTableName) {
        QName qName = null;
        int idx = qualifiedTableName.indexOf(COLON);
        String localName = qualifiedTableName.substring(idx + 1);
        NamespaceResolver nsResolver = desc.getNamespaceResolver();
        if (nsResolver == null) {
            qName = new QName(localName);
        } else if (idx > -1) {
            String prefix = qualifiedTableName.substring(0, idx);
            String uri = nsResolver.resolveNamespacePrefix(prefix);
            qName = new QName(uri, localName);
        } else {
            qName = nsResolver.getDefaultNamespaceURI() != null ? new QName(nsResolver.getDefaultNamespaceURI(), localName) : new QName(localName);
        }
        return qName;
    }

    protected Element processReferenceDescriptor(Element element, XMLDescriptor refDesc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors, XMLField field, boolean isCollection) {
        ComplexType ctype = null;
        if (refDesc.getSchemaReference() == null) {
            ctype = this.buildComplexType(true, refDesc, schemaForNamespace, workingSchema, properties, descriptors);
        } else {
            element.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
        }
        XPathFragment frag = field.getXPathFragment();
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
            String targetNS = workingSchema.getTargetNamespace();
            if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && !fragUri.equals(EMPTY_STRING)) {
                if (s.getTopLevelElements().get(frag.getShortName()) == null) {
                    Element globalElement = new Element();
                    globalElement.setName(frag.getLocalName());
                    if (ctype != null) {
                        globalElement.setComplexType(ctype);
                    } else {
                        globalElement.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
                    }
                    s.getTopLevelElements().put(frag.getShortName(), globalElement);
                }
                element = new Element();
                element.setMinOccurs("0");
                if (isCollection) {
                    element.setMaxOccurs("unbounded");
                }
                element.setRef(frag.getShortName());
            } else {
                element.setComplexType(ctype);
            }
        } else if (ctype != null) {
            element.setComplexType(ctype);
        }
        return element;
    }

    protected Element elementExistsInSequence(String elementName, String refString, Sequence seq) {
        if (seq.isEmpty()) {
            return null;
        }
        java.util.List existingElements = seq.getOrderedElements();
        for (Element element : existingElements) {
            if ((element.getRef() == null || !element.getRef().equals(refString)) && (element.getName() == null || !element.getName().equals(elementName))) continue;
            return element;
        }
        return null;
    }

    protected boolean isSimple(XMLDescriptor desc) {
        boolean isSimple = false;
        for (DatabaseMapping mapping : desc.getMappings()) {
            if (!mapping.isDirectToFieldMapping()) break;
            XMLField xFld = (XMLField)mapping.getField();
            if (!xFld.getXPath().equals(TEXT)) continue;
            isSimple = true;
            break;
        }
        return isSimple;
    }

    protected boolean isComplexTypeWithSimpleContentRequired(XMLDescriptor desc) {
        return desc.getMappings().size() > 1;
    }

    protected void processEnumeration(String schemaTypeString, XPathFragment frag, XMLDirectMapping mapping, Sequence seq, ComplexType ct, Schema workingSchema, Converter converter) {
        Element elem = null;
        Attribute attr = null;
        if (frag.isAttribute()) {
            attr = this.buildAttribute(mapping, schemaTypeString);
        } else {
            elem = this.buildElement(frag, schemaTypeString, "0", null);
        }
        Collection fieldValues = ((EnumTypeConverter)converter).getAttributeToFieldValues().values();
        ArrayList<String> facets = new ArrayList<String>();
        for (String field : fieldValues) {
            facets.add(field);
        }
        Restriction restriction = new Restriction();
        restriction.setEnumerationFacets(facets);
        SimpleType st = new SimpleType();
        st.setRestriction(restriction);
        if (frag.isAttribute()) {
            attr.setSimpleType(st);
            ct.getOrderedAttributes().add(attr);
        } else {
            elem.setSimpleType(st);
            seq.addElement(elem);
        }
    }

    protected boolean isFragPrimaryKey(XPathFragment frag, XMLDirectMapping mapping) {
        return false;
    }

    private boolean isBuiltInJavaType(Class jClass) {
        return XMLConversionManager.getDefaultJavaTypes().containsKey(jClass.getName()) || jClass.getName().startsWith("java.") || jClass.getName().startsWith("javax.");
    }

    private QName getBuiltInJavaType(Class jClass) {
        if (!this.isBuiltInJavaType(jClass)) {
            return null;
        }
        return (QName)XMLConversionManager.getDefaultJavaTypes().get(jClass.getName());
    }
}

