/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBUnmarshaller
implements Unmarshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLUnmarshaller xmlUnmarshaller;
    private JAXBContext jaxbContext;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private HashMap<QName, Class> qNamesToDeclaredClasses;

    public JAXBUnmarshaller(XMLUnmarshaller newXMLUnmarshaller) {
        this.xmlUnmarshaller = newXMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener(new JAXBUnmarshalListener(this));
    }

    public XMLUnmarshaller getXMLUnmarshaller() {
        return this.xmlUnmarshaller;
    }

    public Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(file);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(inputStream);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(url);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(inputSource);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(reader);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(node);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object obj) {
        if (obj instanceof XMLRoot) {
            return this.createJAXBElementFromXMLRoot((XMLRoot)obj);
        }
        if (obj instanceof WrappedValue) {
            return this.createJAXBElementFromWrappedValue((WrappedValue)obj);
        }
        AbstractSession sess = this.xmlUnmarshaller.getXMLContext().getSession(obj);
        XMLDescriptor desc = (XMLDescriptor)sess.getClassDescriptor(obj);
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return this.createJAXBElement(new QName(""), obj.getClass(), obj);
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = desc.getNamespaceResolver().resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        QName qname = rootNamespaceUri == null ? new QName(rootName) : new QName(rootNamespaceUri, rootName);
        return this.createJAXBElement(qname, obj.getClass(), obj);
    }

    public JAXBElement unmarshal(Node node, Class javaClass) throws JAXBException {
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, javaClass));
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object value = this.xmlUnmarshaller.unmarshal(source);
            return this.createJAXBElementIfRequired(value);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public JAXBElement unmarshal(Source source, Class javaClass) throws JAXBException {
        if (javaClass.isArray() && this.jaxbContext.getArrayClassesToGeneratedClasses() != null) {
            Class classToUnmarshalTo = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName());
            return this.unmarshal(source, classToUnmarshalTo);
        }
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, javaClass));
    }

    public JAXBElement unmarshal(Source source, Type type) throws JAXBException {
        Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
        if (unmarshalClass != null) {
            return this.unmarshal(source, unmarshalClass);
        }
        if (type instanceof Class) {
            return this.unmarshal(source, (Class)type);
        }
        return null;
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Class javaClass) throws JAXBException {
        StAXSource source = new StAXSource(streamReader);
        return this.unmarshal((Source)source, javaClass);
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Type type) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName(STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor(staxResult, new Class[]{XMLStreamReader.class}, false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor(cons, new Object[]{streamReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source, type);
    }

    public Object unmarshal(XMLStreamReader streamReader) throws JAXBException {
        StAXSource source = new StAXSource(streamReader);
        return this.unmarshal(source);
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Class javaClass) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName(STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor(staxResult, new Class[]{XMLEventReader.class}, false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor(cons, new Object[]{eventReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source, javaClass);
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Type type) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName(STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor(staxResult, new Class[]{XMLEventReader.class}, false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor(cons, new Object[]{eventReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source, type);
    }

    public Object unmarshal(XMLEventReader eventReader) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName(STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor(staxResult, new Class[]{XMLEventReader.class}, false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor(cons, new Object[]{eventReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this);
    }

    public void setValidating(boolean validate) throws JAXBException {
        if (validate) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlUnmarshaller.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException(key, value);
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException("Unsupported Property");
    }

    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setSchema(Schema schema) {
        this.xmlUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.xmlUnmarshaller.getSchema();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller unmarshaller) {
        this.xmlUnmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerAdapter(unmarshaller));
    }

    public void setUnmarshalCallbacks(HashMap callbacks) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(callbacks);
    }

    private Object createJAXBElementIfRequired(Object value) {
        if (value instanceof WrappedValue) {
            return this.createJAXBElementFromWrappedValue((WrappedValue)value);
        }
        if (value instanceof XMLRoot) {
            return this.createJAXBElementFromXMLRoot((XMLRoot)value);
        }
        return value;
    }

    private JAXBElement createJAXBElementFromWrappedValue(WrappedValue wrappedValue) {
        Object unwrappedValue = wrappedValue.getWrappedValue();
        if (unwrappedValue == null && wrappedValue.getWrappedValueClass().equals(ClassConstants.STRING) && !wrappedValue.isSetValue()) {
            unwrappedValue = "";
        }
        return this.createJAXBElement(wrappedValue.getQName(), wrappedValue.getWrappedValueClass(), unwrappedValue);
    }

    private JAXBElement createJAXBElementFromXMLRoot(XMLRoot xmlRoot) {
        Class declaredClass;
        Object value = xmlRoot.getObject();
        QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
        if (value == null) {
            return this.createJAXBElement(qname, Object.class, value);
        }
        if (value instanceof ManyValue) {
            value = ((ManyValue)value).getItem();
        }
        if (this.qNamesToDeclaredClasses != null && (declaredClass = this.qNamesToDeclaredClasses.get(qname)) != null) {
            return this.createJAXBElement(qname, declaredClass, value);
        }
        XMLDescriptor descriptorForQName = this.xmlUnmarshaller.getXMLContext().getDescriptor(qname);
        if (descriptorForQName != null) {
            return this.createJAXBElement(qname, descriptorForQName.getJavaClass(), value);
        }
        return this.createJAXBElement(qname, value.getClass(), value);
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (theClass == null) {
            return new JAXBElement(qname, Object.class, value);
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = ClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> qNamesToDeclaredClassesMap) {
        this.qNamesToDeclaredClasses = qNamesToDeclaredClassesMap;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }
}

