/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private HashMap<String, Schema> schemaForNamespace;
    private Schema schema;
    private int schemaCount;
    private Helper helper;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, SchemaTypeInfo> schemaTypeInfo;
    private HashMap<String, QName> userDefinedSchemaTypes;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
    }

    public Schema generateSchema(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap<String, QName> userDefinedSchemaTypes, HashMap<String, NamespaceInfo> packageToNamespaceMappings, HashMap<QName, ElementDeclaration> additionalGlobalElements) {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToNamespaceMappings = packageToNamespaceMappings;
        this.schemaCount = 0;
        this.schemaTypeInfo = new HashMap(typeInfo.size());
        for (JavaClass javaClass : typeInfoClasses) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (additionalGlobalElements != null) {
            this.addGlobalElements(additionalGlobalElements);
        }
        return this.schema;
    }

    public void addSchemaComponents(JavaClass myClass) {
        Object type;
        String myClassName = myClass.getQualifiedName();
        Element rootElement = null;
        TypeInfo info = this.typeInfo.get(myClassName);
        if (info.isTransient()) {
            return;
        }
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        this.schemaTypeInfo.put(myClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(myClass.getPackageName());
        if (namespaceInfo.getLocation() != null) {
            return;
        }
        Schema schema = this.getSchemaForNamespace(info.getClassNamespace());
        info.setSchema(schema);
        String typeName = info.getSchemaTypeName();
        String pfx = "";
        Property valueField = null;
        if (this.helper.isAnnotationPresent(myClass, XmlRootElement.class)) {
            Schema rootElementSchema;
            int idx;
            char ch;
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(myClass, XmlRootElement.class);
            rootElement = new Element();
            String elementName = rootElemAnnotation.name();
            if ((elementName.equals("##default") || elementName.equals("")) && (elementName = myClassName.indexOf("$") != -1 ? Introspector.decapitalize(myClassName.substring(myClassName.lastIndexOf(36) + 1)) : Introspector.decapitalize(myClassName.substring(myClassName.lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(ch = elementName.charAt((idx = elementName.length() - 1) - 1))) {
                char lastCh = Character.toUpperCase(elementName.charAt(idx));
                elementName = elementName.substring(0, idx) + lastCh;
            }
            rootElement.setName(elementName);
            String rootNamespace = rootElemAnnotation.namespace();
            if (rootNamespace.equals("##default")) {
                rootElementSchema = this.getSchemaForNamespace(namespaceInfo.getNamespace());
                if (rootElementSchema != null) {
                    rootElementSchema.addTopLevelElement(rootElement);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), rootNamespace));
                rootNamespace = namespaceInfo.getNamespace();
            } else {
                rootElementSchema = this.getSchemaForNamespace(rootNamespace);
                if (rootElementSchema != null) {
                    rootElementSchema.addTopLevelElement(rootElement);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(rootNamespace, elementName));
            }
            Schema rootSchema = this.getSchemaForNamespace(rootNamespace);
            this.addImportIfRequired(rootSchema, schema, schema.getTargetNamespace());
            if (rootSchema != null && !info.getClassNamespace().equals("")) {
                pfx = this.getPrefixForNamespace(info.getClassNamespace(), rootSchema.getNamespaceResolver());
                if (pfx == null) {
                    pfx = rootSchema.getNamespaceResolver().generatePrefix();
                    rootSchema.getNamespaceResolver().put(pfx, info.getClassNamespace());
                }
                pfx = pfx + ":";
            }
        }
        ArrayList<String> propertyNames = info.getPropertyNames();
        if (info.isEnumerationType() || propertyNames.size() == 1 && this.helper.isAnnotationPresent(info.getProperties().get(propertyNames.get(0)).getElement(), XmlValue.class)) {
            type = new SimpleType();
            if (typeName.equals("")) {
                if (rootElement != null) {
                    rootElement.setSimpleType((SimpleType)type);
                }
            } else {
                ((SimpleType)type).setName(typeName);
                schema.addTopLevelSimpleTypes((SimpleType)type);
                if (rootElement != null) {
                    rootElement.setType(pfx + ((SimpleType)type).getName());
                }
            }
            QName restrictionType = null;
            Restriction restriction = new Restriction();
            if (info.isEnumerationType()) {
                restrictionType = ((EnumTypeInfo)info).getRestrictionBase();
                restriction.setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)info));
                restriction.setBaseType("xsd:" + restrictionType.getLocalPart());
                ((SimpleType)type).setRestriction(restriction);
            } else {
                valueField = info.getProperties().get(propertyNames.get(0));
                QName baseType = null;
                baseType = valueField.getType().isArray() ? this.getSchemaTypeFor(valueField.getType().getComponentType()) : (valueField.getGenericType() != null ? this.getSchemaTypeFor(valueField.getGenericType()) : this.getSchemaTypeFor(valueField.getType()));
                String prefix = null;
                if (baseType.getNamespaceURI() != null && !baseType.getNamespaceURI().equals("")) {
                    prefix = baseType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(baseType.getNamespaceURI(), schema.getNamespaceResolver());
                }
                String baseTypeName = baseType.getLocalPart();
                if (prefix != null) {
                    baseTypeName = prefix + ":" + baseTypeName;
                }
                if (this.helper.isAnnotationPresent(valueField.getElement(), XmlList.class) || this.isCollectionType(valueField)) {
                    List list = new List();
                    list.setItemType(baseTypeName);
                    ((SimpleType)type).setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                        baseType = new QName(schemaType.namespace(), schemaType.name());
                    }
                    restriction.setBaseType(baseTypeName);
                    ((SimpleType)type).setRestriction(restriction);
                }
            }
            info.setSimpleType((SimpleType)type);
        } else {
            valueField = this.getXmlValueFieldForSimpleContent(info.getPropertyList());
            if (valueField != null) {
                type = new ComplexType();
                SimpleContent content = new SimpleContent();
                if (typeName.equals("")) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                } else {
                    ((ComplexType)type).setName(typeName);
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    if (rootElement != null) {
                        rootElement.setType(pfx + ((ComplexType)type).getName());
                    }
                }
                QName extensionType = this.getSchemaTypeFor(valueField.getType());
                if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                    extensionType = new QName(schemaType.namespace(), schemaType.name());
                }
                String prefix = null;
                if (extensionType.getNamespaceURI() != null && !extensionType.getNamespaceURI().equals("")) {
                    prefix = extensionType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(extensionType.getNamespaceURI(), schema.getNamespaceResolver());
                }
                String extensionTypeName = extensionType.getLocalPart();
                if (prefix != null) {
                    extensionTypeName = prefix + ":" + extensionTypeName;
                }
                Extension extension = new Extension();
                extension.setBaseType(extensionTypeName);
                content.setExtension(extension);
                ((ComplexType)type).setSimpleContent(content);
                info.setComplexType((ComplexType)type);
            } else {
                TypeInfo parentTypeInfo;
                type = new ComplexType();
                JavaClass superClass = this.helper.getNextMappedSuperClass(myClass);
                if (info.isMixed()) {
                    ((ComplexType)type).setMixed(true);
                }
                if (myClass.isAbstract()) {
                    ((ComplexType)type).setAbstractValue(true);
                }
                Extension extension = null;
                if (superClass != null && (parentTypeInfo = this.typeInfo.get(superClass.getQualifiedName())) != null) {
                    extension = new Extension();
                    String parentPrefix = this.getPrefixForNamespace(parentTypeInfo.getClassNamespace(), schema.getNamespaceResolver());
                    if (parentPrefix != null) {
                        extension.setBaseType(parentPrefix + ":" + parentTypeInfo.getSchemaTypeName());
                    } else {
                        extension.setBaseType(parentTypeInfo.getSchemaTypeName());
                    }
                    ComplexContent content = new ComplexContent();
                    content.setExtension(extension);
                    ((ComplexType)type).setComplexContent(content);
                }
                TypeDefParticle compositor = null;
                String[] propOrder = info.getPropOrder();
                if (propOrder.length == 0) {
                    if (info.hasElementRefs()) {
                        compositor = new Sequence();
                        if (extension != null) {
                            extension.setSequence((Sequence)compositor);
                        } else {
                            ((ComplexType)type).setSequence((Sequence)compositor);
                        }
                    } else if (extension != null) {
                        compositor = new All();
                        extension.setAll((All)compositor);
                    } else {
                        compositor = new All();
                        ((ComplexType)type).setAll((All)compositor);
                    }
                } else {
                    compositor = new Sequence();
                    if (extension != null) {
                        extension.setSequence((Sequence)compositor);
                    } else {
                        ((ComplexType)type).setSequence((Sequence)compositor);
                    }
                }
                if (typeName.equals("")) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                    info.setCompositor(compositor);
                } else {
                    ((ComplexType)type).setName(typeName);
                    if (rootElement != null) {
                        rootElement.setType(pfx + ((ComplexType)type).getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    info.setComplexType((ComplexType)type);
                    info.setCompositor(compositor);
                }
            }
        }
    }

    public void addToSchemaType(TypeInfo ownerTypeInfo, java.util.List<Property> properties, TypeDefParticle compositor, ComplexType type, Schema schema) {
        for (Property next : properties) {
            JavaClass gType;
            String prefix;
            JavaClass javaType;
            if (next == null) continue;
            TypeDefParticle parentCompositor = compositor;
            boolean isChoice = parentCompositor instanceof Choice;
            ComplexType parentType = type;
            if (this.helper.isAnnotationPresent(next.getElement(), XmlTransient.class)) continue;
            if (!isChoice && this.helper.isAnnotationPresent(next.getElement(), XmlElementWrapper.class)) {
                XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(next.getElement(), XmlElementWrapper.class);
                Element wrapperElement = new Element();
                String name = wrapper.name();
                if (name.equals("##default")) {
                    name = next.getPropertyName();
                }
                wrapperElement.setNillable(wrapper.nillable());
                String wrapperNS = wrapper.namespace();
                if (!wrapperNS.equals("##default") && !wrapperNS.equals(schema.getTargetNamespace())) {
                    wrapperElement.setMinOccurs("1");
                    wrapperElement.setMaxOccurs("1");
                    String prefix2 = this.getPrefixForNamespace(wrapperNS, schema.getNamespaceResolver());
                    if (prefix2 == null) {
                        prefix2 = schema.getNamespaceResolver().generatePrefix();
                        schema.getNamespaceResolver().put(prefix2, wrapperNS);
                    }
                    wrapperElement.setRef(prefix2 + ":" + name);
                    compositor.addElement(wrapperElement);
                    continue;
                }
                wrapperElement.setName(name);
                wrapperElement.setMinOccurs("0");
                compositor.addElement(wrapperElement);
                ComplexType wrapperType = new ComplexType();
                Sequence wrapperSequence = new Sequence();
                wrapperType.setSequence(wrapperSequence);
                wrapperElement.setComplexType(wrapperType);
                parentType = wrapperType;
                parentCompositor = wrapperSequence;
            }
            if (this.helper.isAnnotationPresent(next.getElement(), XmlAttribute.class)) {
                Attribute attribute = new Attribute();
                QName attributeName = next.getSchemaName();
                attribute.setName(attributeName.getLocalPart());
                if (next.isRequired()) {
                    attribute.setUse("required");
                }
                javaType = next.getType();
                if (next.getGenericType() != null) {
                    javaType = next.getGenericType();
                }
                String typeName = null;
                TypeInfo info = this.typeInfo.get(next.getType().getQualifiedName());
                if (info != null) {
                    if (!info.isComplexType()) {
                        typeName = info.getSimpleType().getName();
                    }
                } else if (this.helper.isAnnotationPresent(next.getElement(), XmlID.class)) {
                    typeName = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(next.getElement(), XmlIDREF.class)) {
                    typeName = "xsd:IDREF";
                } else {
                    QName schemaType = next.getSchemaType();
                    if (schemaType == null) {
                        schemaType = this.getSchemaTypeFor(javaType);
                    }
                    typeName = schemaType != null ? "xsd:" + schemaType.getLocalPart() : "xsd:anySimpleType";
                }
                if (this.isCollectionType(next)) {
                    SimpleType localType = new SimpleType();
                    List list = new List();
                    list.setItemType(typeName);
                    localType.setList(list);
                    attribute.setSimpleType(localType);
                } else {
                    String prefix3;
                    if (typeName != null && !typeName.contains(":") && info.getSchema() == schema && (prefix3 = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                        typeName = prefix3 + ":" + typeName;
                    }
                    attribute.setType(typeName);
                }
                String lookupNamespace = schema.getTargetNamespace();
                if (lookupNamespace == null) {
                    lookupNamespace = "";
                }
                NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
                boolean isAttributeFormQualified = true;
                if (namespaceInfo != null) {
                    isAttributeFormQualified = namespaceInfo.isAttributeFormQualified();
                }
                if (isAttributeFormQualified && !attributeName.getNamespaceURI().equals(lookupNamespace) || !namespaceInfo.isAttributeFormQualified() && !attributeName.getNamespaceURI().equals("")) {
                    Schema attributeSchema = this.getSchemaForNamespace(attributeName.getNamespaceURI());
                    if (attributeSchema != null && attributeSchema.getTopLevelAttributes().get(attribute.getName()) == null) {
                        attributeSchema.getTopLevelAttributes().put(attribute.getName(), attribute);
                    }
                    this.addImportIfRequired(schema, attributeSchema, attributeName.getNamespaceURI());
                    Attribute reference = new Attribute();
                    String prefix4 = this.getPrefixForNamespace(attributeName.getNamespaceURI(), schema.getNamespaceResolver());
                    if (prefix4 == null) {
                        reference.setRef(attribute.getName());
                    } else {
                        reference.setRef(prefix4 + ":" + attribute.getName());
                    }
                    if (parentType.getSimpleContent() != null) {
                        parentType.getSimpleContent().getExtension().getOrderedAttributes().add(reference);
                        continue;
                    }
                    parentType.getOrderedAttributes().add(reference);
                    continue;
                }
                if (parentType.getSimpleContent() != null) {
                    parentType.getSimpleContent().getExtension().getOrderedAttributes().add(attribute);
                    continue;
                }
                if (parentType.getComplexContent() != null) {
                    parentType.getComplexContent().getExtension().getOrderedAttributes().add(attribute);
                    continue;
                }
                parentType.getOrderedAttributes().add(attribute);
                continue;
            }
            if (this.helper.isAnnotationPresent(next.getElement(), XmlAnyAttribute.class)) {
                AnyAttribute anyAttribute = new AnyAttribute();
                anyAttribute.setProcessContents("lax");
                if (type.getSimpleContent() != null) {
                    SimpleContent content = type.getSimpleContent();
                    content.getRestriction().setAnyAttribute(anyAttribute);
                    continue;
                }
                type.setAnyAttribute(anyAttribute);
                continue;
            }
            if (next.isChoice()) {
                Choice choice = new Choice();
                ArrayList choiceProperties = (ArrayList)((ChoiceProperty)next).getChoiceProperties();
                this.addToSchemaType(ownerTypeInfo, choiceProperties, choice, parentType, schema);
                if (this.isCollectionType(next)) {
                    choice.setMaxOccurs("unbounded");
                }
                if (parentCompositor instanceof Sequence) {
                    ((Sequence)parentCompositor).addChoice(choice);
                    continue;
                }
                if (!(parentCompositor instanceof Choice)) continue;
                ((Choice)parentCompositor).addChoice(choice);
                continue;
            }
            if (next.isAny()) {
                Any any = new Any();
                any.setNamespace("##other");
                AnyProperty anyProp = (AnyProperty)next;
                if (anyProp.isLax()) {
                    any.setProcessContents("lax");
                } else {
                    any.setProcessContents("skip");
                }
                if (parentCompositor instanceof Sequence) {
                    ((Sequence)parentCompositor).addAny(any);
                    continue;
                }
                if (!(parentCompositor instanceof Choice)) continue;
                ((Choice)parentCompositor).addAny(any);
                continue;
            }
            if (next.isReference()) {
                ReferenceProperty refProp = (ReferenceProperty)next;
                java.util.List<ElementDeclaration> referencedElements = refProp.getReferencedElements();
                if (referencedElements.size() == 1) {
                    Element element = new Element();
                    ElementDeclaration decl = referencedElements.get(0);
                    String localName = decl.getElementName().getLocalPart();
                    Schema referencedSchema = this.getSchemaForNamespace(decl.getElementName().getNamespaceURI());
                    this.addImportIfRequired(schema, referencedSchema, decl.getElementName().getNamespaceURI());
                    String prefix5 = this.getPrefixForNamespace(decl.getElementName().getNamespaceURI(), schema.getNamespaceResolver());
                    if (prefix5 == null || prefix5.equals("")) {
                        element.setRef(localName);
                    } else {
                        element.setRef(prefix5 + ":" + localName);
                    }
                    if (this.isCollectionType(next)) {
                        element.setMinOccurs("0");
                        element.setMaxOccurs("unbounded");
                    }
                    parentCompositor.addElement(element);
                    continue;
                }
                Choice choice = new Choice();
                if (this.isCollectionType(next)) {
                    choice.setMaxOccurs("unbounded");
                }
                for (ElementDeclaration elementDecl : referencedElements) {
                    Element element = new Element();
                    String localName = elementDecl.getElementName().getLocalPart();
                    Schema referencedSchema = this.getSchemaForNamespace(elementDecl.getElementName().getNamespaceURI());
                    this.addImportIfRequired(schema, referencedSchema, elementDecl.getElementName().getNamespaceURI());
                    prefix = this.getPrefixForNamespace(elementDecl.getElementName().getNamespaceURI(), schema.getNamespaceResolver());
                    if (prefix == null || prefix.equals("")) {
                        element.setRef(localName);
                    } else {
                        element.setRef(prefix + ":" + localName);
                    }
                    choice.addElement(element);
                }
                if (parentCompositor instanceof Sequence) {
                    ((Sequence)parentCompositor).addChoice(choice);
                    continue;
                }
                if (!(parentCompositor instanceof Choice)) continue;
                ((Choice)parentCompositor).addChoice(choice);
                continue;
            }
            if (this.helper.isAnnotationPresent(next.getElement(), XmlValue.class)) continue;
            Element element = new Element();
            if (!(parentCompositor instanceof All)) {
                element.setMinOccurs(next.isRequired() ? "1" : "0");
            }
            element.setNillable(next.isNillable());
            if (next.isSetDefaultValue()) {
                element.setDefaultValue(next.getDefaultValue());
            }
            QName elementName = next.getSchemaName();
            javaType = next.getType();
            boolean isCollectionType = this.isCollectionType(next);
            boolean isMapType = this.isMapType(next);
            if (isCollectionType && (gType = next.getGenericType()) != null && javaType.hasActualTypeArguments()) {
                Object[] params = javaType.getActualTypeArguments().toArray();
                javaType = (JavaClass)params[0];
            }
            element.setName(elementName.getLocalPart());
            TypeInfo info = this.typeInfo.get(javaType.getQualifiedName());
            String typeName = null;
            boolean isComplexType = false;
            if (info != null) {
                if (this.helper.isAnnotationPresent(next.getElement(), XmlID.class)) {
                    typeName = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(next.getElement(), XmlIDREF.class)) {
                    typeName = "xsd:IDREF";
                } else {
                    isComplexType = info.isComplexType();
                    typeName = info.isComplexType() ? info.getComplexType().getName() : (info.getSimpleType() != null ? info.getSimpleType().getName() : info.getSchemaTypeName());
                }
                if (typeName == null && !info.hasRootElement()) {
                    if (info.isComplexType()) {
                        element.setComplexType(info.getComplexType());
                    } else {
                        element.setSimpleType(info.getSimpleType());
                    }
                }
                if (this.addImportIfRequired(schema, info.getSchema(), info.getClassNamespace()) && (prefix = schema.getNamespaceResolver().resolveNamespaceURI(info.getClassNamespace())) != null && !typeName.equals("")) {
                    typeName = prefix + ":" + typeName;
                }
            } else if (this.helper.isAnnotationPresent(next.getElement(), XmlID.class)) {
                typeName = "xsd:ID";
            } else if (!isMapType) {
                QName schemaType = next.getSchemaType();
                if (schemaType == null) {
                    schemaType = this.getSchemaTypeFor(javaType);
                }
                if (schemaType != null) {
                    typeName = "xsd:" + schemaType.getLocalPart();
                }
            }
            if (typeName != null && !typeName.contains(":") && info.getSchema() == schema && (prefix = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                typeName = prefix + ":" + typeName;
            }
            if (isCollectionType) {
                if (this.helper.isAnnotationPresent(next.getElement(), XmlList.class)) {
                    if (isComplexType) {
                        // empty if block
                    }
                    SimpleType localSimpleType = new SimpleType();
                    List list = new List();
                    list.setItemType(typeName);
                    localSimpleType.setList(list);
                    element.setSimpleType(localSimpleType);
                } else {
                    element.setMaxOccurs("unbounded");
                    element.setType(typeName);
                }
            } else if (isMapType) {
                QName keySchemaType;
                ComplexType entryComplexType = new ComplexType();
                Sequence entrySequence = new Sequence();
                Element keyElement = new Element();
                keyElement.setName("key");
                keyElement.setMinOccurs("0");
                JavaClass gType2 = next.getGenericType();
                JavaClass keyType = javaType;
                JavaClass valueType = javaType;
                if (gType2 != null && javaType.hasActualTypeArguments()) {
                    Object[] params = javaType.getActualTypeArguments().toArray();
                    keyType = (JavaClass)params[0];
                    valueType = (JavaClass)params[1];
                }
                if ((keySchemaType = this.getSchemaTypeFor(keyType)) != null) {
                    String prefix6 = keySchemaType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(keySchemaType.getNamespaceURI(), schema.getNamespaceResolver());
                    typeName = prefix6 != null && !prefix6.equals("") ? prefix6 + ":" + keySchemaType.getLocalPart() : keySchemaType.getLocalPart();
                    keyElement.setType(typeName);
                    TypeInfo targetInfo = this.typeInfo.get(keyType.getQualifiedName());
                    if (targetInfo != null) {
                        Schema keyElementSchema = this.getSchemaForNamespace(keySchemaType.getNamespaceURI());
                        this.addImportIfRequired(schema, keyElementSchema, keySchemaType.getNamespaceURI());
                    }
                }
                entrySequence.addElement(keyElement);
                Element valueElement = new Element();
                valueElement.setName("value");
                valueElement.setMinOccurs("0");
                QName valueSchemaType = this.getSchemaTypeFor(valueType);
                if (valueSchemaType != null) {
                    String prefix7 = valueSchemaType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(valueSchemaType.getNamespaceURI(), schema.getNamespaceResolver());
                    typeName = prefix7 != null && !prefix7.equals("") ? prefix7 + ":" + valueSchemaType.getLocalPart() : valueSchemaType.getLocalPart();
                    valueElement.setType(typeName);
                    TypeInfo targetInfo = this.typeInfo.get(valueType.getQualifiedName());
                    if (targetInfo != null) {
                        Schema valueElementSchema = this.getSchemaForNamespace(valueSchemaType.getNamespaceURI());
                        this.addImportIfRequired(schema, valueElementSchema, valueSchemaType.getNamespaceURI());
                    }
                }
                entrySequence.addElement(valueElement);
                entryComplexType.setSequence(entrySequence);
                JavaClass descriptorClass = this.helper.getJavaClass(ownerTypeInfo.getDescriptor().getJavaClassName());
                JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
                if (mapValueClass.isAssignableFrom(descriptorClass)) {
                    element.setComplexType(entryComplexType);
                    element.setMaxOccurs("unbounded");
                } else {
                    ComplexType complexType = new ComplexType();
                    Sequence sequence = new Sequence();
                    complexType.setSequence(sequence);
                    Element entryElement = new Element();
                    entryElement.setName("entry");
                    entryElement.setMinOccurs("0");
                    entryElement.setMaxOccurs("unbounded");
                    sequence.addElement(entryElement);
                    entryElement.setComplexType(entryComplexType);
                    element.setComplexType(complexType);
                }
            } else {
                element.setType(typeName);
            }
            String lookupNamespace = schema.getTargetNamespace();
            if (lookupNamespace == null) {
                lookupNamespace = "";
            }
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
            boolean isElementFormQualified = false;
            if (namespaceInfo != null) {
                isElementFormQualified = namespaceInfo.isElementFormQualified();
            }
            if (isElementFormQualified && !elementName.getNamespaceURI().equals(lookupNamespace) || !isElementFormQualified && !elementName.getNamespaceURI().equals("")) {
                Element reference = new Element();
                reference.setMinOccurs(element.getMinOccurs());
                reference.setMaxOccurs(element.getMaxOccurs());
                Schema attributeSchema = this.getSchemaForNamespace(elementName.getNamespaceURI());
                if (attributeSchema != null && attributeSchema.getTopLevelElements().get(element.getName()) == null) {
                    element.setMinOccurs(null);
                    element.setMaxOccurs(null);
                    attributeSchema.getTopLevelElements().put(element.getName(), element);
                }
                this.addImportIfRequired(schema, attributeSchema, elementName.getNamespaceURI());
                String prefix8 = this.getPrefixForNamespace(elementName.getNamespaceURI(), schema.getNamespaceResolver());
                if (prefix8 == null) {
                    reference.setRef(element.getName());
                } else {
                    reference.setRef(prefix8 + ":" + element.getName());
                }
                parentCompositor.addElement(reference);
                continue;
            }
            parentCompositor.addElement(element);
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        TypeInfo targetInfo;
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (schemaType == null && (targetInfo = this.typeInfo.get(javaClass.getQualifiedName())) != null) {
            schemaType = new QName(targetInfo.getClassNamespace(), targetInfo.getSchemaTypeName());
        }
        if (schemaType == null) {
            if (javaClass.getQualifiedName().equals("java.lang.Object")) {
                return XMLConstants.ANY_TYPE_QNAME;
            }
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public void populateSchemaTypes() {
        for (String javaClassName : this.typeInfo.keySet()) {
            TypeInfo info = this.typeInfo.get(javaClassName);
            if (!info.isComplexType() || info.getSchema() == null) continue;
            this.addToSchemaType(info, info.getNonTransientPropertiesInPropOrder(), info.getCompositor(), info.getComplexType(), info.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public ArrayList<String> getEnumerationFacetsFor(EnumTypeInfo info) {
        return (ArrayList)info.getFieldValues();
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlAnyAttribute.class)) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type) || type.isArray();
    }

    public boolean isMapType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Map.class).isAssignableFrom(type);
    }

    private Schema getSchemaForNamespace(String namespace) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        if ((schema = this.schemaForNamespace.get(namespace)) == null) {
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(namespace);
            schema = new Schema();
            schema.setName("schema" + this.schemaCount + ".xsd");
            if (namespaceInfo != null) {
                if (namespaceInfo.getLocation() != null) {
                    return null;
                }
                Vector namespaces = namespaceInfo.getNamespaceResolver().getNamespaces();
                for (int i = 0; i < namespaces.size(); ++i) {
                    Namespace nextNamespace = (Namespace)namespaces.get(i);
                    schema.getNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                }
            }
            ++this.schemaCount;
            if (!namespace.equals("")) {
                schema.setTargetNamespace(namespace);
                String prefix = null;
                if (namespaceInfo != null) {
                    prefix = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(namespace);
                }
                if (prefix == null) {
                    prefix = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put(prefix, namespace);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(namespace, schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        return this.schemaForNamespace.values();
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String namespace) {
        Collection<NamespaceInfo> namespaceInfo = this.packageToNamespaceMappings.values();
        for (NamespaceInfo info : namespaceInfo) {
            if (!info.getNamespace().equals(namespace)) continue;
            return info;
        }
        return null;
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver) {
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        return null;
    }

    public void addGlobalElements(HashMap<QName, ElementDeclaration> additionalElements) {
        QName next;
        String namespaceURI;
        Schema targetSchema;
        Iterator<QName> i$ = additionalElements.keySet().iterator();
        while (i$.hasNext() && (targetSchema = this.getSchemaForNamespace(namespaceURI = (next = i$.next()).getNamespaceURI())) != null) {
            if (targetSchema.getTopLevelElements().get(next.getLocalPart()) != null) continue;
            Element element = new Element();
            element.setName(next.getLocalPart());
            ElementDeclaration nextElement = additionalElements.get(next);
            JavaClass javaClass = nextElement.getJavaType();
            QName schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (schemaType != null) {
                element.setType("xsd:" + schemaType.getLocalPart());
            } else {
                TypeInfo type = this.typeInfo.get(javaClass.getQualifiedName());
                if (type != null) {
                    String typeName = null;
                    typeName = type.isComplexType() ? type.getComplexType().getName() : type.getSimpleType().getName();
                    if (type.getClassNamespace().equals(namespaceURI)) {
                        element.setType(typeName);
                    } else {
                        Schema complexTypeSchema = this.getSchemaForNamespace(type.getClassNamespace());
                        String complexTypeSchemaNS = type.getClassNamespace();
                        if (complexTypeSchemaNS == null) {
                            complexTypeSchemaNS = "";
                        }
                        this.addImportIfRequired(targetSchema, complexTypeSchema, type.getClassNamespace());
                        String prefix = targetSchema.getNamespaceResolver().resolveNamespaceURI(complexTypeSchemaNS);
                        if (prefix != null) {
                            element.setType(prefix + ":" + typeName);
                        } else {
                            element.setType(typeName);
                        }
                    }
                }
            }
            if (nextElement.getSubstitutionHead() != null) {
                String subLocal = nextElement.getSubstitutionHead().getLocalPart();
                String subNamespace = nextElement.getSubstitutionHead().getNamespaceURI();
                String prefix = this.getPrefixForNamespace(subNamespace, targetSchema.getNamespaceResolver());
                if (prefix == null || prefix.equals("")) {
                    element.setSubstitutionGroup(subLocal);
                } else {
                    element.setSubstitutionGroup(prefix + ":" + subLocal);
                }
            }
            targetSchema.addTopLevelElement(element);
            SchemaTypeInfo info = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (info == null) {
                info = new SchemaTypeInfo();
                info.setSchemaTypeName(schemaType);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), info);
            }
            info.getGlobalElementDeclarations().add(next);
        }
    }

    public HashMap<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String schemaName) {
        java.util.List imports = schema.getImports();
        for (int i = 0; i < imports.size(); ++i) {
            Import nextImport = (Import)imports.get(i);
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }

    private boolean addImportIfRequired(Schema sourceSchema, Schema importSchema, String importNamespace) {
        if (importSchema != sourceSchema) {
            String schemaName = null;
            if (importSchema != null) {
                schemaName = importSchema.getName();
            } else if (importNamespace != null) {
                NamespaceInfo nInfo = this.getNamespaceInfoForNamespace(importNamespace);
                schemaName = nInfo.getLocation();
            }
            if (schemaName != null && !this.importExists(sourceSchema, schemaName)) {
                String prefix;
                Import schemaImport = new Import();
                schemaImport.setSchemaLocation(schemaName);
                if (importNamespace != null && !importNamespace.equals("")) {
                    schemaImport.setNamespace(importNamespace);
                }
                sourceSchema.getImports().add(schemaImport);
                if (schemaImport.getNamespace() != null && (prefix = sourceSchema.getNamespaceResolver().resolveNamespaceURI(importNamespace)) == null && !importNamespace.equals("")) {
                    sourceSchema.getNamespaceResolver().put(sourceSchema.getNamespaceResolver().generatePrefix(), importNamespace);
                }
                return true;
            }
        }
        return false;
    }
}

