/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLDirectMapping
extends AbstractDirectMapping
implements XMLMapping,
XMLNillableMapping {
    protected static final String EMPTY_STRING = "";
    AbstractNullPolicy nullPolicy = new NullPolicy();
    public boolean isCDATA = false;
    private boolean isWriteOnly;
    private boolean isWhitespacePreserved = false;

    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public boolean isXMLMapping() {
        return true;
    }

    public void setXPath(String xpathString) {
        if (xpathString.indexOf("@") == -1 && !xpathString.endsWith("text()")) {
            xpathString = xpathString + "/text()";
        }
        this.setField(new XMLField(xpathString));
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    public Object getAttributeValue(Object fieldValue, AbstractSession session, XMLRecord record) {
        Object attributeValue;
        if (EMPTY_STRING.equals(fieldValue)) {
            fieldValue = null;
        }
        if ((attributeValue = fieldValue) == XMLRecord.noEntry) {
            if (!this.getNullPolicy().getIsSetPerformedForAbsentNode()) {
                return attributeValue;
            }
            fieldValue = null;
            attributeValue = null;
        }
        if (this.hasConverter()) {
            attributeValue = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(attributeValue, session, record.getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(attributeValue, session);
        } else if (attributeValue == null || attributeValue.getClass() != this.attributeObjectClassification) {
            try {
                attributeValue = session.getDatasourcePlatform().convertObject(attributeValue, this.attributeClassification);
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
        }
        if (attributeValue == null) {
            attributeValue = this.nullValue;
        }
        return attributeValue;
    }

    public Object getFieldValue(Object attributeValue, AbstractSession session, XMLRecord record) {
        Object fieldValue = attributeValue;
        if (this.nullValue != null && this.nullValue.equals(fieldValue)) {
            return null;
        }
        if (this.hasConverter()) {
            fieldValue = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(fieldValue, session, record.getMarshaller()) : this.getConverter().convertObjectValueToDataValue(fieldValue, session);
        }
        Class fieldClassification = this.getFieldClassification(this.getField());
        if (fieldValue != null && fieldClassification != fieldValue.getClass()) {
            try {
                fieldValue = session.getPlatform(this.descriptor.getJavaClass()).convertObject(fieldValue, fieldClassification);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
        }
        return fieldValue;
    }

    public String getXPath() {
        return this.getFieldName();
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        return this.getAttributeValue(row.getIndicatingNoEntry(this.field), executionSession, (XMLRecord)row);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeSingleValue(this.getAttributeValueFromObject(object), object, (XMLRecord)row, session);
    }

    protected void writeValueIntoRow(AbstractRecord row, DatabaseField aField, Object fieldValue) {
        row.put(this.getField(), fieldValue);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        Object fieldValue = this.getFieldValue(value, session, row);
        this.writeValueIntoRow(row, this.getField(), fieldValue);
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        try {
            if (value == XMLRecord.noEntry) {
                return;
            }
            this.attributeAccessor.setAttributeValueInObject(object, value);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public boolean isWhitespacePreserved() {
        return this.isWhitespacePreserved;
    }

    public void setWhitespacePreserved(boolean isWhitespacePreserved) {
        this.isWhitespacePreserved = isWhitespacePreserved;
    }
}

