/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.DefaultSchemaResolver;
import org.eclipse.persistence.sdo.helper.SDOSchemaGenerator;
import org.eclipse.persistence.sdo.helper.SDOTypesGenerator;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaLocationResolver;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.w3c.dom.Element;

public class SDOXSDHelperDelegate
implements SDOXSDHelper {
    private Map globalAttributes;
    private Map globalElements;
    private HelperContext aHelperContext;

    public SDOXSDHelperDelegate(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.globalAttributes = new HashMap();
        this.initOpenProps();
        this.globalElements = new HashMap();
    }

    public String getLocalName(Type type) {
        if (type == null) {
            return null;
        }
        return ((SDOType)type).getXsdLocalName();
    }

    public String getLocalName(Property property) {
        if (property == null) {
            return null;
        }
        return ((SDOProperty)property).getXsdLocalName();
    }

    public String getNamespaceURI(Type type) {
        if (type == null) {
            return null;
        }
        return type.getURI();
    }

    public String getNamespaceURI(Property property) {
        if (property == null) {
            return null;
        }
        String uri = null;
        if (property.isOpenContent()) {
            uri = ((SDOProperty)property).getUri();
        } else {
            XMLField xmlField;
            DatabaseMapping mapping = ((SDOProperty)property).getXmlMapping();
            if (mapping != null && (xmlField = (XMLField)mapping.getField()) != null && xmlField.getXPathFragment() != null) {
                uri = xmlField.getXPathFragment().getNamespaceURI();
            }
        }
        return uri == null ? "" : uri;
    }

    public boolean isAttribute(Property property) {
        boolean isElement;
        if (property == null) {
            return false;
        }
        Object value = property.get((Property)SDOConstants.XMLELEMENT_PROPERTY);
        if (value != null && value instanceof Boolean && (isElement = ((Boolean)value).booleanValue())) {
            return false;
        }
        if (property.getOpposite() != null && property.getOpposite().isContainment()) {
            return false;
        }
        return !property.isMany() && !property.isContainment() && !property.isNullable();
    }

    public boolean isElement(Property property) {
        if (property == null) {
            return false;
        }
        Object value = property.get((Property)SDOConstants.XMLELEMENT_PROPERTY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        if (property.getOpposite() != null && property.getOpposite().isContainment()) {
            return false;
        }
        return property.isMany() || property.isContainment() || property.isNullable();
    }

    public boolean isMixed(Type type) {
        if (type == null) {
            return false;
        }
        return type.isSequenced();
    }

    public boolean isXSD(Type type) {
        if (type == null) {
            return false;
        }
        return ((SDOType)type).isXsd();
    }

    public Property getGlobalProperty(String uri, String propertyName, boolean isElement) {
        QName qname = new QName(uri, propertyName);
        return this.getGlobalProperty(qname, isElement);
    }

    public Property getGlobalProperty(QName qname, boolean isElement) {
        if (isElement) {
            return (Property)this.getGlobalElements().get(qname);
        }
        return (Property)this.getGlobalAttributes().get(qname);
    }

    public String getAppinfo(Type type, String source) {
        if (type == null) {
            throw SDOException.noAppInfoForNull();
        }
        if (source == null) {
            source = "";
        }
        return (String)((SDOType)type).getAppInfoMap().get(source);
    }

    public String getAppinfo(Property property, String source) {
        if (property == null) {
            throw SDOException.noAppInfoForNull();
        }
        if (source == null) {
            source = "";
        }
        return (String)((SDOProperty)property).getAppInfoMap().get(source);
    }

    public synchronized List define(String xsd) {
        StringReader reader = new StringReader(xsd);
        DefaultSchemaResolver schemaResolver = new DefaultSchemaResolver();
        return this.define((Reader)reader, (SchemaResolver)schemaResolver);
    }

    public synchronized List define(Reader xsdReader, String schemaLocation) {
        DefaultSchemaResolver schemaResolver = new DefaultSchemaResolver();
        schemaResolver.setBaseSchemaLocation(schemaLocation);
        return this.define(new StreamSource(xsdReader), (SchemaResolver)schemaResolver);
    }

    public synchronized List define(Reader xsdReader, SchemaResolver schemaResolver) {
        return this.define(new StreamSource(xsdReader), schemaResolver);
    }

    public synchronized List define(Source xsdSource, SchemaResolver schemaResolver) {
        return new SDOTypesGenerator(this.aHelperContext).define(xsdSource, schemaResolver);
    }

    public synchronized List define(InputStream xsdInputStream, String schemaLocation) {
        InputStreamReader xsdReader = new InputStreamReader(xsdInputStream);
        return this.define((Reader)xsdReader, schemaLocation);
    }

    public String generate(List types) {
        Map map = null;
        return this.generate(types, map);
    }

    public String generate(List types, Map namespaceToSchemaLocation) {
        return new SDOSchemaGenerator(this.aHelperContext).generate(types, namespaceToSchemaLocation);
    }

    public String generate(List types, SchemaLocationResolver schemaLocationResolver) {
        return new SDOSchemaGenerator(this.aHelperContext).generate(types, schemaLocationResolver);
    }

    public void setGlobalAttributes(Map globalAttributes) {
        this.globalAttributes = globalAttributes;
    }

    private Map getGlobalAttributes() {
        return this.globalAttributes;
    }

    private void initOpenProps() {
        this.getGlobalAttributes().put(SDOConstants.MIME_TYPE_QNAME, SDOConstants.MIME_TYPE_PROPERTY);
        this.getGlobalAttributes().put(SDOConstants.MIME_TYPE_PROPERTY_QNAME, SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        Property xmlSchemaTypeProperty = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo", "xmlSchemaType");
        this.getGlobalAttributes().put(SDOConstants.SCHEMA_TYPE_QNAME, xmlSchemaTypeProperty);
        this.getGlobalAttributes().put(SDOConstants.JAVA_CLASS_QNAME, SDOConstants.JAVA_CLASS_PROPERTY);
        this.getGlobalAttributes().put(SDOConstants.XML_ELEMENT_QNAME, SDOConstants.XMLELEMENT_PROPERTY);
        Property xmlDataTypeProperty = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "dataType");
        this.getGlobalAttributes().put(SDOConstants.XML_DATATYPE_QNAME, xmlDataTypeProperty);
        this.getGlobalAttributes().put(SDOConstants.XML_ID_PROPERTY_QNAME, SDOConstants.ID_PROPERTY);
        this.getGlobalAttributes().put(SDOConstants.DOCUMENTATION_PROPERTY_QNAME, SDOConstants.DOCUMENTATION_PROPERTY);
    }

    public void setGlobalElements(Map globalElements) {
        this.globalElements = globalElements;
    }

    private Map getGlobalElements() {
        return this.globalElements;
    }

    public Map buildAppInfoMap(List appInfoElements) {
        HashMap<String, String> appInfoMap = new HashMap<String, String>();
        if (appInfoElements != null) {
            for (int i = 0; i < appInfoElements.size(); ++i) {
                Element nextElement = (Element)appInfoElements.get(i);
                if (!nextElement.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || !nextElement.getLocalName().equals("appinfo")) continue;
                String key = nextElement.getAttribute("source");
                String value = (String)appInfoMap.get(key);
                StringWriter sw = new StringWriter();
                WriterRecord wrec = new WriterRecord();
                wrec.setWriter(sw);
                wrec.node(nextElement, new NamespaceResolver());
                appInfoMap.put(key, value == null ? sw.toString() : value + sw.toString());
            }
        }
        return appInfoMap;
    }

    public void reset() {
        this.globalAttributes = new HashMap();
        this.initOpenProps();
        this.globalElements = new HashMap();
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public String getStringFromAppInfoElement(Element appInfo) {
        FormattedWriterRecord record = new FormattedWriterRecord();
        record.setWriter(new StringWriter());
        record.node(appInfo, new NamespaceResolver());
        return record.getWriter().toString();
    }

    public void addGlobalProperty(QName qname, Property prop, boolean isElement) {
        ((SDOProperty)prop).setUri(qname.getNamespaceURI());
        if (isElement) {
            this.getGlobalElements().put(qname, prop);
        } else {
            this.getGlobalAttributes().put(qname, prop);
        }
    }
}

