/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.ExclusiveIsolatedClientSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.Server;

public class ServerSession
extends DatabaseSessionImpl
implements Server {
    protected ConnectionPool readConnectionPool;
    protected Map connectionPools = new HashMap(10);
    protected ConnectionPolicy defaultConnectionPolicy;
    protected int maxNumberOfNonPooledConnections;
    public static final int NO_MAX = -1;
    protected int numberOfNonPooledConnectionsUsed;

    public ServerSession() {
    }

    public ServerSession(Login login) {
        this(new Project(login));
    }

    public ServerSession(Login login, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(new Project(login), minNumberOfPooledConnection, maxNumberOfPooledConnection);
    }

    public ServerSession(Login login, ConnectionPolicy defaultConnectionPolicy) {
        this(new Project(login), defaultConnectionPolicy);
    }

    public ServerSession(Project project) {
        this(project, 32, 32);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(project, 1, minNumberOfPooledConnection, maxNumberOfPooledConnection);
    }

    public ServerSession(Project project, int initialNumberOfPooledConnection, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(project, new ConnectionPolicy("default"), 1, minNumberOfPooledConnection, maxNumberOfPooledConnection, null, null);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection, Login readLogin) {
        this(project, minNumberOfPooledConnection, maxNumberOfPooledConnection, readLogin, null);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection, Login readLogin, Login sequenceLogin) {
        this(project, new ConnectionPolicy("default"), 1, minNumberOfPooledConnection, maxNumberOfPooledConnection, readLogin, sequenceLogin);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, int initialNumberOfPooledConnections, int minNumberOfPooledConnections, int maxNumberOfPooledConnections, Login readLogin, Login sequenceLogin) {
        super(project);
        this.defaultConnectionPolicy = defaultConnectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        ConnectionPool pool = null;
        pool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), initialNumberOfPooledConnections, minNumberOfPooledConnections, maxNumberOfPooledConnections, this);
        this.connectionPools.put("default", pool);
        if (readLogin != null) {
            this.setReadConnectionPool(readLogin);
        } else {
            this.setReadConnectionPool(pool);
        }
        if (sequenceLogin != null) {
            this.getSequencingControl().setShouldUseSeparateConnection(true);
            this.getSequencingControl().setLogin(sequenceLogin);
        }
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy) {
        this(project, defaultConnectionPolicy, null);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, Login readLogin) {
        this(project, defaultConnectionPolicy, readLogin, null);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, Login readLogin, Login sequenceLogin) {
        this(project, defaultConnectionPolicy, 1, 32, 32, readLogin, sequenceLogin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireClientConnection(ClientSession clientSession) throws DatabaseException, ConcurrencyException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool pool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            Accessor connection = pool.acquireConnection();
            clientSession.setWriteConnection(connection);
            if (!connection.usesExternalConnectionPooling()) {
                clientSession.getEventManager().postAcquireConnection(connection);
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().postAcquireExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
            }
        } else {
            if (this.maxNumberOfNonPooledConnections != -1) {
                ServerSession serverSession = this;
                synchronized (serverSession) {
                    while (this.numberOfNonPooledConnectionsUsed >= this.maxNumberOfNonPooledConnections) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException exception) {
                            throw ConcurrencyException.waitFailureOnServerSession(exception);
                        }
                    }
                    ++this.numberOfNonPooledConnectionsUsed;
                }
            }
            clientSession.setWriteConnection(clientSession.getLogin().buildAccessor());
            if (!clientSession.getWriteConnection().usesExternalConnectionPooling()) {
                clientSession.connect();
                clientSession.getEventManager().postAcquireConnection(clientSession.getWriteConnection());
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().postAcquireExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
            }
        }
    }

    public ClientSession acquireClientSession() throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy());
    }

    public ClientSession acquireClientSession(Map properties) throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy(), properties);
    }

    public ClientSession acquireClientSession(String poolName) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(poolName));
    }

    public ClientSession acquireClientSession(String poolName, Map properties) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(poolName), properties);
    }

    public ClientSession acquireClientSession(Login login) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login));
    }

    public ClientSession acquireClientSession(Login login, Map properties) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login), properties);
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy) throws DatabaseException, ValidationException {
        return this.acquireClientSession(connectionPolicy, null);
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy, Map properties) throws DatabaseException, ValidationException {
        if (!this.isConnected()) {
            throw ValidationException.loginBeforeAllocatingClientSessions();
        }
        this.log(2, "connection", "client_acquired");
        if (!connectionPolicy.isPooled() && connectionPolicy.getLogin() == null) {
            connectionPolicy.setPoolName(this.getDefaultConnectionPolicy().getPoolName());
            connectionPolicy.setLogin(this.getDefaultConnectionPolicy().getLogin());
        }
        if (connectionPolicy.isPooled()) {
            ConnectionPool pool = (ConnectionPool)this.getConnectionPools().get(connectionPolicy.getPoolName());
            if (pool == null) {
                throw ValidationException.poolNameDoesNotExist(connectionPolicy.getPoolName());
            }
            connectionPolicy.setLogin(pool.getLogin());
        }
        ClientSession client = null;
        if (this.getProject().hasIsolatedClasses()) {
            client = connectionPolicy.isExclusive() ? new ExclusiveIsolatedClientSession(this, connectionPolicy, properties) : new IsolatedClientSession(this, connectionPolicy, properties);
        } else {
            if (connectionPolicy.isExclusiveIsolated()) {
                throw ValidationException.clientSessionCanNotUseExclusiveConnection();
            }
            client = connectionPolicy.isExclusiveAlways() ? new ExclusiveIsolatedClientSession(this, connectionPolicy, properties) : new ClientSession(this, connectionPolicy, properties);
        }
        if (this.isFinalizersEnabled()) {
            client.registerFinalizer();
        }
        if (!connectionPolicy.isLazy()) {
            this.acquireClientConnection(client);
        }
        return client;
    }

    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireClientSession().acquireUnitOfWork();
    }

    public void addConnectionPool(String poolName, Login login, int minNumberOfConnections, int maxNumberOfConnections) throws ValidationException {
        if (minNumberOfConnections > maxNumberOfConnections) {
            throw ValidationException.maxSizeLessThanMinSize();
        }
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool pool = null;
        pool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, login, this) : new ConnectionPool(poolName, login, minNumberOfConnections, maxNumberOfConnections, this);
        this.addConnectionPool(pool);
    }

    public void addConnectionPool(ConnectionPool pool) {
        pool.setOwner(this);
        this.getConnectionPools().put(pool.getName(), pool);
    }

    public Accessor allocateReadConnection() {
        Accessor connection = this.getReadConnectionPool().acquireConnection();
        if (!connection.usesExternalConnectionPooling()) {
            this.getEventManager().postAcquireConnection(connection);
        }
        return connection;
    }

    public void connect() {
        this.updateStandardConnectionPools();
        this.getReadConnectionPool().startUp();
        this.setAccessor(this.allocateReadConnection());
        this.releaseReadConnection(this.getAccessor());
        Iterator poolsEnum = this.getConnectionPools().values().iterator();
        while (poolsEnum.hasNext()) {
            ((ConnectionPool)poolsEnum.next()).startUp();
        }
    }

    public void disconnect() throws DatabaseException {
        try {
            super.disconnect();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Object object;
        block14: {
            RuntimeException exception = null;
            object = null;
            boolean accessorAllocated = false;
            if (query.getAccessor() == null) {
                query.setAccessor(this.allocateReadConnection());
                accessorAllocated = true;
            }
            try {
                object = query.getAccessor().executeCall(call, translationRow, this);
            }
            catch (RuntimeException caughtException) {
                exception = caughtException;
                return exception;
            }
            finally {
                block15: {
                    if (call.isFinished() || exception != null) {
                        try {
                            if (accessorAllocated) {
                                this.releaseReadConnection(query.getAccessor());
                                query.setAccessor(null);
                            }
                        }
                        catch (RuntimeException releaseException) {
                            if (exception != null) break block15;
                            throw releaseException;
                        }
                    }
                }
                if (exception == null) break block14;
                throw exception;
            }
        }
        return object;
    }

    public ConnectionPool getConnectionPool(String poolName) {
        return (ConnectionPool)this.getConnectionPools().get(poolName);
    }

    public Map getConnectionPools() {
        return this.connectionPools;
    }

    public ConnectionPolicy getDefaultConnectionPolicy() {
        if (this.defaultConnectionPolicy == null) {
            this.defaultConnectionPolicy = new ConnectionPolicy("default");
        }
        return this.defaultConnectionPolicy;
    }

    public ConnectionPool getDefaultConnectionPool() {
        return this.getConnectionPool("default");
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (query.isObjectLevelModifyQuery()) {
            throw QueryException.invalidQueryOnServerSession(query);
        }
        return this;
    }

    public int getMaxNumberOfNonPooledConnections() {
        return this.maxNumberOfNonPooledConnections;
    }

    public int getNumberOfNonPooledConnectionsUsed() {
        return this.numberOfNonPooledConnectionsUsed;
    }

    protected Login getReadLogin() {
        return this.getReadConnectionPool().getLogin();
    }

    public ConnectionPool getReadConnectionPool() {
        return this.readConnectionPool;
    }

    public boolean isConnected() {
        if (this.getReadConnectionPool() == null) {
            return false;
        }
        return this.getReadConnectionPool().isConnected();
    }

    public boolean isServerSession() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        try {
            super.logout();
        }
        finally {
            this.getReadConnectionPool().shutDown();
            Iterator poolsEnum = this.getConnectionPools().values().iterator();
            while (poolsEnum.hasNext()) {
                ((ConnectionPool)poolsEnum.next()).shutDown();
            }
        }
    }

    public void postConnectExternalConnection(Accessor accessor) {
        this.getEventManager().postAcquireConnection(accessor);
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        this.getEventManager().preReleaseConnection(accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClientSession(ClientSession clientSession) throws DatabaseException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool pool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            if (!clientSession.getWriteConnection().usesExternalConnectionPooling()) {
                clientSession.getEventManager().preReleaseConnection(clientSession.getWriteConnection());
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().preReleaseExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
            }
            pool.releaseConnection(clientSession.getWriteConnection());
            clientSession.setWriteConnection(null);
        } else {
            if (!clientSession.getWriteConnection().usesExternalConnectionPooling()) {
                clientSession.getEventManager().preReleaseConnection(clientSession.getWriteConnection());
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().preReleaseExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
                clientSession.disconnect();
            } else {
                clientSession.getWriteConnection().closeConnection();
            }
            clientSession.setWriteConnection(null);
            if (this.maxNumberOfNonPooledConnections != -1) {
                ServerSession serverSession = this;
                synchronized (serverSession) {
                    --this.numberOfNonPooledConnectionsUsed;
                    this.notify();
                }
            }
        }
    }

    public void releaseReadConnection(Accessor connection) {
        if (!connection.usesExternalConnectionPooling()) {
            this.getEventManager().preReleaseConnection(connection);
        }
        this.getReadConnectionPool().releaseConnection(connection);
    }

    public void setCheckConnections() {
        this.getReadConnectionPool().setCheckConnections();
        Iterator poolsEnum = this.getConnectionPools().values().iterator();
        while (poolsEnum.hasNext()) {
            ((ConnectionPool)poolsEnum.next()).setCheckConnections();
        }
        ConnectionPool sequencingPool = this.getSequencingServer().getConnectionPool();
        if (sequencingPool != null) {
            sequencingPool.setCheckConnections();
        }
    }

    public void setConnectionPools(Map connectionPools) {
        this.connectionPools = connectionPools;
    }

    public void setDefaultConnectionPolicy(ConnectionPolicy defaultConnectionPolicy) {
        this.defaultConnectionPolicy = defaultConnectionPolicy;
    }

    public void setDefaultConnectionPool() {
        this.addConnectionPool("default", this.getDatasourceLogin(), 32, 32);
    }

    public void setMaxNumberOfNonPooledConnections(int maxNumberOfNonPooledConnections) {
        this.maxNumberOfNonPooledConnections = maxNumberOfNonPooledConnections;
    }

    public void setNumberOfNonPooledConnectionsUsed(int numberOfNonPooledConnectionsUsed) {
        this.numberOfNonPooledConnectionsUsed = numberOfNonPooledConnectionsUsed;
    }

    public void setReadConnectionPool(ConnectionPool readConnectionPool) {
        if (this.isConnected()) {
            throw ValidationException.cannotSetReadPoolSizeAfterLogin();
        }
        this.readConnectionPool = readConnectionPool;
        this.readConnectionPool.setOwner(this);
    }

    public void setReadConnectionPool(Login readLogin) throws ValidationException {
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool pool = null;
        pool = readLogin.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("read", readLogin, this) : new ConnectionPool("read", readLogin, this);
        this.readConnectionPool = pool;
    }

    public void setSynchronized(boolean synched) {
    }

    protected void updateStandardConnectionPools() {
        if (this.getDefaultConnectionPool() != null && this.getDefaultConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setDefaultConnectionPool();
        }
        if (this.getReadConnectionPool() != null && this.getReadConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setReadConnectionPool(this.getReadConnectionPool().getLogin());
        }
    }

    public void useExclusiveReadConnectionPool(int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), minNumerOfConnections, maxNumerOfConnections, this));
    }

    public void useExclusiveReadConnectionPool(int initialNumberOfConnections, int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), initialNumberOfConnections, minNumerOfConnections, maxNumerOfConnections, this));
    }

    public void useExternalReadConnectionPool() {
        this.setReadConnectionPool(new ExternalConnectionPool("read", this.getDatasourceLogin(), this));
    }

    public void useReadConnectionPool(int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), minNumerOfConnections, maxNumerOfConnections, this));
    }

    public void useReadConnectionPool(int initialNumerOfConnections, int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), initialNumerOfConnections, minNumerOfConnections, maxNumerOfConnections, this));
    }

    public void validateQuery(DatabaseQuery query) {
        if (query.isObjectLevelReadQuery() && (query.getDescriptor().isIsolated() || ((ObjectLevelReadQuery)query).shouldUseExclusiveConnection())) {
            throw QueryException.isolatedQueryExecutedOnServerSession();
        }
    }

    public SequencingServer getSequencingServer() {
        return this.getSequencingHome().getSequencingServer();
    }
}

