/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.DefaultArgsHolderType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherWalker;

public class SqlType
extends TypeClass {
    public static final int CODE_OPAQUE = 58;
    public static final int CODE_SQLJTYPE = 108;
    public static final int SQLJTYPE_SQLDATA = 1;
    public static final int SQLJTYPE_CUSTOMDATUM = 2;
    public static final int SQLJTYPE_SERIALIZABLE = 3;
    public static final int SQLJTYPE_ORADATA = 5;
    public static final int SQLJTYPE_BOTH = 6;
    public static final int SQLJTYPE_BOTH8I = 7;
    public static final int ORACLE_TYPES_NCHAR = -72054;
    public static final int ORACLE_TYPES_NCLOB = -72055;
    public static final int ORACLE_TYPES_BOOLEAN = -72056;
    public static final int ORACLE_TYPES_TBD = -72057;
    private Vector m_dependTypes = null;
    static Hashtable m_convFuns = new Hashtable();
    private String m_version;
    protected SqlReflector m_reflector;
    protected ViewCache m_viewCache;
    protected SqlType m_parentType;
    protected boolean m_isReused;

    public SqlName getSqlName() {
        return (SqlName)this.m_name;
    }

    public boolean isRef() {
        return this.getTypecode() == 2006;
    }

    public boolean isCollection() {
        return this.getTypecode() == 2003 || this.getTypecode() == 1995 || this.isPlsqlTable();
    }

    public boolean isPlsqlTable() {
        return this.getTypecode() == -14 || this.getTypecode() == 1991 || this.getTypecode() == 1990;
    }

    public boolean isPlsqlRecord() {
        return this.getTypecode() == 1992;
    }

    public boolean isOpaque() {
        return this.getTypecode() == 2007;
    }

    public boolean isJavaStruct() {
        return this.getTypecode() == 2008;
    }

    public boolean isSqlStatement() {
        return false;
    }

    public int getSqljKind() {
        return 0;
    }

    public boolean isStruct() {
        return this.getTypecode() == 2002;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public Hashtable getAttributes() {
        return (Hashtable)this.getAnnotation();
    }

    public void addAttribute(String sqlField, String javaField) {
        String dbField = this.m_viewCache.dbifyName(sqlField);
        if (javaField == null) {
            javaField = sqlField;
        }
        Hashtable<String, String> h = (Hashtable<String, String>)this.getAnnotation();
        Vector<String> v = this.getNamedTranslations();
        if (h == null) {
            h = new Hashtable<String, String>();
            this.setAnnotation(h);
        }
        if (v == null) {
            v = new Vector<String>();
            this.setNamedTranslations(v);
        }
        String old = h.put(dbField, javaField);
        v.addElement(sqlField);
        if (old != null) {
            throw new IllegalArgumentException("Redeclaration of field " + dbField + " in " + this + "!");
        }
    }

    protected SqlType(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, SqlReflector reflector) {
        this(sqlName, typecode, generateMe, false, parentType, reflector);
        this.m_isReused = false;
    }

    SqlType(SqlName sqlName, int typecode, boolean generateMe, boolean isPrimitive, SqlType parentType, SqlReflector reflector) {
        super(sqlName, typecode, isPrimitive);
        this.m_isReused = false;
        this.m_reflector = reflector;
        if (this.m_reflector != null) {
            this.m_viewCache = this.m_reflector.getViewCache();
        }
        if (sqlName != null && this.m_reflector != null) {
            this.m_reflector.addType(sqlName, this, generateMe);
        }
        this.m_parentType = parentType;
    }

    public SqlType(String name, int typecode) {
        super(new SqlName(null, name, true, false, true, null, null, null, null), typecode, true);
    }

    SqlType(SqlName name, int typecode) {
        super(name, typecode, true);
    }

    boolean dependsOn(SqlType t) {
        if (this.m_dependTypes == null) {
            this.m_dependTypes = new Vector();
            if (this.isPlsqlRecord() || this instanceof DefaultArgsHolderType) {
                try {
                    AttributeField[] fields = this.getDeclaredFields(true);
                    for (int i = 0; i < fields.length; ++i) {
                        SqlType st = (SqlType)fields[i].getType();
                        if (!st.isPlsqlRecord() && !st.isPlsqlTable()) continue;
                        this.m_dependTypes.addElement(st);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            } else if (this instanceof PlsqlTableType) {
                try {
                    SqlType st = (SqlType)((PlsqlTableType)this).getComponentType();
                    if (st.isPlsqlRecord() || st.isPlsqlTable()) {
                        this.m_dependTypes.addElement(st);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        if (this.m_dependTypes.contains(t)) {
            return true;
        }
        for (int i = 0; i < this.m_dependTypes.size(); ++i) {
            if (!((SqlType)this.m_dependTypes.elementAt(i)).dependsOn(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConversion() {
        if (this.getSqlName() == null) {
            return false;
        }
        return this.getSqlName().hasConversion();
    }

    public String getTargetTypeName() {
        return this.getSqlName().getTargetTypeName();
    }

    public String getTargetTypeName(int schemaNames) {
        return this.getSqlName().getFullTargetTypeName(schemaNames);
    }

    public String getTypeName() {
        return this.getSqlName().getTypeName();
    }

    @Override
    public String getOutOfConversion() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getOutOfConversion();
    }

    @Override
    public String getIntoConversion() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getIntoConversion();
    }

    @Override
    public String getOutOfConversionQualified() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getOutOfConversionQualified();
    }

    @Override
    public String getIntoConversionQualified() {
        if (this.getSqlName() == null) {
            return null;
        }
        return this.getSqlName().getIntoConversionQualified();
    }

    public String getSqlTypeDecl() throws SQLException, PublisherException {
        String sqlTypeDecl = "";
        if (this.isPlsqlRecord() && !this.getSqlName().isReused()) {
            sqlTypeDecl = sqlTypeDecl + "CREATE OR REPLACE TYPE " + this.getTargetTypeName() + " AS OBJECT (\n";
            AttributeField[] fields = ((PlsqlRecordType)this).getFields(true);
            for (int i = 0; i < fields.length; ++i) {
                if (i != 0) {
                    sqlTypeDecl = sqlTypeDecl + ",\n";
                }
                sqlTypeDecl = sqlTypeDecl + "      " + Util.unreserveSql(fields[i].getName()) + " ";
                sqlTypeDecl = sqlTypeDecl + fields[i].printTypeWithLength(2);
            }
            sqlTypeDecl = sqlTypeDecl + "\n);";
        } else if (this.isPlsqlTable() && !this.getSqlName().isReused()) {
            PlsqlTableType plType = (PlsqlTableType)this;
            SqlType eleType = (SqlType)plType.getComponentType();
            sqlTypeDecl = sqlTypeDecl + "CREATE OR REPLACE TYPE " + this.getTargetTypeName();
            sqlTypeDecl = sqlTypeDecl + " AS TABLE OF ";
            sqlTypeDecl = sqlTypeDecl + Util.printTypeWithLength(eleType.getTargetTypeName(2), plType.getElemTypeLength(), plType.getElemTypePrecision(), plType.getElemTypeScale());
            sqlTypeDecl = sqlTypeDecl + ";";
        } else if (this instanceof DefaultArgsHolderType && !this.getSqlName().isReused()) {
            DefaultArgsHolderType holder = (DefaultArgsHolderType)this;
            sqlTypeDecl = sqlTypeDecl + "CREATE OR REPLACE TYPE " + this.getTypeName() + " AS OBJECT (\n";
            AttributeField vfield = holder.getFields(false)[0];
            sqlTypeDecl = sqlTypeDecl + "      " + vfield.getName() + " ";
            sqlTypeDecl = sqlTypeDecl + vfield.printTypeWithLength();
            sqlTypeDecl = sqlTypeDecl + "\n);";
        }
        return sqlTypeDecl;
    }

    public String getSqlTypeDrop() throws SQLException, PublisherException {
        return this.getSqlName().isReused() ? "" : "DROP TYPE " + this.getTargetTypeName() + " FORCE; \n" + "show errors\n";
    }

    public String getConversionFunDecl() throws PublisherException, SQLException {
        if (!this.hasConversion()) {
            return "";
        }
        String sqlConvPkgDecl = "";
        if (this.getSqlName().isRowType()) {
            sqlConvPkgDecl = sqlConvPkgDecl + "\t-- Redefine a PL/SQL RECORD type originally defined via CURSOR%ROWTYPE\n";
            sqlConvPkgDecl = sqlConvPkgDecl + "\tTYPE " + this.getTypeName() + " IS RECORD (\n";
            AttributeField[] fields = ((PlsqlRecordType)this).getFields(true);
            for (int i = 0; i < fields.length; ++i) {
                if (i != 0) {
                    sqlConvPkgDecl = sqlConvPkgDecl + ",\n";
                }
                sqlConvPkgDecl = sqlConvPkgDecl + "\t\t" + fields[i].getName() + " " + fields[i].printTypeWithLength();
            }
            sqlConvPkgDecl = sqlConvPkgDecl + ");";
        }
        sqlConvPkgDecl = sqlConvPkgDecl + "\t-- Declare the conversion functions the PL/SQL type " + this.getTypeName() + "\n" + "\tFUNCTION " + this.getOutOfConversion() + "(aPlsqlItem " + this.getTypeName() + ")\n" + " \tRETURN " + this.getTargetTypeName() + ";\n";
        sqlConvPkgDecl = sqlConvPkgDecl + "\tFUNCTION " + this.getIntoConversion() + "(aSqlItem " + this.getTargetTypeName() + ")\n" + "\tRETURN " + this.getTypeName() + ";";
        return sqlConvPkgDecl;
    }

    public String getConversionPL2SQLFunBody() throws SQLException, PublisherException {
        if (!this.hasConversion()) {
            return "";
        }
        String sqlConvPkgBody = "\tFUNCTION " + this.getOutOfConversion() + "(aPlsqlItem " + this.getTypeName() + ")\n " + "\tRETURN " + this.getTargetTypeName() + " IS \n" + "\taSqlItem " + this.getTargetTypeName() + "; \n" + "\tBEGIN \n" + this.getOutOfConvStmts("\t\t", "aPlsqlItem", "aSqlItem") + "\t\tRETURN aSqlItem;\n" + "\tEND " + this.getOutOfConversion() + ";\n";
        return sqlConvPkgBody;
    }

    public String getConversionSQL2PLFunBody() throws SQLException, PublisherException {
        if (!this.hasConversion()) {
            return "";
        }
        String sqlConvPkgBody = "\tFUNCTION " + this.getIntoConversion() + "(aSqlItem " + this.getTargetTypeName() + ") \n" + "\tRETURN " + this.getTypeName() + " IS \n" + "\taPlsqlItem " + this.getTypeName() + "; \n" + "\tBEGIN \n" + this.getIntoConvStmts("\t\t", "aSqlItem", "aPlsqlItem") + "\t\tRETURN aPlsqlItem;\n" + "\tEND " + this.getIntoConversion() + ";\n";
        return sqlConvPkgBody;
    }

    public String getBothConversions() throws SQLException, PublisherException {
        return this.getConversionSQL2PLFunBody() + this.getConversionPL2SQLFunBody();
    }

    public String getIntoConvStmts(String formatPrefix, String maybeSql, String maybePlsql) throws SQLException, PublisherException {
        if (!this.isPlsqlRecord() && !this.isPlsqlTable()) {
            return formatPrefix + maybePlsql + "." + this.getName() + " := " + maybeSql + this.getName() + ";\n";
        }
        String stmts = "";
        if (this.isPlsqlRecord()) {
            AttributeField[] fields = this.getFields(true);
            for (int i = 0; i < Array.getLength(fields); ++i) {
                stmts = stmts + formatPrefix + maybePlsql + "." + fields[i].getName() + " := " + (fields[i].getType().hasConversion() && fields[i].getType().getIntoConversion() != null ? fields[i].getType().getIntoConversion() + "(" + maybeSql + "." + Util.unreserveSql(fields[i].getName()) + ");\n" : maybeSql + "." + Util.unreserveSql(fields[i].getName()) + ";\n");
            }
        } else {
            TypeClass compType = ((PlsqlTableType)this).getComponentType();
            if (this.getTypecode() == 1991 || this.getTypecode() == 1990) {
                stmts = stmts + formatPrefix + maybePlsql + " := " + this.getTypeName() + "();\n";
                stmts = stmts + formatPrefix + maybePlsql + ".EXTEND" + "(" + maybeSql + ".COUNT);\n";
            }
            stmts = stmts + formatPrefix + "IF " + maybeSql + ".COUNT>0 THEN\n" + formatPrefix + "FOR I IN 1.." + maybeSql + ".COUNT LOOP\n" + formatPrefix + "\t" + maybePlsql + "(I)" + " := " + (compType.hasConversion() && compType.getIntoConversion() != null ? compType.getIntoConversion() + "(" + maybeSql + "(I)" + ");\n" : maybeSql + "(I);\n") + formatPrefix + "END LOOP; \n" + formatPrefix + "END IF;\n";
        }
        return stmts;
    }

    public String getOutOfConvStmts(String formatPrefix, String maybePlsql, String maybeSql) throws SQLException, PublisherException {
        if (!this.isPlsqlRecord() && !this.isPlsqlTable()) {
            return formatPrefix + maybeSql + " := " + maybePlsql + ";\n";
        }
        String stmts = "";
        if (this.isPlsqlRecord()) {
            int i;
            AttributeField[] fields = this.getFields(true);
            stmts = stmts + formatPrefix + maybeSql + " := " + this.getTargetTypeName() + "(NULL";
            for (i = 1; i < fields.length; ++i) {
                stmts = stmts + ", NULL";
            }
            stmts = stmts + ");\n";
            for (i = 0; i < fields.length; ++i) {
                stmts = stmts + formatPrefix + maybeSql + "." + Util.unreserveSql(fields[i].getName()) + " := " + (fields[i].getType().hasConversion() && fields[i].getType().getOutOfConversion() != null ? fields[i].getType().getOutOfConversion() + "(" + maybePlsql + "." + fields[i].getName() + ");\n" : maybePlsql + "." + fields[i].getName() + ";\n");
            }
        } else {
            TypeClass compType = ((PlsqlTableType)this).getComponentType();
            stmts = stmts + formatPrefix + maybeSql + " := " + this.getTargetTypeName() + "();\n" + formatPrefix + maybeSql + ".EXTEND(" + maybePlsql + ".COUNT);\n" + formatPrefix + "IF " + maybePlsql + ".COUNT>0 THEN\n" + formatPrefix + "FOR I IN " + maybePlsql + ".FIRST.." + maybePlsql + ".LAST LOOP\n" + formatPrefix + "\t" + maybeSql + "(I + 1 - " + maybePlsql + ".FIRST)" + " := " + (compType.hasConversion() || compType.getOutOfConversion() != null ? compType.getOutOfConversion() + "(" + maybePlsql + "(I)" + ");\n" : maybePlsql + "(I);\n") + formatPrefix + "END LOOP; \n" + formatPrefix + "END IF; \n";
        }
        return stmts;
    }

    public void accept(PublisherVisitor v) {
        ((PublisherWalker)v).visit(this);
    }
}

