/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Typemap;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;

public abstract class SqlTypeWithFields
extends SqlType {
    protected AttributeField[] m_fieldsPublishedOnly;
    protected AttributeField[] m_fields;
    protected static HashMap m_builtin = new HashMap();

    public SqlTypeWithFields(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, SqlReflector reflector) throws SQLException {
        super(sqlName, typecode, generateMe, parentType, reflector);
    }

    public boolean isTopLevel() {
        return false;
    }

    @Override
    public AttributeField[] getDeclaredFields(boolean publishedOnly) throws SQLException, PublisherException {
        if (publishedOnly) {
            if (this.m_fieldsPublishedOnly == null) {
                this.m_fieldsPublishedOnly = this.reflectFields(publishedOnly);
            }
            return this.m_fieldsPublishedOnly;
        }
        if (this.m_fields == null) {
            this.m_fields = this.reflectFields(publishedOnly);
        }
        return this.m_fields;
    }

    private AttributeField[] reflectFields(boolean publishedOnly) throws SQLException, PublisherException {
        return SqlTypeWithFields.reflectFields(publishedOnly, this.getFieldInfo(), this.m_reflector, this, false);
    }

    static AttributeField[] reflectFields(boolean publishedOnly, FieldInfo[] sfi, SqlReflector reflector, SqlType parent, boolean isGrandparent) throws SQLException, PublisherException {
        ArrayList<AttributeField> fieldsCS = new ArrayList<AttributeField>();
        ViewCache viewCache = reflector.getViewCache();
        Typemap map = new Typemap(parent, reflector);
        for (int ii = 0; sfi != null && ii < sfi.length; ++ii) {
            try {
                Iterator iter;
                int idx = sfi[ii].fieldNo;
                if (publishedOnly && map.getMemberName(sfi[ii].fieldName) == null) continue;
                String fieldTypeOwner = sfi[ii].fieldTypeOwner;
                if (m_builtin.get(sfi[ii].fieldTypeName) == null && !(iter = viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME", "PREDEFINED"}, new Object[]{fieldTypeOwner, sfi[ii].fieldTypeName, "NO"}, new String[0])).hasNext() && (iter = viewCache.getRows("ALL_TYPES", new String[0], new String[]{"TYPE_NAME", "PREDEFINED"}, new Object[]{sfi[ii].fieldTypeName, "NO"}, new String[0])).hasNext()) {
                    fieldTypeOwner = ((AllTypes)iter.next()).owner;
                }
                fieldsCS.add(new AttributeField(sfi[ii].fieldName, (TypeClass)reflector.addPlsqlDBType(fieldTypeOwner, sfi[ii].fieldTypeName, sfi[ii].fieldTypeSubname, sfi[ii].fieldTypeMod, false, sfi[ii].fieldPackageName, sfi[ii].fieldMethodName, sfi[ii].fieldMethodNo, sfi[ii].fieldSequence, parent, isGrandparent), sfi[ii].fieldDataLength, sfi[ii].fieldDataPrecision, sfi[ii].fieldDataScale, sfi[ii].fieldCharacterSetName, reflector));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        AttributeField[] sqlFields = new AttributeField[fieldsCS.size()];
        for (int i = 0; i < sqlFields.length; ++i) {
            sqlFields[i] = (AttributeField)fieldsCS.get(i);
        }
        return sqlFields;
    }

    protected abstract FieldInfo[] getFieldInfo() throws SQLException;

    static {
        m_builtin.put("VARCHAR2", Boolean.TRUE);
        m_builtin.put("NUMBER", Boolean.TRUE);
        m_builtin.put("DATE", Boolean.TRUE);
        m_builtin.put("BOOLEAN", Boolean.TRUE);
    }
}

