/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodResults;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class ResultInfo {
    public String resultTypeName;
    public String resultTypeSubname;
    public boolean ncharFormOfUse;
    public String resultTypeOwner;
    public String resultTypeMod;
    public String methodName;
    public String methodNo;
    public int sequence;
    public int dataLength;
    public int dataPrecision;
    public int dataScale;

    public ResultInfo(AllMethodResults r) throws SQLException {
        this.resultTypeMod = r.resultTypeMod;
        this.resultTypeOwner = r.resultTypeOwner;
        this.resultTypeName = r.resultTypeName;
        if ("PL/SQL BINARY INTEGER".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "BINARY_INTEGER";
        } else if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "BOOLEAN";
        } else if ("PL/SQL PLS INTEGER".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "PLS_INTEGER";
        } else if ("PL/SQL LONG".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "LONG";
        } else if ("PL/SQL LONG RAW".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "LONG RAW";
        } else if ("PL/SQL RAWID".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "PL/SQL RAWID";
        } else if ("PL/SQL URAWID".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "PL/SQL URAWID";
        }
        this.resultTypeSubname = null;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(r.characterSetName)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = r.methodName;
        this.methodNo = r.methodNo;
        this.sequence = -1;
        this.dataLength = 0;
        this.dataPrecision = 0;
        this.dataScale = 0;
    }

    public ResultInfo(UserArguments r) throws SQLException {
        this.resultTypeMod = "";
        if ("REF".equalsIgnoreCase(r.DATA_TYPE) || "PL/SQL RECORD".equalsIgnoreCase(r.DATA_TYPE) || "PL/SQL TABLE".equalsIgnoreCase(r.DATA_TYPE) || "VARRAY".equalsIgnoreCase(r.DATA_TYPE) || "TABLE".equalsIgnoreCase(r.DATA_TYPE)) {
            this.resultTypeMod = r.DATA_TYPE;
        }
        this.resultTypeOwner = r.TYPE_OWNER;
        if ("PUBLIC".equalsIgnoreCase(this.resultTypeOwner)) {
            this.resultTypeOwner = "SYS";
        }
        this.resultTypeName = r.TYPE_NAME;
        if (SqlReflector.isNull(this.resultTypeName)) {
            this.resultTypeName = r.PLS_TYPE;
        }
        if (SqlReflector.isNull(this.resultTypeName)) {
            this.resultTypeName = r.DATA_TYPE;
        }
        if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "BOOLEAN";
        }
        this.resultTypeSubname = r.TYPE_SUBNAME;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(r.CHARACTER_SET_NAME)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = r.OBJECT_NAME;
        this.methodNo = r.OVERLOAD;
        this.sequence = r.sequence;
        this.dataLength = r.DATA_LENGTH;
        this.dataPrecision = r.DATA_PRECISION;
        this.dataScale = r.DATA_SCALE;
    }

    public static ResultInfo getResultInfo(Iterator iter) throws SQLException {
        Vector<ResultInfo> a = new Vector<ResultInfo>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof UserArguments) {
                a.addElement(new ResultInfo((UserArguments)obj));
                continue;
            }
            a.addElement(new ResultInfo((AllMethodResults)obj));
        }
        ResultInfo[] r = new ResultInfo[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            r[i] = (ResultInfo)a.elementAt(i);
        }
        if (r.length == 0) {
            throw new SQLException("Exhausted ResultSet in ResultInfo");
        }
        return r[0];
    }
}

