/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.RowsCacheEntry;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRowFactory;

public class ViewCache
implements Externalizable {
    public static final String PARAMETER_USER = "USER";
    public static final String PARAMETER_ALL = "ALL";
    private Connection m_conn;
    private String m_user;
    private Hashtable m_rowsCacheIndex;
    private ArrayList m_rowsCache;
    private int m_hits;
    private int m_visits;
    private boolean m_viewCacheDebug = false;
    static final String VIEW_CACHE_PREFIX = "viewcachefor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRows(String view, String[] columns, String[] keys, Object[] values, String[] orderby) throws SQLException {
        ++this.m_visits;
        String cKey = this.makeKey(view, columns, keys, values, orderby);
        ArrayList<ViewRow> rowsV = (ArrayList<ViewRow>)this.m_rowsCacheIndex.get(cKey);
        ArrayList<ViewRow> derivedRowsV = rowsV;
        if (derivedRowsV == null) {
            for (int i = 0; i < this.m_rowsCache.size(); ++i) {
                RowsCacheEntry incoming = new RowsCacheEntry(view, columns, keys, values, null);
                RowsCacheEntry cached = (RowsCacheEntry)this.m_rowsCache.get(i);
                RowsCacheEntry diff = cached.compare(incoming);
                if (diff != null) {
                    if (this.m_viewCacheDebug) {
                        System.out.println("viewcache.hit.query.relaxed: " + i);
                    }
                    derivedRowsV = new ArrayList<ViewRow>();
                    for (int j = 0; j < diff.getRows().size(); ++j) {
                        ViewRow row = (ViewRow)diff.getRows().get(j);
                        boolean match = true;
                        for (int k = 0; k < diff.getKeys().length; ++k) {
                            if (k + 1 < diff.getKeys().length && diff.getKeys()[k].equals(diff.getKeys()[k + 1])) {
                                if (row.equals(diff.getKeys()[k], diff.getValues()[k]) || row.equals(diff.getKeys()[k], diff.getValues()[k])) continue;
                                match = false;
                                ++k;
                                continue;
                            }
                            if (row.equals(diff.getKeys()[k], diff.getValues()[k])) continue;
                            match = false;
                        }
                        if (!match) continue;
                        derivedRowsV.add(row);
                    }
                    break;
                }
                if (!this.m_viewCacheDebug) continue;
                System.out.println("viewcache.no.match.query: " + i + ", diff=" + diff);
            }
        }
        if (rowsV == null && orderby.length == 1 && orderby[0].equalsIgnoreCase("SEQUENCE") && ViewRowFactory.hasSequence(view)) {
            if (derivedRowsV == null) {
                String unorderedCKey = this.makeKey(view, columns, keys, values, new String[0]);
                derivedRowsV = (ArrayList)this.m_rowsCacheIndex.get(unorderedCKey);
            }
            if (derivedRowsV != null) {
                rowsV = (ArrayList)derivedRowsV.clone();
                UserArguments.orderBySequence(rowsV);
                if (this.m_viewCacheDebug) {
                    System.out.println("viewcache.hit.query.unordered.sequence");
                }
            }
        } else if (rowsV == null && orderby.length == 1 && orderby[0].equalsIgnoreCase("POSITION") && ViewRowFactory.hasPosition(view)) {
            if (derivedRowsV == null) {
                String unorderedCKey = this.makeKey(view, columns, keys, values, new String[0]);
                derivedRowsV = (ArrayList)this.m_rowsCacheIndex.get(unorderedCKey);
            }
            if (derivedRowsV != null) {
                rowsV = (ArrayList<ViewRow>)derivedRowsV.clone();
                UserArguments.orderByPosition(rowsV);
                if (this.m_viewCacheDebug) {
                    System.out.println("viewcache.hit.query.unordered.position");
                }
            }
        }
        if (rowsV == null) {
            rowsV = derivedRowsV;
        }
        if (rowsV == null) {
            String stmtText = this.makeQuery(view, columns, keys, values, orderby);
            ResultSet rset = null;
            PreparedStatement stmt = null;
            if (this.m_conn == null) {
                throw new SQLException("ERROR: null JDBC connection.");
            }
            try {
                stmt = this.m_conn.prepareStatement(stmtText);
                long millis = 0L;
                if (this.m_viewCacheDebug) {
                    millis = System.currentTimeMillis();
                    System.out.println("viewcache.execute.query: " + stmtText);
                }
                rset = stmt.executeQuery();
                rowsV = new ArrayList();
                while (rset.next()) {
                    rowsV.add(ViewRowFactory.createViewRow(view, columns, rset));
                    if (!this.m_viewCacheDebug) continue;
                    System.out.print(".");
                }
                if (this.m_viewCacheDebug) {
                    System.out.println("\nviewcache.execute.query.result.set.next.elapse: " + (System.currentTimeMillis() - millis));
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            this.m_rowsCacheIndex.put(cKey, rowsV);
            this.m_rowsCache.add(new RowsCacheEntry(view, columns, keys, values, rowsV));
        } else {
            ++this.m_hits;
            if (this.m_viewCacheDebug) {
                String stmtText = this.makeQuery(view, columns, keys, values, orderby);
                System.out.println("viewcache.hit.query: " + stmtText);
            }
        }
        if (rowsV == null) {
            rowsV = new ArrayList<ViewRow>();
        }
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.execute.query.result.size: " + rowsV.size());
            System.out.println("viewcache.hit.rate: " + cKey + ", " + this.m_hits + "/" + this.m_visits);
        }
        return rowsV.iterator();
    }

    public Object[] getOutParameters(String stmtText, Object[] inParams, int[] types) throws SQLException {
        ++this.m_visits;
        Object[] objTypes = this.toObject(types);
        String cKey = this.makeKey(stmtText, new String[0], new String[0], inParams, new String[0]);
        ArrayList<Object> outParamList = (ArrayList<Object>)this.m_rowsCacheIndex.get(cKey);
        if (outParamList == null && this.m_conn != null) {
            int i;
            outParamList = new ArrayList<Object>();
            CallableStatement stmt = this.m_conn.prepareCall(stmtText);
            for (i = 1; i < inParams.length + 1; ++i) {
                if (!(inParams[i - 1] instanceof byte[])) {
                    throw new SQLException("input type not supported: " + inParams[i - 1].getClass().getName());
                }
                stmt.setBytes(i, (byte[])inParams[i - 1]);
            }
            while (i < inParams.length + types.length + 1) {
                stmt.registerOutParameter(i, types[i - inParams.length - 1]);
                ++i;
            }
            stmt.executeUpdate();
            for (i = inParams.length; i < inParams.length + types.length; ++i) {
                int index = i - inParams.length;
                if (types[index] == 4) {
                    outParamList.add(new Integer(stmt.getInt(i + 1)));
                    continue;
                }
                if (types[index] != 12) continue;
                outParamList.add(stmt.getString(i + 1));
            }
            stmt.close();
            this.m_rowsCacheIndex.put(cKey, outParamList);
            this.m_rowsCache.add(new RowsCacheEntry(stmtText, new String[0], new String[0], objTypes, outParamList));
        }
        Object[] outParams = null;
        if (outParamList != null) {
            outParams = outParamList.toArray(new Object[0]);
        }
        return outParams;
    }

    private Object[] toObject(int[] types) {
        Object[] obj = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            obj[i] = new Integer(types[i]);
        }
        return obj;
    }

    private String makeKey(String view, String[] columns, String[] keys, Object[] values, String[] orderby) {
        int i;
        String key = view;
        if (columns.length != 0) {
            key = key + "[";
            for (i = 0; i < columns.length; ++i) {
                key = key + columns[i] + (i > 0 ? ", " : "");
            }
            key = key + "]";
        }
        key = key + "(";
        for (i = 0; i < keys.length; ++i) {
            key = key + keys[i] + ", ";
        }
        key = key + ": ";
        for (i = 0; i < values.length; ++i) {
            if (values[i] instanceof byte[]) {
                byte[] bytes = (byte[])values[i];
                for (int j = 0; j < bytes.length; ++j) {
                    key = key + bytes[j];
                }
                key = key + ", ";
                continue;
            }
            key = key + values[i] + ", ";
        }
        key = key + ")";
        for (i = 0; i < orderby.length; ++i) {
            key = key + orderby[i] + "(o)";
        }
        return key.toUpperCase();
    }

    private String makeQuery(String view, String[] columns, String[] keys, Object[] values, String[] orderby) {
        int i;
        String stmt = "SELECT " + ViewRowFactory.getProject(view, columns) + " FROM " + view;
        if (keys.length > 0) {
            stmt = stmt + " WHERE ";
        }
        boolean inOR = false;
        for (i = 0; i < keys.length; ++i) {
            if (!inOR && i < keys.length - 1 && keys[i].equals(keys[i + 1])) {
                stmt = stmt + "(";
                inOR = true;
            }
            stmt = stmt + keys[i];
            stmt = values[i] == null || "".equals(values[i]) ? stmt + " IS NULL" : ("NOT NULL".equals(values[i]) ? stmt + " IS NOT NULL" : (values[i] instanceof String ? stmt + "='" + (String)values[i] + "'" : (values[i] instanceof String && ((String)values[i]).indexOf("%") > -1 ? stmt + " like '" + (String)values[i] + "'" : stmt + "=" + values[i])));
            if (inOR && i < keys.length - 1 && keys[i].equals(keys[i + 1])) {
                stmt = stmt + " OR ";
                continue;
            }
            if (inOR && i < keys.length - 1) {
                stmt = stmt + ") AND ";
                inOR = false;
                continue;
            }
            if (inOR) {
                stmt = stmt + ")";
                inOR = false;
                continue;
            }
            if (i >= keys.length - 1) continue;
            stmt = stmt + " AND ";
        }
        for (i = 0; i < orderby.length; ++i) {
            if (i == 0) {
                stmt = stmt + " ORDER BY ";
            }
            stmt = stmt + orderby[i];
            if (i == orderby.length - 1) continue;
            stmt = stmt + ", ";
        }
        return stmt;
    }

    public ViewCache() {
    }

    public ViewCache(Connection conn, String user) {
        this.m_conn = conn;
        this.m_user = user;
        this.m_rowsCacheIndex = new Hashtable();
        this.m_rowsCache = new ArrayList();
        this.m_hits = 0;
        this.m_visits = 0;
    }

    public void init(ViewCache viewCache) {
        int len = this.m_rowsCache.size();
        for (int i = 0; i < len; ++i) {
            RowsCacheEntry entry = (RowsCacheEntry)this.m_rowsCache.get(i);
            try {
                this.getRows(entry);
                continue;
            }
            catch (Exception e) {
                System.err.println("WARNING: error in refreshing view cache for view " + entry.getView());
            }
        }
    }

    public void refresh() {
        int len = this.m_rowsCache.size();
        for (int i = 0; i < len; ++i) {
            RowsCacheEntry entry = (RowsCacheEntry)this.m_rowsCache.get(i);
            try {
                this.getRows(entry);
                continue;
            }
            catch (Exception e) {
                System.err.println("WARNING: error in refreshing view cache for view " + entry.getView());
            }
        }
    }

    private Iterator getRows(RowsCacheEntry entry) throws SQLException {
        return this.getRows(entry.getView(), entry.getSelects(), entry.getKeys(), entry.getValues(), new String[0]);
    }

    public void fetch(String packageName, MethodFilter sigf) throws SQLException {
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.fetch: " + packageName);
        }
        if (PARAMETER_ALL.equalsIgnoreCase(packageName = this.dbifyName(packageName)) || PARAMETER_USER.equalsIgnoreCase(packageName)) {
            this.getRows("ALL_ARGUMENTS", new String[0], new String[0], new Object[0], new String[0]);
        } else {
            String[] keys = null;
            Object[] values = null;
            if (sigf != null && sigf.isSingleMethod()) {
                keys = new String[]{"PACKAGE_NAME", "OBJECT_NAME"};
                values = new Object[]{packageName, sigf.getSingleMethodName()};
            } else {
                keys = new String[]{"PACKAGE_NAME"};
                values = new Object[]{packageName};
            }
            this.getRows("ALL_ARGUMENTS", new String[0], keys, values, new String[0]);
        }
    }

    public int getHits() {
        return this.m_hits;
    }

    public int getVisits() {
        return this.m_visits;
    }

    public void reset(Connection conn) {
        this.m_conn = conn;
    }

    public void close() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getUser() {
        return this.m_user;
    }

    public String getFileName(String dir) {
        return ViewCache.getFileName(dir, this.m_user);
    }

    public static String getFileName(String dir, String user) {
        return (dir == null ? "" : dir + File.separator) + VIEW_CACHE_PREFIX + user.toLowerCase();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.read.external");
        }
        this.m_user = (String)in.readObject();
        this.m_hits = (Integer)in.readObject();
        this.m_visits = (Integer)in.readObject();
        int rowsCacheSize = (Integer)in.readObject();
        this.m_rowsCache = new ArrayList(rowsCacheSize);
        for (int i = 0; i < rowsCacheSize; ++i) {
            RowsCacheEntry rce = (RowsCacheEntry)in.readObject();
            this.m_rowsCache.add(rce);
        }
        int rowsCacheIndexSize = (Integer)in.readObject();
        this.m_rowsCacheIndex = new Hashtable(rowsCacheIndexSize);
        for (int i = 0; i < rowsCacheIndexSize; ++i) {
            String key = (String)in.readObject();
            int rowsSize = (Integer)in.readObject();
            ArrayList<ViewRow> rows = new ArrayList<ViewRow>(rowsSize);
            for (int j = 0; j < rowsSize; ++j) {
                ViewRow row = (ViewRow)in.readObject();
                rows.add(row);
            }
            this.m_rowsCacheIndex.put(key, rows);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.write.external");
        }
        out.writeObject(this.m_user);
        out.writeObject(new Integer(this.m_hits));
        out.writeObject(new Integer(this.m_visits));
        out.writeObject(new Integer(this.m_rowsCache.size()));
        for (int i = 0; i < this.m_rowsCache.size(); ++i) {
            RowsCacheEntry rce = (RowsCacheEntry)this.m_rowsCache.get(i);
            out.writeObject(rce);
        }
        out.writeObject(new Integer(this.m_rowsCacheIndex.size()));
        Enumeration keys = this.m_rowsCacheIndex.keys();
        Enumeration values = this.m_rowsCacheIndex.elements();
        while (keys.hasMoreElements()) {
            out.writeObject(keys.nextElement());
            ArrayList rows = (ArrayList)values.nextElement();
            out.writeObject(new Integer(rows.size()));
            for (int i = 0; i < rows.size(); ++i) {
                out.writeObject(rows.get(i));
            }
        }
    }

    public String printSummary() {
        String text = "";
        text = text + "****" + this.getFileName(null) + "****" + "\n";
        text = text + "schema: " + this.m_user + "\n";
        text = text + "hits/visits: " + this.m_hits + "/" + this.m_visits + "\n";
        for (int i = 0; i < this.m_rowsCache.size(); ++i) {
            RowsCacheEntry rce = (RowsCacheEntry)this.m_rowsCache.get(i);
            text = text + rce.printSummary();
        }
        return text;
    }

    public String dbifyName(String s) {
        if (s == null) {
            return "";
        }
        if (s.equals("")) {
            return "";
        }
        if (SqlName.isQuoted(s)) {
            return s.substring(1, s.length() - 1);
        }
        String upper_s = s.toUpperCase();
        String dbName = "";
        try {
            Iterator rowIter = this.getRows("DUAL", new String[]{"UPPER('" + s + "') AS UPPER_NAME"}, new String[0], new Object[0], new String[0]);
            if (rowIter.hasNext()) {
                SingleColumnViewRow row = (SingleColumnViewRow)rowIter.next();
                dbName = row.getValue();
            } else {
                dbName = upper_s;
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            dbName = upper_s;
        }
        return dbName;
    }
}

