/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.util.ArrayList;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;

class ViewCachePool {
    private ArrayList m_pool;
    private int m_capacity;

    ViewCachePool() {
        this(1);
    }

    ViewCachePool(int capacity) {
        this.m_capacity = capacity;
        this.m_pool = new ArrayList();
    }

    void setCapacity(int size) {
        this.m_capacity = size;
        while (this.isFull()) {
            this.remove();
        }
    }

    synchronized void add(ViewCache viewCache) {
        for (int i = 0; i < this.m_pool.size(); ++i) {
            ViewCache v = (ViewCache)this.m_pool.get(i);
            if (!v.getUser().equalsIgnoreCase(viewCache.getUser())) continue;
            this.m_pool.remove(i);
        }
        if (this.isFull()) {
            this.remove();
        }
        this.m_pool.add(viewCache);
    }

    boolean isFull() {
        return this.m_capacity != 0 && this.m_pool.size() >= this.m_capacity;
    }

    ViewCache get(String userName) {
        for (int i = 0; i < this.m_pool.size(); ++i) {
            ViewCache v = (ViewCache)this.m_pool.get(i);
            if (!v.getUser().equalsIgnoreCase(userName)) continue;
            return v;
        }
        return null;
    }

    ViewCache get(int i) {
        return (ViewCache)this.m_pool.get(i);
    }

    int size() {
        return this.m_pool.size();
    }

    synchronized ViewCache remove() {
        if (this.m_pool.size() == 0) {
            return null;
        }
        return (ViewCache)this.m_pool.remove(0);
    }

    synchronized void clear() {
        this.m_pool.clear();
    }

    void refresh() {
        int len = this.m_pool.size();
        for (int i = 0; i < len; ++i) {
            ((ViewCache)this.m_pool.get(i)).refresh();
        }
    }
}

