/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class PLSQLProcedureOperationModel
extends ProcedureOperationModel {
    @Override
    public boolean isPLSQLProcedureOperation() {
        return true;
    }

    @Override
    public void buildOperation(DBWSBuilder builder) {
        List<DbStoredProcedure> procs = builder.loadProcedures(this, true);
        for (DbStoredProcedure storedProcedure : procs) {
            StringBuilder sb = new StringBuilder();
            if (this.name == null || this.name.length() == 0) {
                if (storedProcedure.getOverload() > 0) {
                    sb.append(storedProcedure.getOverload());
                    sb.append('_');
                }
                if (storedProcedure.getCatalog() != null && storedProcedure.getCatalog().length() > 0) {
                    sb.append(storedProcedure.getCatalog());
                    sb.append('_');
                }
                if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                    sb.append(storedProcedure.getSchema());
                    sb.append('_');
                }
                sb.append(storedProcedure.getName());
            } else {
                sb.append(this.name);
            }
            QueryOperation qo = new QueryOperation();
            qo.setName(sb.toString());
            SimpleXMLFormat sxf = null;
            if (this.isSimpleXMLFormat() || this.getReturnType() == null) {
                sxf = new SimpleXMLFormat();
            }
            if (this.simpleXMLFormatTag != null && this.simpleXMLFormatTag.length() > 0) {
                sxf.setSimpleXMLFormatTag(this.simpleXMLFormatTag);
            }
            if (this.xmlTag != null && this.xmlTag.length() > 0) {
                if (sxf == null) {
                    sxf = new SimpleXMLFormat();
                }
                sxf.setXMLTag(this.xmlTag);
            }
            Object result = null;
            if (!storedProcedure.isFunction() && Util.noOutArguments(storedProcedure)) {
                result = new Result();
                result.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
            } else if (storedProcedure.isFunction()) {
                DbStoredFunction storedFunction = (DbStoredFunction)storedProcedure;
                DbStoredArgument rarg = storedFunction.getReturnArg();
                if (rarg.getJdbcTypeName().contains("CURSOR")) {
                    result = new CollectionResult();
                    result.setType(Util.SXF_QNAME_CURSOR);
                } else {
                    result = new Result();
                    result.setType(Util.getXMLTypeFromJDBCType(rarg.getJdbcType()));
                }
            } else if (this.returnType != null) {
                String nsURI = null;
                String prefix = null;
                String localPart = null;
                int colonIdx = this.returnType.indexOf(58);
                result = new Result();
                if (colonIdx > 0) {
                    QName qName = null;
                    prefix = this.returnType.substring(0, colonIdx);
                    nsURI = builder.schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
                    if (nsURI == null) {
                        nsURI = "";
                    }
                    localPart = this.returnType.substring(colonIdx + 1);
                    if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                        qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                        if (qName == null) {
                            qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                        }
                    } else {
                        qName = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
                    }
                    result.setType(qName);
                } else {
                    result.setType(Util.qNameFromString("{" + builder.getTargetNamespace() + "}" + this.returnType, builder.schema));
                }
            } else if (this.isCollection) {
                result = new CollectionResult();
                if (this.isSimpleXMLFormat()) {
                    result.setType(Util.SXF_QNAME_CURSOR);
                }
            } else {
                result = new Result();
                result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            if (this.binaryAttachment) {
                Attachment attachment = new Attachment();
                attachment.setMimeType("application/octet-stream");
                result.setAttachment(attachment);
            }
            for (DbStoredArgument arg : storedProcedure.getArguments()) {
                String argName = arg.getName();
                if (argName == null) continue;
                ProcedureOutputArgument pa = null;
                Parameter parm = null;
                Util.InOut direction = arg.getInOut();
                QName xmlType = null;
                xmlType = OracleHelper.getXMLTypeFromJDBCType(arg, builder.getTargetNamespace());
                if (direction == Util.InOut.IN) {
                    parm = new Parameter();
                    parm.setName(argName);
                    parm.setType(xmlType);
                    pa = new ProcedureArgument();
                    pa.setName(argName);
                    pa.setParameterName(argName);
                } else {
                    ProcedureOutputArgument pao = pa = new ProcedureOutputArgument();
                    pao.setName(argName);
                    pao.setParameterName(argName);
                    if (arg.getJdbcTypeName().contains("CURSOR") && this.returnType == null) {
                        pao.setResultType(Util.SXF_QNAME_CURSOR);
                        if (result == null) {
                            result = new CollectionResult();
                            result.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (this.returnType != null && sxf == null) {
                            xmlType = Util.qNameFromString("{" + builder.getTargetNamespace() + "}" + this.returnType, builder.schema);
                        }
                        pao.setResultType(xmlType);
                        if (result == null) {
                            result = this.isCollection ? new CollectionResult() : new Result();
                            result.setType(xmlType);
                        }
                    }
                }
                if (arg instanceof PLSQLStoredArgument) {
                    pa.setComplexTypeName(((PLSQLStoredArgument)arg).getPlSqlTypeName());
                }
                if (parm == null) continue;
                qo.getParameters().add(parm);
            }
            if (sxf != null) {
                result.setSimpleXMLFormat(sxf);
                if (builder.oxProject.getDescriptorForAlias("simple-xml-format") == null) {
                    SimpleXMLFormatProject sxfProject = new SimpleXMLFormatProject();
                    builder.oxProject.addDescriptor(sxfProject.buildXRRowSetModelDescriptor());
                }
            }
            qo.setResult(result);
            builder.xrServiceModel.getOperations().put(qo.getName(), qo);
        }
        Util.addSimpleXMLFormat(builder.schema);
    }
}

