/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.tools.workbench.ant.ProjectExplorerInterface;
import org.eclipse.persistence.tools.workbench.ant.ProjectRunner;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.UiProjectBundle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ProjectExporter
extends ProjectRunner
implements ProjectExplorerInterface {
    private StringRepository uiProjectStringRepository;

    public ProjectExporter() {
    }

    public ProjectExporter(PrintStream log) {
        super(log);
    }

    protected void initialize(PrintStream log) {
        super.initialize(log);
        this.uiProjectStringRepository = new DefaultStringRepository(UiProjectBundle.class);
    }

    public int execute(String projectFileName, String deploymentFileName, String ejbJarXMLDir, Vector ignoreErrorCodes, Boolean failOnErrorObject, String url, String driverclass, String user, String password) {
        boolean failOnError = failOnErrorObject;
        File projectFile = new File(projectFileName);
        File deploymentFile = new File(deploymentFileName);
        try {
            MWProject project = new ProjectIOManager().read(projectFile, Preferences.userNodeForPackage(this.getClass()));
            project.validateBranch();
            if (project.hasBranchProblems()) {
                Collection problems = CollectionTools.collection((Iterator)project.branchProblems());
                Vector igoredProblems = this.getIgnoredProblems(problems, ignoreErrorCodes);
                this.log(this.igoredProblemsSummary(igoredProblems, ignoreErrorCodes).append('\n'));
                if (failOnError && problems.size() - igoredProblems.size() > 0) {
                    throw new BuildException(this.problemsSummary(project, project.branchProblemsSize()).toString());
                }
            }
            this.export(project, deploymentFile, ejbJarXMLDir, failOnError, url, driverclass, user, password);
        }
        catch (Throwable e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            String msg = t.getMessage() == null ? t.toString() : t.getMessage();
            throw new BuildException(this.stringRepository.getString("errorWhileExporting", msg), e);
        }
        return 0;
    }

    protected void export(MWProject project, File deploymentFile, String ejbJarXMLDir, boolean failOnError, String url, String driverclass, String user, String password) {
        if (project instanceof MWOXProject) {
            this.exportOXProject(project, deploymentFile);
        } else if (project instanceof MWEisProject) {
            this.exportEisProject(project, deploymentFile, url, driverclass, user, password);
        } else {
            this.exportRelationalProject(project, deploymentFile, url, driverclass, user, password);
        }
    }

    private void exportRelationalProject(MWProject project, File deploymentFile, String url, String driverclass, String user, String password) {
        if (deploymentFile.getPath() != "") {
            project.setDeploymentXMLFileName(deploymentFile.getPath());
        }
        if (project.getDeploymentXMLFileName() == "") {
            throw new RuntimeException(this.stringRepository.getString("notDefined", "DeploymentFileName"));
        }
        MWLoginSpec loginSpec = project.getDatabase().getDeploymentLoginSpec();
        if (url != "") {
            if (url != "") {
                loginSpec.setURL(url);
            }
            if (driverclass != "") {
                loginSpec.setDriverClassName(driverclass);
            }
            if (user != "") {
                loginSpec.setUserName(user);
            }
            if (password != "") {
                loginSpec.setPassword(password);
            }
        }
        this.log(this.stringRepository.getString("exportingXml", project.getDeploymentXMLFileName()) + "\n");
        project.exportDeploymentXML();
    }

    private void exportOXProject(MWProject project, File deploymentFile) {
        if (deploymentFile.getPath() != "") {
            project.setDeploymentXMLFileName(deploymentFile.getPath());
        }
        if (project.getDeploymentXMLFileName() == "") {
            throw new RuntimeException(this.stringRepository.getString("notDefined", "DeploymentFileName"));
        }
        this.log(this.stringRepository.getString("exportingXml", project.getDeploymentXMLFileName()) + "\n");
        project.exportDeploymentXML();
    }

    private void exportEisProject(MWProject project, File deploymentFile, String url, String eisPlatform, String user, String password) {
        if (deploymentFile.getPath() != "") {
            project.setDeploymentXMLFileName(deploymentFile.getPath());
        }
        if (project.getDeploymentXMLFileName() == "") {
            throw new RuntimeException(this.stringRepository.getString("notDefined", "DeploymentFileName"));
        }
        MWEisLoginSpec loginSpec = ((MWEisProject)project).getEisLoginSpec();
        if (url != "") {
            if (url != "") {
                loginSpec.setConnectionFactoryURL(url);
            }
            if (eisPlatform != "") {
                loginSpec.setJ2CAdapterName(eisPlatform);
            }
            if (user != "") {
                loginSpec.setUserName(user);
            }
            if (password != "") {
                loginSpec.setPassword(password);
            }
        }
        this.log(this.stringRepository.getString("exportingXml", project.getDeploymentXMLFileName()) + "\n");
        project.exportDeploymentXML();
    }
}

