/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentDescription;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class ButtonDescription
implements ComponentDescription {
    private FrameworkAction action;
    private String text;
    private String toolTip;
    private Icon icon;
    private int mnemonic;
    private boolean overrideActionResources = false;
    private AbstractButton button;
    private ButtonCreator buttonCreator;

    public ButtonDescription(FrameworkAction action, ButtonCreator buttonCreator, String text, String toolTip, int mnemonic, Icon icon) {
        this(action, buttonCreator);
        this.overrideActionResources = true;
        this.action = action;
        this.text = text;
        this.toolTip = toolTip;
        this.icon = icon;
        this.mnemonic = mnemonic;
    }

    public ButtonDescription(FrameworkAction action, ButtonCreator buttonCreator) {
        this.action = action;
        this.buttonCreator = buttonCreator;
    }

    protected void initializeButtonResources(AbstractButton button) {
        if (this.overrideActionResources) {
            button.setText(this.text);
            button.setIcon(this.icon);
            button.setToolTipText(this.toolTip);
            button.setMnemonic(this.mnemonic);
        }
    }

    public Component component() {
        this.button = this.buttonCreator.createButton(this.getAction());
        if (this.overrideActionResources) {
            this.initializeButtonResources(this.button);
        }
        return this.button;
    }

    protected FrameworkAction getAction() {
        return this.action;
    }

    public Iterator actions() {
        return new SingleElementIterator((Object)this.action);
    }

    public void updateOn(Collection frameworkActions) {
    }

    void setButtonCreator(ButtonCreator buttonCreator) {
        this.buttonCreator = buttonCreator;
    }

    public static interface ButtonCreator {
        public AbstractButton createButton(FrameworkAction var1);
    }
}

