/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class HelpPreferencesPage
extends AbstractPanel {
    private PropertyValueModel bufferedHostLocalAdapter;

    HelpPreferencesPage(PreferencesContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.intializeLayout();
    }

    private void intializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        int offset = SwingTools.checkBoxIconWidth();
        JPanel scrollPaneView = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(scrollPaneView);
        scrollPane.getVerticalScrollBar().setBlockIncrement(20);
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        this.add((Component)scrollPane, "Center");
        JPanel container = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        scrollPaneView.add((Component)container, constraints);
        JCheckBox welcomeScreenCheckBox = this.buildCheckBox("PREFERENCES.GENERAL.HELP.DISPLAY_WELCOME", this.buildDisplayWelcomeModel());
        this.addHelpTopicId(welcomeScreenCheckBox, this.helpTopicId() + ".welcome");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        JLabel browserLabel = this.buildLabel("PREFERENCES.GENERAL.HELP.BROWSER_CHOOSER");
        this.addHelpTopicId(browserLabel, this.helpTopicId() + ".browser");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        container.add((Component)browserLabel, constraints);
        FileChooserPanel browserChooser = new FileChooserPanel(this.getPreferencesContext(), this.buildBrowserHolder(), "PREFERENCES.GENERAL.HELP.BROWSER_CHOOSER", "PREFERENCES.GENERAL.HELP.BROWSER_CHOOSER_BUTTON", 0, true){

            protected boolean labelVisible() {
                return false;
            }
        };
        this.addHelpTopicId(browserChooser, this.helpTopicId() + ".browser");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, offset, 0, 5);
        container.add((Component)browserChooser, constraints);
        browserLabel.setLabelFor(browserChooser);
        JLabel localLabel = this.buildLabel("PREFERENCES.GENERAL.HELP.LOCAL");
        this.addHelpTopicId(localLabel, this.helpTopicId() + ".local");
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        FileChooserPanel localFileChooser = new FileChooserPanel(this.getPreferencesContext(), this.buildLocalFileHolder(), "PREFERENCES.GENERAL.HELP.LOCAL", "PREFERENCES.GENERAL.HELP.LOCAL_BROWSER_CHOOSER_BUTTON", 0){

            protected boolean labelVisible() {
                return false;
            }
        };
        this.addHelpTopicId(localFileChooser, this.helpTopicId() + ".local");
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, offset, 0, 5);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ButtonModel buildDisplayWelcomeModel() {
        return new CheckBoxModelAdapter(this.buildBufferedDisplayWelcomeAdapter());
    }

    private PropertyValueModel buildBufferedDisplayWelcomeAdapter() {
        return new BufferedPropertyValueModel(this.buildDisplayWelcomeAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildDisplayWelcomeAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "display welcome", true);
        adapter.setConverter(BidiStringConverter.BOOLEAN_CONVERTER);
        return adapter;
    }

    private PropertyValueModel buildLocalFileHolder() {
        return new BufferedPropertyValueModel(this.buildLocalFileAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildLocalFileAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "local file", (Object)"");
    }

    private PropertyValueModel buildBrowserHolder() {
        return new BufferedPropertyValueModel(this.buildBrowserAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildBrowserAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "external web browser");
        adapter.setConverter(BidiStringConverter.DEFAULT_INSTANCE);
        return adapter;
    }

    public String helpTopicId() {
        return "preferences.general.help";
    }
}

