/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DateSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class CacheExpiryPanel
extends AbstractSubjectPanel {
    private PropertyValueModel cacheExpiryHolder;
    private PropertyValueModel cacheExpiryTypeHolder;

    CacheExpiryPanel(ApplicationContext context, PropertyValueModel cachingPolicyHolder, String helpId) {
        super((ValueModel)cachingPolicyHolder, context.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class));
        this.addHelpTopicId(this, helpId);
    }

    protected void initialize(ValueModel subjectHolder) {
        super.initialize(subjectHolder);
        this.cacheExpiryHolder = this.buildCacheExpiryAdapter();
        this.cacheExpiryTypeHolder = this.buildCacheExpiryTypeAdapter();
    }

    private PropertyValueModel buildCacheExpiryAdapter() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cacheExpiry"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheExpiry();
            }

            protected void setValueOnSubject(Object value) {
            }
        };
    }

    private PropertyValueModel buildCacheExpiryTypeAdapter() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "expiryType"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getExpiryType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setExpiryType((String)value);
            }
        };
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("CACHING_POLICY_CACHE_EXPIRY"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JCheckBox projectDefaultCheckBox = this.buildCheckBox("CACHING_POLICY_PROJECT_DEFAULT_CHECK_BOX", this.buildProjectDefaultCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)projectDefaultCheckBox, constraints);
        JRadioButton noCacheExpiryButton = this.buildRadioButton("CACHING_POLICY_NO_EXPIRY", this.buildNoCacheExpiryRadioButtonAdapter());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)noCacheExpiryButton, constraints);
        JRadioButton timeToLiveExpiryButton = this.buildRadioButton("CACHING_POLICY_TIME_TO_LIVE_EXPIRY", this.buildTimeToLiveExpiryRadioButtonAdapter());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)timeToLiveExpiryButton, constraints);
        JLabel expireAfterLabel = this.buildLabel("CACHING_POLICY_TIME_TO_LIVE_EXPIRY_PREFIX_LABEL");
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)expireAfterLabel, constraints);
        JSpinner timeToLiveExpirySpinner = SwingComponentFactory.buildSpinnerNumber(this.buildTimeToLiveExpirySpinnerAdapter());
        SwingComponentFactory.attachDateSpinnerCommiter(timeToLiveExpirySpinner, this.cacheExpiryHolder);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)timeToLiveExpirySpinner, constraints);
        expireAfterLabel.setLabelFor(timeToLiveExpirySpinner);
        JLabel millisecondsLabel = this.buildLabel("CACHING_POLICY_TIME_TO_LIVE_EXPIRY_POSTFIX_LABEL");
        constraints.gridx = 3;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)millisecondsLabel, constraints);
        this.buildTimeToLiveExpiryComponentEnabler(new Component[]{timeToLiveExpirySpinner, expireAfterLabel, millisecondsLabel});
        JRadioButton dailyExpiryButton = this.buildRadioButton("CACHING_POLICY_DAILY_EXPIRY", this.buildDailyExpiryRadioButtonAdapter());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)dailyExpiryButton, constraints);
        millisecondsLabel.setLabelFor(dailyExpiryButton);
        JLabel expireAtLabel = this.buildLabel("CACHING_POLICY_DAILY_EXPIRY_PREFIX_LABEL");
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)expireAtLabel, constraints);
        SpinnerDateModel dateModel = this.buildDailyExpirySpinnerAdapter();
        JSpinner dailyExpirySpinner = this.buildSpinnerDate(dateModel);
        dailyExpirySpinner.setEditor(new JSpinner.DateEditor(dailyExpirySpinner, "HH : mm : ss"));
        SwingComponentFactory.attachDateSpinnerCommiter(dailyExpirySpinner, this.cacheExpiryHolder);
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)dailyExpirySpinner, constraints);
        expireAtLabel.setLabelFor(dailyExpirySpinner);
        this.buildDailyExpiryComponentEnabler(new Component[]{dailyExpirySpinner, expireAtLabel});
        JCheckBox updateReadTimeOnUpdateCheckBox = this.buildCheckBox("CACHING_POLICY_UPDATE_READ_TIME_ON_UPDATE", this.buildUpdateReadTimeOnUpdateCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 5, 0);
        this.add((Component)updateReadTimeOnUpdateCheckBox, constraints);
        this.buildUpdateReadTimeOnUpdateComponentEnabler(updateReadTimeOnUpdateCheckBox);
    }

    private ButtonModel buildProjectDefaultCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildProjectDefaultAdapter());
    }

    private PropertyValueModel buildProjectDefaultAdapter() {
        return new TransformationPropertyValueModel(this.cacheExpiryHolder){

            protected Object transform(Object value) {
                return value instanceof MWDescriptorCacheExpiry ? Boolean.FALSE : Boolean.TRUE;
            }

            protected Object reverseTransform(Object value) {
                MWCachingPolicy cachingPolicy = (MWCachingPolicy)CacheExpiryPanel.this.getSubjectHolder().getValue();
                if (cachingPolicy == null) {
                    return null;
                }
                cachingPolicy.setUseProjectDefaultCacheExpiry(((Boolean)value).booleanValue());
                return cachingPolicy.getCacheExpiry();
            }
        };
    }

    private ButtonModel buildNoCacheExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.cacheExpiryTypeHolder, "No Expiry");
    }

    private ButtonModel buildTimeToLiveExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.cacheExpiryTypeHolder, "Time to Live Expiry");
    }

    private SpinnerNumberModel buildTimeToLiveExpirySpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildTimeToLiveAdapter(), new Long(0L), new Long(Long.MAX_VALUE), new Long(1L), new Long(0L));
    }

    private PropertyValueModel buildTimeToLiveAdapter() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "timeToLiveExpiry"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getTimeToLiveExpiry();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setTimeToLiveExpiry((Long)value);
            }
        };
    }

    private ButtonModel buildDailyExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.cacheExpiryTypeHolder, "Daily Expiry");
    }

    private SpinnerDateModel buildDailyExpirySpinnerAdapter() {
        Date MIN = new Date(0, 0, 1, 0, 0, 0);
        Date MAX = new Date(300, 0, 1, 0, 0, 0);
        return new DateSpinnerModelAdapter(this.buildDailyExpiryHolder(), MIN, MAX, 12, MIN);
    }

    private PropertyValueModel buildDailyExpiryHolder() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "dailyExpiryTime"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getDailyExpiryTime();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setDailyExpiryTime((Date)value);
            }
        };
    }

    private ButtonModel buildUpdateReadTimeOnUpdateCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUpdateReadTimeOnUpdateHolder());
    }

    private PropertyValueModel buildUpdateReadTimeOnUpdateHolder() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "updateReadTimeOnUpdate"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getUpdateReadTimeOnUpdate();
            }

            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setUpdateReadTimeOnUpdate(((Boolean)value).booleanValue());
            }
        };
    }

    private ComponentEnabler buildUpdateReadTimeOnUpdateComponentEnabler(Component component) {
        TransformationPropertyValueModel noExpiryHolder = new TransformationPropertyValueModel(this.cacheExpiryTypeHolder){

            protected Object transform(Object value) {
                return value != "No Expiry";
            }
        };
        return new ComponentEnabler((ValueModel)noExpiryHolder, component);
    }

    private ComponentEnabler buildTimeToLiveExpiryComponentEnabler(Component[] components) {
        TransformationPropertyValueModel noExpiryHolder = new TransformationPropertyValueModel(this.cacheExpiryTypeHolder){

            protected Object transform(Object value) {
                return value == "Time to Live Expiry";
            }
        };
        return new ComponentEnabler((ValueModel)noExpiryHolder, components);
    }

    private ComponentEnabler buildDailyExpiryComponentEnabler(Component[] components) {
        TransformationPropertyValueModel noExpiryHolder = new TransformationPropertyValueModel(this.cacheExpiryTypeHolder){

            protected Object transform(Object value) {
                return value == "Daily Expiry";
            }
        };
        return new ComponentEnabler((ValueModel)noExpiryHolder, components);
    }
}

