/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaContextChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaContextComponentDisplayer;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaRepositoryValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class SchemaContextChooser
extends AbstractPanel {
    private SchemaRepositoryValue schemaRepositoryValue;
    private PropertyValueModel schemaContextComponentHolder;
    private SchemaContextDisplayStringValueModel schemaContextDisplayStringHolder;

    private SchemaContextChooser(WorkbenchContextHolder contextHolder) {
        super(contextHolder);
    }

    public SchemaContextChooser(WorkbenchContextHolder contextHolder, SchemaRepositoryValue schemaRepository, PropertyValueModel schemaContextHolder, JLabel label) {
        this(contextHolder);
        this.initialize(schemaRepository, schemaContextHolder, label);
    }

    private void initialize(SchemaRepositoryValue schemaRepository, PropertyValueModel schemaContextComponentHolder, JLabel label) {
        this.schemaRepositoryValue = schemaRepository;
        this.schemaContextComponentHolder = schemaContextComponentHolder;
        this.schemaContextDisplayStringHolder = this.buildSchemaContextDisplayStringHolder();
        this.initializeLayout(label);
    }

    private SchemaContextDisplayStringValueModel buildSchemaContextDisplayStringHolder() {
        return new SchemaContextDisplayStringValueModel(this.schemaContextComponentHolder);
    }

    private void initializeLayout(JLabel label) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JTextField textField = this.buildTextField();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)textField, constraints);
        textField.putClientProperty("labeledBy", label);
        JButton button = this.buildButton();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.addAlignRight(button);
        label.setLabelFor(button);
        SwingComponentFactory.updateButtonAccessibleName(label, button);
        this.add((Component)button, constraints);
    }

    private JTextField buildTextField() {
        JTextField textField = new JTextField(this.buildSchemaContextDisplayStringDocument(), null, 1);
        textField.setEditable(false);
        textField.setEnabled(true);
        return textField;
    }

    private DocumentAdapter buildSchemaContextDisplayStringDocument() {
        return new DocumentAdapter(this.schemaContextDisplayStringHolder);
    }

    private JButton buildButton() {
        JButton button = new JButton(this.resourceRepository().getString("SCHEMA_CONTEXT_CHOOSER_BROWSE_BUTTON"));
        button.addActionListener(this.buildBrowseAction());
        return button;
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SchemaContextChooser.this.promptToSelectSchemaContext();
            }
        };
    }

    private void promptToSelectSchemaContext() {
        SchemaContextChooserDialog dialog = new SchemaContextChooserDialog(this.getWorkbenchContext(), this.schemaRepositoryValue, this.schemaContextComponentHolder);
        dialog.show();
    }

    private class SchemaContextDisplayStringValueModel
    extends PropertyValueModelWrapper {
        private String displayString;
        private PropertyChangeListener speakerListener;
        private Set activeSpeakers;

        private SchemaContextDisplayStringValueModel(PropertyValueModel schemaContextComponentHolder) {
            super(schemaContextComponentHolder);
        }

        protected void initialize() {
            super.initialize();
            this.speakerListener = this.buildSpeakerListener();
            this.activeSpeakers = new HashSet();
        }

        private PropertyChangeListener buildSpeakerListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    SchemaContextDisplayStringValueModel.this.displayStringChanged();
                }
            };
        }

        private MWSchemaContextComponent schemaContextComponent() {
            return (MWSchemaContextComponent)this.valueHolder.getValue();
        }

        private void displayStringChanged() {
            Object oldValue = this.getValue();
            this.synchronizeDisplayString();
            Object newValue = this.getValue();
            this.firePropertyChanged("value", oldValue, newValue);
        }

        private void synchronizeDisplayString() {
            this.displayString = SchemaContextComponentDisplayer.displayString(SchemaContextChooser.this.resourceRepository(), this.schemaContextComponent());
        }

        private void engageNewSchemaContext() {
            if (this.schemaContextComponent() != null) {
                this.engageSpeaker((MWModel)this.schemaContextComponent().getSchema());
                Iterator stream = this.schemaContextComponent().namedComponentChain();
                while (stream.hasNext()) {
                    this.engageSpeaker((MWModel)((MWNamedSchemaComponent)stream.next()).getTargetNamespace());
                }
            }
        }

        private void engageSpeaker(MWModel speaker) {
            this.activeSpeakers.add(speaker);
            speaker.addPropertyChangeListener(this.speakerListener);
        }

        private void disengageOldSchemaContext() {
            Iterator stream = this.activeSpeakers.iterator();
            while (stream.hasNext()) {
                ((MWModel)stream.next()).removePropertyChangeListener(this.speakerListener);
            }
            this.activeSpeakers.clear();
        }

        public Object getValue() {
            return this.displayString;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.engageNewSchemaContext();
            this.synchronizeDisplayString();
        }

        protected void disengageValueHolder() {
            this.disengageOldSchemaContext();
            super.disengageValueHolder();
            this.synchronizeDisplayString();
        }

        protected void valueChanged(PropertyChangeEvent e) {
            this.disengageOldSchemaContext();
            this.engageNewSchemaContext();
            this.displayStringChanged();
        }
    }
}

