/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.EISLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.CustomServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginHandler;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectClassAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectXMLAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DatabaseSessionAdapter
extends SessionAdapter
implements LoginHandler {
    private volatile ProjectAdapter primaryProject;
    public static final String PRIMARY_PROJECT_PROPERTY = "primaryProject";
    private Collection additionalProjects;
    public static final String ADDITIONAL_PROJECTS_COLLECTION = "additionalProjects";
    private volatile boolean useAdditionalProjects;
    public static final String USE_ADDITIONAL_PROJECTS_COLLECTION = "useAdditionalProjects";
    public static final String EXTERNAL_CONNECTION_POOLING_PROPERTY = "externalConnectionPooling";
    private volatile LoginAdapter login;
    public static final String LOGIN_CONFIG_PROPERTY = "login";
    public static final String MAP_XML_TYPE = "project-xml";
    public static final String MAP_CLASS_TYPE = "project-class";
    public static final String DEFAULT_MAPPING_TYPE = "project-class";
    public static final String[] VALID_MAPPING_PROJECT_TYPE = new String[]{"project-xml", "project-class"};
    private volatile SessionBrokerAdapter broker;

    DatabaseSessionAdapter(SCAdapter parent, DatabaseSessionConfig scConfig) {
        super(parent, (SessionConfig)scConfig);
    }

    protected DatabaseSessionAdapter(SCAdapter parent, String name, ServerPlatform sp, DataSource ds) {
        super(parent, name);
        this.initializePlatforms(sp, ds);
    }

    protected Object buildModel() {
        DatabaseSessionConfig session = new DatabaseSessionConfig();
        session.setAdditionalProjects(new Vector());
        session.setSessionEventManagerConfig(new SessionEventManagerConfig());
        return session;
    }

    private LoginAdapter buildLogin(DataSource ds) {
        LoginAdapter login = ds.buildLoginAdapter(this);
        this.databaseSession().setLoginConfig((LoginConfig)login.getModel());
        login.setPlatformClass(ds.getPlatformClassName());
        return login;
    }

    LoginAdapter buildDefaultLogin() {
        DataSource ds = null;
        String dsType = this.preferences().get("data source type", "database");
        if (dsType.equals("relational")) {
            ds = this.buildDefaultRdbmsDataSource();
        } else if (dsType.equals("eis")) {
            ds = this.buildDefaultEisDataSource();
        } else if (dsType.equals("xml")) {
            ds = this.buildDefaultXmlDataSource();
        } else {
            throw new IllegalArgumentException(dsType);
        }
        return this.buildLogin(ds);
    }

    private DataSource buildDefaultRdbmsDataSource() {
        String platformName = this.preferences().get("platform.database", "Oracle11");
        DatabasePlatform platform = DatabasePlatformRepository.getDefault().platformNamed(platformName);
        return new DataSource(platform);
    }

    private DataSource buildDefaultEisDataSource() {
        String platformName = this.preferences().get("platform.eis", "AQPlatform");
        return new DataSource(platformName);
    }

    private DataSource buildDefaultXmlDataSource() {
        return DataSource.buildXmlDataSource();
    }

    private final DatabaseSessionConfig databaseSession() {
        return (DatabaseSessionConfig)this.getModel();
    }

    protected void initialize() {
        super.initialize();
        this.additionalProjects = new Vector();
    }

    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.databaseSession().setAdditionalProjects(new Vector());
        this.addPrimaryProjectXmlNamed("");
    }

    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.primaryProject = (ProjectAdapter)this.adapt(this.databaseSession().getPrimaryProject());
        this.additionalProjects.addAll(this.adaptAll(this.getAdditionalProjectsConfigs()));
        this.useAdditionalProjects = !this.additionalProjects.isEmpty();
        this.login = (LoginAdapter)this.adapt(this.databaseSession().getLoginConfig());
    }

    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (this.configVersionIsPre10g()) {
            if (this.login == null) {
                this.login = this.buildLogin(DataSource.buildDefault());
            } else if (StringTools.stringIsEmpty((String)this.login.getPlatformClass())) {
                this.setDefaultLoginPlatform();
            }
        } else if (this.login == null) {
            this.login = this.buildLogin(DataSource.buildDefault());
        }
    }

    private void setDefaultLoginPlatform() {
        DataSource ds = null;
        if (this.login.platformIsRdbms()) {
            ds = this.buildDefaultRdbmsDataSource();
        } else if (this.login.platformIsEis()) {
            ds = this.buildDefaultEisDataSource();
        } else if (this.login.platformIsXml()) {
            ds = this.buildDefaultXmlDataSource();
        } else {
            throw new IllegalStateException();
        }
        this.login.setPlatformClass(ds.getPlatformClassName());
    }

    private void initializePlatforms(ServerPlatform sp, DataSource ds) {
        this.login = this.buildLogin(ds);
        this.initializeServerPlatform(sp);
    }

    protected void preSaving() {
        super.preSaving();
        if (this.getLogin().hasNoConfigToSave()) {
            this.setEmptyLoginConfig();
        } else {
            this.getLogin().preSaving();
        }
    }

    protected void postSaving() {
        super.postSaving();
        this.syncSessionConfigLogin();
        this.getLogin().postSaving();
    }

    private void setEmptyLoginConfig() {
        if (this.login.platformIsRdbms()) {
            DatabaseLoginConfig emptyConfig = new DatabaseLoginConfig();
            emptyConfig.setByteArrayBinding(true);
            emptyConfig.setOptimizeDataConversion(true);
            emptyConfig.setTrimStrings(true);
            emptyConfig.setMaxBatchWritingSize(new Integer(32000));
            emptyConfig.setJdbcBatchWriting(true);
            this.databaseSession().setLoginConfig((LoginConfig)emptyConfig);
        } else if (this.login.platformIsEis()) {
            this.databaseSession().setLoginConfig((LoginConfig)new EISLoginConfig());
        }
    }

    private void syncSessionConfigLogin() {
        if (this.databaseSession().getLoginConfig() != (LoginConfig)this.getLogin().getModel()) {
            this.databaseSession().setLoginConfig((LoginConfig)this.getLogin().getModel());
        }
    }

    public LoginAdapter getLogin() {
        return this.login;
    }

    public String getPlatform() {
        return this.getLogin().getPlatformClass();
    }

    public String getDataSourceName() {
        return this.getLogin().getPlatformName();
    }

    public boolean platformIsRdbms() {
        return this.login.platformIsRdbms();
    }

    public boolean platformIsEis() {
        return this.login.platformIsEis();
    }

    public boolean platformIsXml() {
        return this.login.platformIsXml();
    }

    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append(", ");
        if (this.login == null) {
            sb.append("NO LOGIN");
        } else {
            this.login.toString(sb);
        }
    }

    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        if (this.isManaged()) {
            this.getBroker().sessionRenamed(oldName, name);
        }
    }

    public SessionBrokerAdapter getBroker() {
        return this.broker;
    }

    void setBroker(SessionBrokerAdapter broker) {
        this.broker = broker;
        this.setManaged(broker != null);
    }

    protected void setManaged(boolean managed) {
        super.setManaged(managed);
        if (managed) {
            this.initializeDefaults();
        }
        this.updateExternalConnectionPooling();
    }

    void externalTransactionControllerClassChanged() {
        if (this.hasJTA() && this.getServerPlatform().isCustom()) {
            String jtaClass = ((CustomServerPlatformAdapter)this.getServerPlatform()).getExternalTransactionControllerClass();
            boolean hasJtaClass = !StringTools.stringIsEmpty((String)jtaClass);
            this.getLogin().setUsesExternalTransactionController(hasJtaClass);
        }
        this.getLogin().setUsesExternalTransactionController(this.hasJTA());
        this.updateExternalConnectionPooling();
    }

    public Iterator additionalProjects() {
        return new CloneIterator(this.additionalProjects);
    }

    public Iterator additionalProjectNames() {
        return new TransformationIterator(this.additionalProjects()){

            protected Object transform(Object next) {
                return ((ProjectAdapter)((Object)next)).getName();
            }
        };
    }

    private Collection getAdditionalProjectsConfigs() {
        if (this.databaseSession().getAdditionalProjects() == null) {
            this.databaseSession().setAdditionalProjects(new Vector());
        }
        return this.databaseSession().getAdditionalProjects();
    }

    private ProjectAdapter getPrimaryProject() {
        return this.primaryProject;
    }

    public boolean isPrimaryProjectXml() {
        return this.primaryProject instanceof ProjectXMLAdapter;
    }

    public boolean isPrimaryProjectClass() {
        return this.primaryProject instanceof ProjectClassAdapter;
    }

    public boolean isServer() {
        return false;
    }

    public String getPrimaryProjectName() {
        if (this.getPrimaryProject() == null) {
            return null;
        }
        return this.getPrimaryProject().getName();
    }

    public ProjectClassAdapter addPrimaryProjectClassNamed(String name) {
        ProjectClassAdapter project = new ProjectClassAdapter((SCAdapter)this, name);
        this.setPrimaryProject(project);
        return (ProjectClassAdapter)this.primaryProject;
    }

    public ProjectXMLAdapter addPrimaryProjectXmlNamed(String name) {
        ProjectXMLAdapter project = new ProjectXMLAdapter((SCAdapter)this, name);
        this.setPrimaryProject(project);
        return (ProjectXMLAdapter)this.primaryProject;
    }

    public void removePrimaryProject() {
        ProjectAdapter old = this.primaryProject;
        this.primaryProject = null;
        this.databaseSession().setPrimaryProject(null);
        this.firePropertyChanged(PRIMARY_PROJECT_PROPERTY, (Object)old, null);
    }

    private void setPrimaryProject(ProjectAdapter project) {
        ProjectAdapter old = this.primaryProject;
        this.primaryProject = project;
        this.databaseSession().setPrimaryProject((ProjectConfig)project.getModel());
        this.firePropertyChanged(PRIMARY_PROJECT_PROPERTY, (Object)old, (Object)project);
    }

    public ProjectClassAdapter addProjectClassNamed(String name) {
        ProjectClassAdapter project = new ProjectClassAdapter((SCAdapter)this, name);
        this.addAdditionalProjects(project);
        this.fireItemAdded(ADDITIONAL_PROJECTS_COLLECTION, (Object)project);
        return project;
    }

    public ProjectXMLAdapter addProjectXmlNamed(String name) {
        ProjectXMLAdapter project = new ProjectXMLAdapter((SCAdapter)this, name);
        this.addAdditionalProjects(project);
        this.fireItemAdded(ADDITIONAL_PROJECTS_COLLECTION, (Object)project);
        return project;
    }

    public ProjectAdapter removeProject(ProjectAdapter project) {
        this.removeAdditionalProject(project);
        return project;
    }

    public ProjectAdapter projectNamed(String name) {
        Iterator iter = this.additionalProjects();
        while (iter.hasNext()) {
            ProjectAdapter project = (ProjectAdapter)((Object)iter.next());
            if (!name.equals(project.getName())) continue;
            return project;
        }
        return null;
    }

    public void updateExternalConnectionPooling() {
        this.setExternalConnectionPooling(this.hasJTA() || this.getLogin().databaseDriverIsDataSource());
    }

    private ProjectAdapter addAdditionalProjects(ProjectAdapter projectAdapter) {
        this.getAdditionalProjectsConfigs().add(projectAdapter.getModel());
        this.additionalProjects.add(projectAdapter);
        return projectAdapter;
    }

    private void removeAdditionalProject(ProjectAdapter projectAdapter) {
        this.getAdditionalProjectsConfigs().remove(projectAdapter.getModel());
        this.removeItemFromCollection((Object)projectAdapter, this.additionalProjects, ADDITIONAL_PROJECTS_COLLECTION);
    }

    private void removeAllAdditionalProjects() {
        this.removeItemsFromCollection(CollectionTools.collection((Iterator)this.additionalProjects()), this.additionalProjects, ADDITIONAL_PROJECTS_COLLECTION);
        this.getAdditionalProjectsConfigs().clear();
    }

    public boolean usesAdditionalProjects() {
        return this.useAdditionalProjects;
    }

    public void setUseAdditionalProjects(boolean useAdditionalProjects) {
        boolean old = this.usesAdditionalProjects();
        this.useAdditionalProjects = useAdditionalProjects;
        this.firePropertyChanged(USE_ADDITIONAL_PROJECTS_COLLECTION, old, useAdditionalProjects);
        if (!this.usesAdditionalProjects()) {
            this.removeAllAdditionalProjects();
        }
    }

    public boolean usesExternalConnectionPooling() {
        return this.getLogin().usesExternalConnectionPooling();
    }

    public void setExternalConnectionPooling(boolean value) {
        boolean old = this.getLogin().usesExternalConnectionPooling();
        this.getLogin().setExternalConnectionPooling(value);
        this.firePropertyChanged(EXTERNAL_CONNECTION_POOLING_PROPERTY, old, value);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.getLogin() != null) {
            children.add(this.getLogin());
        }
    }

    protected void addProblemsTo(List branchProblems) {
        super.addProblemsTo(branchProblems);
        this.verifyProblemMappingProject(branchProblems);
        this.verifyProblemPlatformClass(branchProblems);
    }

    private void verifyProblemPlatformClass(List branchProblems) {
        if (!this.login.platformIsRdbms()) {
            return;
        }
        try {
            DatabasePlatformRepository.getDefault().platformForRuntimePlatformClassNamed(this.login.getPlatformClass());
        }
        catch (IllegalArgumentException e) {
            branchProblems.add(this.buildProblem("0810", this.displayString(), this.login.getPlatformClass()));
        }
    }

    private void verifyProblemMappingProject(List branchProblems) {
        if (StringTools.stringIsEmpty((String)this.getPrimaryProjectName())) {
            branchProblems.add(this.buildProblem("0805", this.displayString()));
        }
    }
}

