/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;

public class SCClassRepository
extends AbstractNodeModel
implements ClassRepository {
    private List classpathEntries;
    private static final Class[] CORE_KEYS = new Class[]{Object.class, ValueHolderInterface.class};
    private static Set coreClassNames;

    public SCClassRepository(String[] classpathEntries) {
        this.initialize(classpathEntries);
    }

    public void addClasspathEntries(int index, List entries) {
        this.addItemsToList(index, entries, this.classpathEntries, "classpathEntries");
        this.markEntireBranchDirty();
    }

    public void addClasspathEntry(int index, String entry) {
        this.addItemToList(index, entry, this.classpathEntries, "classpathEntries");
        this.markEntireBranchDirty();
    }

    public ListIterator classpathEntries() {
        return new ReadOnlyListIterator(this.classpathEntries);
    }

    public int classpathEntriesSize() {
        return this.classpathEntries.size();
    }

    public String displayString() {
        return "";
    }

    public String entries() {
        StringBuffer entries = new StringBuffer();
        String pathSeparator = System.getProperty("path.separator");
        ListIterator iter = this.classpathEntries();
        while (iter.hasNext()) {
            String entry = (String)iter.next();
            if ("".equals(entry)) continue;
            entries.append(entry);
            if (!iter.hasNext()) continue;
            entries.append(pathSeparator);
        }
        return entries.toString();
    }

    public String getClasspathEntry(int index) {
        return (String)this.classpathEntries.get(index);
    }

    protected void initialize() {
        super.initialize();
        this.classpathEntries = new Vector();
        this.markEntireBranchClean();
    }

    private void initialize(String[] entries) {
        this.classpathEntries = new Vector(entries.length);
        CollectionTools.addAll((Collection)this.classpathEntries, (Object[])entries);
    }

    public Iterator classDescriptions() {
        return new CompositeIterator(SCClassRepository.coreClassNames(), this.types());
    }

    public void refreshClassDescriptions() {
    }

    public String removeClasspathEntry(int index) {
        this.markEntireBranchDirty();
        return (String)this.removeItemFromList(index, this.classpathEntries, "classpathEntries");
    }

    public String replaceClasspathEntry(int index, String newEntry) {
        this.markEntireBranchDirty();
        return (String)this.setItemInList(index, newEntry, this.classpathEntries, "classpathEntries");
    }

    boolean shouldBeSaved() {
        return this.classpathEntriesSize() > 0;
    }

    public void toString(StringBuffer buffer) {
        buffer.append("classpathEntries=");
        buffer.append(this.classpathEntries);
    }

    public Iterator types() {
        Classpath cp = new Classpath(this.classpathEntries);
        return cp.classNamesStream();
    }

    void update(ClassRepository repository) {
        this.removeItemsFromList(0, this.classpathEntriesSize(), this.classpathEntries, "classpathEntries");
        this.addItemsToList(0, CollectionTools.list((Iterator)repository.classpathEntries()), this.classpathEntries, "classpathEntries");
        this.markEntireBranchClean();
    }

    private static Iterator coreClassNames() {
        if (coreClassNames == null) {
            coreClassNames = SCClassRepository.buildCoreClassNames();
        }
        return coreClassNames.iterator();
    }

    private static Set buildCoreClassNames() {
        HashSet result = new HashSet(10000);
        ArrayList<String> locations = new ArrayList<String>();
        for (int i = 0; i < CORE_KEYS.length; ++i) {
            locations.add(Classpath.locationFor((Class)CORE_KEYS[i]));
        }
        Classpath cp = new Classpath(locations);
        cp.addClassNamesTo(result);
        return result;
    }
}

