/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.ui.view.EmptyPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.SCApplicationNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.DeletePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.EisPoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.EisReadPoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.PoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.RdbmsReadPoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.RenamePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.WritePoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;

public class PoolNode
extends SCApplicationNode {
    public PoolNode(ConnectionPoolAdapter pool, TreeNodeValueModel parent, SCPlugin plugin, ApplicationContext context) {
        super(pool, parent, plugin, context);
    }

    protected List buildDisplayStringPropertyNamesList() {
        List displayStrings = super.buildDisplayStringPropertyNamesList();
        displayStrings.add("name");
        return displayStrings;
    }

    protected FrameworkAction buildDeleteNodeAction(WorkbenchContext workbenchContext) {
        return new DeletePoolAction(workbenchContext);
    }

    ConnectionPoolAdapter pool() {
        return (ConnectionPoolAdapter)this.getValue();
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext context) {
        AbstractPropertiesPage propertiesPage = null;
        if (this.pool().platformIsXml()) {
            propertiesPage = new EmptyPropertiesPage(context);
        } else if (this.pool().platformIsRdbms()) {
            propertiesPage = this.buildRdbmsPropertiesPage(context);
        } else if (this.pool().platformIsEis()) {
            propertiesPage = this.buildEisPropertiesPage(context);
        }
        return propertiesPage;
    }

    private AbstractPropertiesPage buildRdbmsPropertiesPage(WorkbenchContext context) {
        if (this.pool().isWriteConnectionPool()) {
            return new WritePoolTabbedPropertiesPage(context);
        }
        if (this.pool().isReadConnectionPool()) {
            return new RdbmsReadPoolTabbedPropertiesPage(context);
        }
        return new PoolTabbedPropertiesPage(context);
    }

    private AbstractPropertiesPage buildEisPropertiesPage(WorkbenchContext context) {
        if (this.pool().isWriteConnectionPool()) {
            return new WritePoolTabbedPropertiesPage(context);
        }
        if (this.pool().isReadConnectionPool()) {
            return new EisReadPoolTabbedPropertiesPage(context);
        }
        return new EisPoolTabbedPropertiesPage(context);
    }

    private Object rdbmsPropertiesPageKey() {
        if (this.pool().isWriteConnectionPool()) {
            return WritePoolTabbedPropertiesPage.class;
        }
        if (this.pool().isReadConnectionPool()) {
            return RdbmsReadPoolTabbedPropertiesPage.class;
        }
        return PoolTabbedPropertiesPage.class;
    }

    private Object eisPropertiesPageKey() {
        if (this.pool().isWriteConnectionPool()) {
            return WritePoolTabbedPropertiesPage.class;
        }
        if (this.pool().isReadConnectionPool()) {
            return EisReadPoolTabbedPropertiesPage.class;
        }
        return EisPoolTabbedPropertiesPage.class;
    }

    protected Object propertiesPageKey() {
        if (this.pool().platformIsRdbms()) {
            return this.rdbmsPropertiesPageKey();
        }
        if (this.pool().platformIsEis()) {
            return this.eisPropertiesPageKey();
        }
        return EmptyPropertiesPage.class;
    }

    public String helpTopicID() {
        return "navigator.connectionPool";
    }

    protected String buildIconKey() {
        if (this.pool().isReadConnectionPool()) {
            return "CONNECTION_POOL_READ";
        }
        if (this.pool().isSequenceConnectionPool()) {
            return "CONNECTION_POOL_SEQUENCE";
        }
        if (this.pool().isWriteConnectionPool()) {
            return "CONNECTION_POOL_WRITE";
        }
        return "CONNECTION_POOL";
    }

    protected FrameworkAction buildRenameNodeAction(WorkbenchContext workbenchContext) {
        return new RenamePoolAction(workbenchContext);
    }
}

