/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.broker.SessionBrokerNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewBrokerAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewSessionAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.SessionsNode;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ProjectNode
extends SessionsNode {
    private boolean firstTimeReadOnlyFlagWasDetected;

    public ProjectNode(TopLinkSessionsAdapter topLinkSessions, TreeNodeValueModel parent, SCPlugin plugin, ApplicationContext context) {
        super(topLinkSessions, parent, plugin, context);
        this.firstTimeReadOnlyFlagWasDetected = topLinkSessions.getPath().canWrite();
    }

    protected AbstractApplicationNode buildChildNode(SessionAdapter session) {
        AbstractApplicationNode node = null;
        try {
            node = super.buildChildNode(session);
        }
        catch (IllegalArgumentException e) {
            if (session instanceof SessionBrokerAdapter) {
                node = new SessionBrokerNode((SessionBrokerAdapter)session, (TreeNodeValueModel)this, (SCPlugin)this.getPlugin(), this.getApplicationContext());
            }
            throw new IllegalArgumentException("Invalid Session");
        }
        return node;
    }

    protected CollectionValueModel buildSessionsAspectAdapter() {
        return new CollectionAspectAdapter(this, "sessions"){

            protected Iterator getValueFromSubject() {
                return ((TopLinkSessionsAdapter)this.subject).sessions();
            }

            protected int sizeFromSubject() {
                return ((TopLinkSessionsAdapter)this.subject).sessionsSize();
            }
        };
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext context) {
        return new ProjectPropertiesPage(context);
    }

    protected Object propertiesPageKey() {
        return ProjectPropertiesPage.class;
    }

    protected String buildIconKey() {
        return "SESSIONS_CONFIGURATION";
    }

    protected FrameworkAction buildRenameNodeAction(WorkbenchContext workbenchContext) {
        return null;
    }

    protected String buildDisplayString() {
        String displayString = super.buildDisplayString();
        File path = this.topLinkSessions().getPath();
        if (path.exists() && !path.canWrite()) {
            displayString = this.resourceRepository().getString("PROJECT_NODE_DISPLAY_STRING_READ_ONLY", displayString);
        }
        return displayString;
    }

    protected List buildDisplayStringPropertyNamesList() {
        List displayStrings = super.buildDisplayStringPropertyNamesList();
        displayStrings.add("name");
        return displayStrings;
    }

    private FrameworkAction getAddSessionAction(WorkbenchContext workbenchContext) {
        return new AddNewSessionAction(workbenchContext);
    }

    private FrameworkAction getAddBrokerAction(WorkbenchContext workbenchContext) {
        return new AddNewBrokerAction(workbenchContext);
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext wrappedContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription desc = new RootMenuDescription();
        MenuGroupDescription newGroup = new MenuGroupDescription();
        newGroup.add(this.getAddSessionAction(wrappedContext));
        newGroup.add(this.getAddBrokerAction(wrappedContext));
        MenuDescription newMenu = new MenuDescription(this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getMnemonic("NEW_MENU"), EMPTY_ICON);
        newMenu.add(newGroup);
        MenuGroupDescription newItemGroup = new MenuGroupDescription();
        newItemGroup.add(newMenu);
        desc.add(newItemGroup);
        MenuGroupDescription closeGroup = new MenuGroupDescription();
        closeGroup.add(this.getCloseAction(workbenchContext));
        desc.add(closeGroup);
        MenuGroupDescription saveGroup = new MenuGroupDescription();
        saveGroup.add(this.getSaveAction(workbenchContext));
        saveGroup.add(this.getSaveAsAction(workbenchContext));
        desc.add(saveGroup);
        desc.add(this.buildHelpMenuGroup(wrappedContext));
        return desc;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext wrappedContext = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription desc = new ToolBarDescription();
        ToolBarButtonGroupDescription addGroup = new ToolBarButtonGroupDescription();
        addGroup.add(this.getAddSessionAction(wrappedContext));
        addGroup.add(this.getAddBrokerAction(wrappedContext));
        desc.add(addGroup);
        return desc;
    }

    protected FrameworkAction getCloseAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getCloseAction();
    }

    protected FrameworkAction buildDeleteNodeAction(WorkbenchContext workbenchContext) {
        return null;
    }

    protected FrameworkAction getSaveAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAction();
    }

    protected FrameworkAction getSaveAsAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAsAction();
    }

    TopLinkSessionsAdapter topLinkSessions() {
        return (TopLinkSessionsAdapter)this.getValue();
    }

    public String helpTopicID() {
        return "navigator.scproject";
    }

    public boolean save(File mostRecentSaveDirectory, WorkbenchContext workbenchContext) {
        TopLinkSessionsAdapter sessions = this.topLinkSessions();
        File path = sessions.getPath();
        boolean saved = false;
        if (path.getPath().startsWith("sessions")) {
            saved = this.saveAs(mostRecentSaveDirectory, workbenchContext);
        } else if (!path.canWrite()) {
            if (this.firstTimeReadOnlyFlagWasDetected) {
                this.showErrorReadOnlyMessage(workbenchContext);
                this.firstTimeReadOnlyFlagWasDetected = false;
                if (this.canRetryToSave(workbenchContext) && (saved = this.saveAs(mostRecentSaveDirectory, workbenchContext))) {
                    this.displayStringChanged();
                }
            } else {
                saved = this.saveAs(mostRecentSaveDirectory, workbenchContext);
            }
        } else {
            saved = this.saveImp(path, workbenchContext);
            this.firstTimeReadOnlyFlagWasDetected = false;
            if (saved) {
                this.displayStringChanged();
            }
        }
        return saved;
    }

    private boolean canRetryToSave(WorkbenchContext workbenchContext) {
        return 0 == JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("SAVE_RETRY_TO_SAVE_MESSAGE"), workbenchContext.getApplicationContext().getApplication().getShortProductName(), 0);
    }

    private boolean saveImp(File savePath, WorkbenchContext workbenchContext) {
        TopLinkSessionsAdapter sessions = this.topLinkSessions();
        try {
            sessions.getProperties().saveAs(this.preferences(), savePath);
            sessions.save(savePath);
            return true;
        }
        catch (Throwable e) {
            this.showErrorMessage(e, workbenchContext);
            return false;
        }
    }

    public boolean saveAs(File mostRecentSaveDirectory, WorkbenchContext workbenchContext) {
        File path = this.topLinkSessions().getPath();
        File directory = path.getParentFile();
        if (directory == null) {
            directory = mostRecentSaveDirectory;
        }
        FileChooserDialog chooser = new FileChooserDialog(workbenchContext);
        chooser.setDialogTitle(this.resourceRepository().getString("SAVE_AS_DIALOG_TITLE"));
        chooser.setCurrentDirectory(directory);
        chooser.setSelectedFile(path);
        chooser.setMultiSelectionEnabled(false);
        int result = chooser.showSaveDialog(workbenchContext.getCurrentWindow());
        if (result != 0) {
            return false;
        }
        workbenchContext.getNavigatorSelectionModel().pushExpansionState();
        boolean saved = this.saveImp(chooser.getSelectedFile(), workbenchContext);
        workbenchContext.getNavigatorSelectionModel().popAndRestoreExpansionState();
        return saved;
    }

    public File saveFile() {
        File saveLocation = this.topLinkSessions().getPath();
        return saveLocation.exists() ? saveLocation : null;
    }

    private void showErrorReadOnlyMessage(WorkbenchContext workbenchContext) {
        String fileName = FileTools.canonicalFile((File)this.topLinkSessions().getPath()).getPath();
        String message = this.resourceRepository().getString("SAVE_READ_ONLY_ERROR_MESSAGE", workbenchContext.getApplicationContext().getApplication().getShortProductName(), fileName, StringTools.CR);
        LabelArea label = new LabelArea(message);
        JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), label, workbenchContext.getApplicationContext().getApplication().getShortProductName(), 2);
    }

    private void showErrorMessage(Throwable exception, WorkbenchContext workbenchContext) {
        ((SCPlugin)this.getPlugin()).showWarning(workbenchContext, this.resourceRepository().getString("SAVE_ERROR_MESSAGE", this.topLinkSessions().getPath().getPath()), exception);
    }

    private class FileChooserDialog
    extends JFileChooser {
        private WorkbenchContext workbenchContext;

        private FileChooserDialog(WorkbenchContext workbenchContext) {
            this.workbenchContext = workbenchContext;
        }

        public void approveSelection() {
            int result = this.canReplaceExistingFile();
            if (result == 0) {
                super.approveSelection();
            } else if (result == 2) {
                this.cancelSelection();
            }
        }

        private int canReplaceExistingFile() {
            File file = this.getSelectedFile();
            String applicationName = this.workbenchContext.getApplicationContext().getApplication().getShortProductName();
            if (this.isDocumentOpened(file)) {
                String message = ProjectNode.this.resourceRepository().getString("SAVE_AS_DIALOG_ALREADY_OPENED", applicationName, file, StringTools.CR);
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), label, applicationName, 2);
                return 1;
            }
            if (file.exists() && !file.canWrite()) {
                String message = ProjectNode.this.resourceRepository().getString("SAVE_AS_DIALOG_CANT_SAVE", file);
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), label, applicationName, 2);
                return 1;
            }
            if (file.exists() && !ProjectNode.this.topLinkSessions().getPath().equals(file)) {
                String message = ProjectNode.this.resourceRepository().getString("SAVE_AS_DIALOG_REPLACE", this.getSelectedFile().getPath());
                LabelArea label = new LabelArea(message);
                label.setPreferredWidth(800);
                return JOptionPane.showConfirmDialog(this.workbenchContext.getCurrentWindow(), label, applicationName, 1);
            }
            return 0;
        }

        private boolean isDocumentOpened(File file) {
            ApplicationNode[] appNodes = ProjectNode.this.nodeManager().projectNodesFor(ProjectNode.this.getPlugin());
            for (int i = 0; i < appNodes.length; ++i) {
                File anotherOpenedFile;
                ProjectNode node = (ProjectNode)appNodes[i];
                if (node == ProjectNode.this || !file.equals(anotherOpenedFile = node.topLinkSessions().getPath())) continue;
                return true;
            }
            return false;
        }
    }
}

