/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewBrokerAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewSessionAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.AbstractSessionsListPane;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class SessionsListPane
extends AbstractSessionsListPane {
    SessionsListPane(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    protected void addNewSession() {
        AddNewSessionAction action = new AddNewSessionAction(this.getWorkbenchContext(), false);
        action.execute();
    }

    protected void addNewSessionBroker() {
        AddNewBrokerAction action = new AddNewBrokerAction(this.getWorkbenchContext(), false);
        action.execute();
    }

    protected AddRemoveListPanel buildSessionListPane() {
        return new ExtendedSessionListPanel();
    }

    protected CollectionValueModel buildSessionsCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "sessions"){

            protected Iterator getValueFromSubject() {
                TopLinkSessionsAdapter adapter = (TopLinkSessionsAdapter)this.subject;
                return adapter.sessions();
            }

            protected int sizeFromSubject() {
                TopLinkSessionsAdapter adapter = (TopLinkSessionsAdapter)this.subject;
                return adapter.sessionsSize();
            }
        };
    }

    protected boolean canRemoveSessions(Collection sessions) {
        int confirmation;
        Nominative nominative = (Nominative)this.subject();
        String name = nominative.getName();
        Vector brokers = this.retrieveSessionBrokerWithManagedSessions(sessions);
        if (!brokers.isEmpty()) {
            if (brokers.size() == 1) {
                SessionBrokerAdapter broker = (SessionBrokerAdapter)brokers.firstElement();
                JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("DELETE_BROKER_MESSAGE", broker.displayString()), this.resourceRepository().getString("DELETE_BROKER_TITLE"), 2);
            } else {
                JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("DELETE_BROKERS_MESSAGE"), this.resourceRepository().getString("DELETE_BROKER_TITLE"), 2);
            }
            confirmation = 1;
        } else if (sessions.size() == 1) {
            SessionAdapter session = (SessionAdapter)sessions.iterator().next();
            confirmation = JOptionPane.showConfirmDialog(this.currentWindow(), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_SINGLE", session.displayString(), name), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_SINGLE_TITLE"), 0);
        } else {
            confirmation = JOptionPane.showConfirmDialog(this.currentWindow(), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI", name), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI_TITLE"), 0);
        }
        return confirmation == 0;
    }

    private Vector retrieveSessionBrokerWithManagedSessions(Collection sessions) {
        Vector<SessionBrokerAdapter> brokers = new Vector<SessionBrokerAdapter>();
        for (SessionAdapter session : sessions) {
            SessionBrokerAdapter broker;
            if (!session.isBroker() || (broker = (SessionBrokerAdapter)session).sessionsSize() <= 0) continue;
            brokers.add(broker);
        }
        return brokers;
    }

    protected void removeSessions(Collection sessions) {
        TopLinkSessionsAdapter adapter = (TopLinkSessionsAdapter)this.subject();
        adapter.removeSessions(sessions);
    }

    private class ExtendedSessionListPanel
    extends AbstractSessionsListPane.CustomizedSessionListPanel {
        private ExtendedSessionListPanel() {
            super(SessionsListPane.this);
        }

        private ActionListener buildAddBrokerAction() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SessionsListPane.this.addNewSessionBroker();
                }
            };
        }

        protected JButton buildAddBrokerButton() {
            JButton button = this.buildButton("PROJECT_SESSIONS_BROKER_ADD_BUTTON");
            button.addActionListener(this.buildAddBrokerAction());
            return button;
        }

        protected void buildButtonPanel(JComponent buttonPanel, JButton addButton, JButton removeButton, JButton optionalButton) {
            buttonPanel.add(addButton);
            buttonPanel.add(this.buildAddBrokerButton());
            buttonPanel.add(removeButton);
            buttonPanel.add(optionalButton);
        }
    }
}

