/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class ProjectTypeEditDialog
extends AbstractDialog {
    private DatabaseSessionAdapter databaseSession;
    private JComponent projectClassWidgets;
    private ProjectTypeEditor projectType;
    private String helpTopicId;
    private JComponent projectXmlWidgets;

    ProjectTypeEditDialog(WorkbenchContext context, String title, DatabaseSessionAdapter databaseSession, ProjectTypeUpdater projectType, String helpTopicId) {
        super(context, title);
        this.initialize(databaseSession, projectType, helpTopicId);
    }

    private void addProjectXML() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new XmlFileFilter());
        fileChooser.setCurrentDirectory(this.retrieveLastDirectory());
        fileChooser.setFileSelectionMode(0);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.preferences().put("location", selectedFile.getParent());
            this.projectType.setProjectXml(selectedFile.getAbsolutePath());
        }
    }

    private ActionListener buildClassBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassChooserTools.promptForType(ProjectTypeEditDialog.this.getWorkbenchContext(), ProjectTypeEditDialog.this.databaseSession.getClassRepository(), ProjectTypeEditDialog.this.buildProjectClassHolder());
            }
        };
    }

    private void buildClassComponentEnabler(JComponent component) {
        new ComponentEnabler((ValueModel)this.buildProjectTypeClassHolder(), component.getComponents());
    }

    private JComponent buildLabeledComponent(String key, JComponent component, JComponent rightComponent, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        Pane pane = new Pane(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = SwingComponentFactory.buildLabel(key, this.resourceRepository());
        pane.add((Component)label, constraints);
        leftAligner.add(label);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)component, constraints);
        component.setName(key);
        label.setLabelFor(component);
        if (rightComponent != null) {
            constraints.weightx = 0.0;
            constraints.fill = 0;
            pane.add((Component)rightComponent, constraints);
            rightComponent.setName(key);
            rightAligner.add(rightComponent);
        }
        return pane;
    }

    private JComponent buildLabeledTextField(String key, Document document, JComponent rightComponent, ComponentAligner leftAligner, ComponentAligner rightAligner) {
        JTextField textField = new JTextField(document, null, 40);
        return this.buildLabeledComponent(key, textField, rightComponent, leftAligner, rightAligner);
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        ComponentAligner leftAligner = new ComponentAligner();
        ComponentAligner rightAligner = new ComponentAligner();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(SwingComponentFactory.buildStandardEmptyBorder());
        JRadioButton xmlFileButton = SwingComponentFactory.buildRadioButton("PROJECT_TYPE_EDIT_DIALOG_XML_RADIO_BUTTON", this.buildProjectTypeButtonModel(Boolean.TRUE), this.resourceRepository());
        JButton xmlBrowseButton = SwingComponentFactory.buildButton("PROJECT_TYPE_EDIT_DIALOG_XML_BROWSE_BUTTON", this.resourceRepository());
        xmlBrowseButton.addActionListener(this.buildXMLBrowseAction());
        this.projectXmlWidgets = this.buildLabeledTextField("PROJECT_TYPE_EDIT_DIALOG_XML_FIELD", this.buildProjectXmlDocumentAdapter(), xmlBrowseButton, leftAligner, rightAligner);
        GroupBox groupBox = new GroupBox(xmlFileButton, this.projectXmlWidgets);
        this.buildXmlFileComponentEnabler(this.projectXmlWidgets);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)groupBox, constraints);
        JRadioButton classTypeButton = SwingComponentFactory.buildRadioButton("PROJECT_TYPE_EDIT_DIALOG_CLASS_RADIO_BUTTON", this.buildProjectTypeButtonModel(Boolean.FALSE), this.resourceRepository());
        JButton classBrowseButton = SwingComponentFactory.buildButton("PROJECT_TYPE_EDIT_DIALOG_CLASS_BROWSE_BUTTON", this.resourceRepository());
        classBrowseButton.addActionListener(this.buildClassBrowseAction());
        this.projectClassWidgets = this.buildLabeledTextField("PROJECT_TYPE_EDIT_DIALOG_CLASS_FIELD", this.buildProjectClassDocumentAdapter(), classBrowseButton, leftAligner, rightAligner);
        groupBox = new GroupBox(classTypeButton, this.projectClassWidgets);
        this.buildClassComponentEnabler(this.projectClassWidgets);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)groupBox, constraints);
        return container;
    }

    private Document buildProjectClassDocumentAdapter() {
        return new DocumentAdapter(this.buildProjectClassHolder(), RegexpDocument.buildDocument(3));
    }

    private PropertyValueModel buildProjectClassHolder() {
        return new PropertyAspectAdapter("ProjectClass", (Model)this.projectType){

            protected Object getValueFromSubject() {
                ProjectTypeEditor projectType = (ProjectTypeEditor)((Object)this.subject);
                return projectType.getProjectClass();
            }

            protected void setValueOnSubject(Object value) {
                ProjectTypeEditor projectType = (ProjectTypeEditor)((Object)this.subject);
                projectType.setProjectClass((String)value);
            }
        };
    }

    private ButtonModel buildProjectTypeButtonModel(Object buttonValue) {
        return new RadioButtonModelAdapter(this.buildProjectTypeHolder(), buttonValue);
    }

    private PropertyValueModel buildProjectTypeClassHolder() {
        return new TransformationPropertyValueModel(this.buildProjectTypeHolder()){

            protected Object transform(Object value) {
                return !Boolean.TRUE.equals(value);
            }
        };
    }

    private PropertyValueModel buildProjectTypeHolder() {
        return new PropertyAspectAdapter("projectTypeXml", (Model)this.projectType){

            protected Object getValueFromSubject() {
                ProjectTypeEditor projectType = (ProjectTypeEditor)((Object)this.subject);
                return projectType.isProjectTypeXml();
            }

            protected void setValueOnSubject(Object value) {
                ProjectTypeEditor projectType = (ProjectTypeEditor)((Object)this.subject);
                projectType.setProjectTypeXml(Boolean.TRUE.equals(value));
            }
        };
    }

    private Document buildProjectXmlDocumentAdapter() {
        return new DocumentAdapter(this.buildProjectXmlHolder());
    }

    private PropertyValueModel buildProjectXmlHolder() {
        return new PropertyAspectAdapter("ProjectXml", (Model)this.projectType){

            protected Object getValueFromSubject() {
                ProjectTypeEditor projectType = (ProjectTypeEditor)((Object)this.subject);
                return projectType.getProjectXml();
            }

            protected void setValueOnSubject(Object value) {
                ProjectTypeEditor projectType = (ProjectTypeEditor)((Object)this.subject);
                projectType.setProjectXml((String)value);
            }
        };
    }

    private ActionListener buildXMLBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectTypeEditDialog.this.addProjectXML();
            }
        };
    }

    private void buildXmlFileComponentEnabler(JComponent component) {
        new ComponentEnabler((ValueModel)this.buildProjectTypeHolder(), component.getComponents());
    }

    protected String helpTopicId() {
        return this.helpTopicId;
    }

    protected Component initialFocusComponent() {
        if (this.databaseSession.isPrimaryProjectXml()) {
            return this.projectXmlWidgets.getComponent(1);
        }
        return this.projectClassWidgets.getComponent(1);
    }

    private void initialize(DatabaseSessionAdapter databaseSession, ProjectTypeUpdater updater, String helpTopicId) {
        this.databaseSession = databaseSession;
        this.helpTopicId = helpTopicId;
        this.projectType = new ProjectTypeEditor(updater);
    }

    public void okConfirmed() {
        super.okConfirmed();
        this.projectType.apply();
    }

    private File retrieveLastDirectory() {
        TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)this.databaseSession.getParent();
        File saveDirectory = topLinkSessions.getSaveDirectory();
        if (saveDirectory == null) {
            saveDirectory = FileTools.userHomeDirectory();
        }
        return new File(this.preferences().get("location", saveDirectory.getPath()));
    }

    private class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || ".xml".equalsIgnoreCase(FileTools.extension((File)file));
        }

        public String getDescription() {
            return ProjectTypeEditDialog.this.resourceRepository().getString("SESSION_PROJECT_ADVANCED_FILE_CHOOSER_DESCRIPTION");
        }
    }

    public static interface ProjectTypeUpdater {
        public void apply(boolean var1, String var2);

        public String getProjectName();

        public boolean isProjectXml();
    }

    private static class ProjectTypeEditor
    extends AbstractModel {
        private String projectClass;
        private boolean projectTypeXml;
        private String projectXml;
        private ProjectTypeUpdater updater;
        public static final String PROJECT_CLASS_PROPERTY = "ProjectClass";
        public static final String PROJECT_TYPE_XML_PROPERTY = "projectTypeXml";
        public static final String PROJECT_XML_PROPERTY = "ProjectXml";

        public ProjectTypeEditor(ProjectTypeUpdater updater) {
            this.initialize(updater);
        }

        public void apply() {
            this.updater.apply(this.projectTypeXml, this.projectTypeXml ? this.projectXml : this.projectClass);
        }

        public String getProjectClass() {
            return this.projectClass;
        }

        public String getProjectXml() {
            return this.projectXml;
        }

        private void initialize(ProjectTypeUpdater updater) {
            this.updater = updater;
            this.setProjectTypeXml(updater.isProjectXml());
            if (this.projectTypeXml) {
                this.setProjectXml(updater.getProjectName());
            } else {
                this.setProjectClass(updater.getProjectName());
            }
        }

        public boolean isProjectTypeXml() {
            return this.projectTypeXml;
        }

        public void setProjectClass(String projectClass) {
            String oldProjectClass = this.getProjectClass();
            this.projectClass = projectClass;
            this.firePropertyChanged(PROJECT_CLASS_PROPERTY, oldProjectClass, projectClass);
        }

        public void setProjectTypeXml(boolean projectTypeXml) {
            boolean oldProjectTypeXml = this.isProjectTypeXml();
            this.projectTypeXml = projectTypeXml;
            this.firePropertyChanged(PROJECT_TYPE_XML_PROPERTY, oldProjectTypeXml, projectTypeXml);
        }

        public void setProjectXml(String projectXml) {
            String oldProjectXml = this.getProjectXml();
            this.projectXml = projectXml;
            this.firePropertyChanged(PROJECT_XML_PROPERTY, oldProjectXml, projectXml);
        }
    }
}

