/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class StructConvertersPane
extends AbstractSubjectPanel {
    public StructConvertersPane(PropertyValueModel loginAdapterHolder, WorkbenchContextHolder contextHolder) {
        super((LayoutManager)new BorderLayout(), (ValueModel)loginAdapterHolder, contextHolder);
        this.addHelpTopicId(this, "rdbms.options.structConverters");
    }

    private AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemoveListAdapter();
    }

    private ListValueModel buildStructConverterListHolder() {
        return new ListAspectAdapter(this.getSubjectHolder(), "structConverters"){

            protected ListIterator getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return adapter.structConvertersClasses();
            }
        };
    }

    private AddRemoveListPanel buildStructConverterListPane() {
        return new CustomizedAddRemoveListPanel();
    }

    protected void initializeLayout() {
        AddRemoveListPanel structConverterListPanel = this.buildStructConverterListPane();
        structConverterListPanel.setCellRenderer(new SimpleListCellRenderer());
        structConverterListPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("OPTIONS_STRUCT_CONVERTER_LIST"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)structConverterListPanel, "Center");
        this.addPaneForAlignment(structConverterListPanel);
    }

    private class CustomizedAddRemoveListPanel
    extends AddRemoveListPanel {
        private CustomizedAddRemoveListPanel() {
            super(StructConvertersPane.this.getApplicationContext(), StructConvertersPane.this.buildAddRemoveListPanelAdapter(), StructConvertersPane.this.buildStructConverterListHolder(), 3);
        }

        protected String addButtonKey() {
            return "OPTIONS_STRUCT_CONVERTERS_ADD_BUTTON";
        }

        protected void buildButtonPanel(JComponent buttonPanel, JButton addButton, JButton removeButton, JButton optionalButton) {
            buttonPanel.add(addButton);
            buttonPanel.add(removeButton);
        }

        protected String removeButtonKey() {
            return "OPTIONS_STRUCT_CONVERTERS_REMOVE_BUTTON";
        }
    }

    private class AddRemoveListAdapter
    implements AddRemovePanel.Adapter {
        private AddRemoveListAdapter() {
        }

        public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            DatabaseLoginAdapter login = (DatabaseLoginAdapter)StructConvertersPane.this.subject();
            SimplePropertyValueModel selectionHolder = new SimplePropertyValueModel();
            ClassChooserTools.promptForType(StructConvertersPane.this.getWorkbenchContext(), login.getClassRepository(), selectionHolder);
            String structConverterClassName = (String)selectionHolder.getValue();
            if (structConverterClassName != null && !CollectionTools.contains(login.structConvertersClasses(), (Object)structConverterClassName)) {
                login.addStructConverterClass(structConverterClassName);
            }
        }

        public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)StructConvertersPane.this.subject();
            Object[] selectedValues = listSelectionModel.getSelectedValues();
            int index = selectedValues.length;
            while (--index >= 0) {
                adapter.removeStructConverterClass((String)selectedValues[index]);
            }
        }
    }
}

