/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.filters.BidiFilter;

public class FilteringPropertyValueModel
extends PropertyValueModelWrapper {
    private BidiFilter filter;
    private Object defaultValue;

    public FilteringPropertyValueModel(PropertyValueModel valueHolder) {
        this(valueHolder, BidiFilter.NULL_INSTANCE, null);
    }

    public FilteringPropertyValueModel(PropertyValueModel valueHolder, Object defaultValue) {
        this(valueHolder, BidiFilter.NULL_INSTANCE, defaultValue);
    }

    public FilteringPropertyValueModel(PropertyValueModel valueHolder, BidiFilter filter) {
        this(valueHolder, filter, null);
    }

    public FilteringPropertyValueModel(PropertyValueModel valueHolder, BidiFilter filter, Object defaultValue) {
        super(valueHolder);
        this.filter = filter;
        this.defaultValue = defaultValue;
    }

    public Object getValue() {
        return this.filterValue(this.valueHolder.getValue());
    }

    public void setValue(Object value) {
        if (this.reverseAccept(value)) {
            this.valueHolder.setValue(value);
        }
    }

    protected void valueChanged(PropertyChangeEvent e) {
        Object oldValue = this.filterValue(e.getOldValue());
        Object newValue = this.filterValue(e.getNewValue());
        this.firePropertyChanged("value", oldValue, newValue);
    }

    protected Object filterValue(Object value) {
        return this.accept(value) ? value : this.defaultValue();
    }

    protected boolean accept(Object value) {
        return this.filter.accept(value);
    }

    protected boolean reverseAccept(Object value) {
        return this.filter.reverseAccept(value);
    }

    protected Object defaultValue() {
        return this.defaultValue;
    }
}

