/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class TransformationListValueModelAdapter
extends ListValueModelWrapper {
    protected final Transformer transformer;
    protected List transformedList;

    public TransformationListValueModelAdapter(ListValueModel listHolder, Transformer transformer) {
        super(listHolder);
        this.transformer = transformer;
    }

    public TransformationListValueModelAdapter(ListValueModel listHolder) {
        this(listHolder, Transformer.NULL_INSTANCE);
    }

    public TransformationListValueModelAdapter(CollectionValueModel collectionHolder, Transformer transformer) {
        this(new CollectionListValueModelAdapter(collectionHolder), transformer);
    }

    public TransformationListValueModelAdapter(CollectionValueModel collectionHolder) {
        this(collectionHolder, Transformer.NULL_INSTANCE);
    }

    protected void initialize() {
        super.initialize();
        this.transformedList = new ArrayList();
    }

    public Object getValue() {
        return new ReadOnlyListIterator(this.transformedList);
    }

    public void addItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(int index, List items) {
        throw new UnsupportedOperationException();
    }

    public Object removeItem(int index) {
        throw new UnsupportedOperationException();
    }

    public List removeItems(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public Object replaceItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    public List replaceItems(int index, List items) {
        throw new UnsupportedOperationException();
    }

    public Object getItem(int index) {
        return this.transformedList.get(index);
    }

    public int size() {
        return this.transformedList.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.transformedList.addAll(this.transformItems(this.listHolder));
    }

    protected void disengageModel() {
        super.disengageModel();
        this.transformedList.clear();
    }

    protected List transformItems(ListChangeEvent e) {
        return this.transformItems(e.items(), e.size());
    }

    protected List transformItems(ListValueModel lvm) {
        return this.transformItems((ListIterator)lvm.getValue(), lvm.size());
    }

    protected List transformReplacedItems(ListChangeEvent e) {
        return this.transformItems(e.replacedItems(), e.size());
    }

    protected List transformItems(ListIterator items, int size) {
        ArrayList<Object> result = new ArrayList<Object>(size);
        while (items.hasNext()) {
            result.add(this.transformItem(items.next()));
        }
        return result;
    }

    protected Object transformItem(Object item) {
        return this.transformer.transform(item);
    }

    protected void itemsAdded(ListChangeEvent e) {
        this.addItemsToList(e.getIndex(), this.transformItems(e), this.transformedList, "value");
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.removeItemsFromList(e.getIndex(), e.size(), this.transformedList, "value");
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.setItemsInList(e.getIndex(), this.transformItems(e), this.transformedList, "value");
    }

    protected void listChanged(ListChangeEvent e) {
        this.transformedList.clear();
        this.transformedList.addAll(this.transformItems(this.listHolder));
        this.fireListChanged("value");
    }
}

