/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.eclipse.persistence.tools.workbench.uitools.app.NullPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

public class LabelPanel
extends JPanel {
    private JLabel label;

    public LabelPanel(PropertyValueModel iconHolder, PropertyValueModel textHolder) {
        super(new BorderLayout());
        this.initialize(iconHolder, textHolder);
    }

    public LabelPanel(PropertyValueModel textHolder) {
        this(NullPropertyValueModel.instance(), textHolder);
    }

    protected void initialize(PropertyValueModel iconHolder, PropertyValueModel textHolder) {
        if (iconHolder == null || textHolder == null) {
            throw new NullPointerException();
        }
        iconHolder.addPropertyChangeListener("value", this.buildIconListener());
        textHolder.addPropertyChangeListener("value", this.buildTextListener());
        this.initializeLayout();
        this.setIcon((Icon)iconHolder.getValue());
        this.setText((String)textHolder.getValue());
    }

    protected PropertyChangeListener buildIconListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                LabelPanel.this.setIcon((Icon)e.getNewValue());
            }

            public String toString() {
                return "icon listener";
            }
        };
    }

    protected PropertyChangeListener buildTextListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                LabelPanel.this.setText((String)e.getNewValue());
            }

            public String toString() {
                return "text listener";
            }
        };
    }

    protected void initializeLayout() {
        this.label = this.buildLabel();
        this.label.setBorder(this.buildBorder());
        this.add((Component)this.label, "Before");
    }

    protected JLabel buildLabel() {
        return new JLabel();
    }

    protected Border buildBorder() {
        return BorderFactory.createEmptyBorder();
    }

    protected JLabel getLabel() {
        return this.label;
    }

    protected void setText(String text) {
        this.getLabel().setText(text);
    }

    protected void setIcon(Icon icon) {
        this.getLabel().setIcon(icon);
    }
}

